/*M!999999\- enable the sandbox mode */ 

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
INSERT INTO `account_transactions` VALUES
(1,1,'credit','opening_balance',100000.0000,NULL,'2025-04-20 22:37:59',1,NULL,NULL,NULL,NULL,NULL,'2025-04-20 22:37:59','2025-04-20 22:37:59'),
(2,1,'credit',NULL,5625.0000,NULL,'2025-04-20 22:17:42',1,89,84,NULL,NULL,'2025-04-21 21:37:33','2025-04-20 22:38:41','2025-04-21 21:37:33'),
(3,1,'debit',NULL,5000.0000,NULL,'2025-04-20 22:39:00',1,95,85,NULL,NULL,'2025-05-08 16:37:19','2025-04-20 22:39:47','2025-05-08 16:37:19'),
(4,1,'credit',NULL,6500.0000,NULL,'2025-05-02 13:05:00',1,99,87,NULL,NULL,'2025-05-08 16:37:05','2025-05-08 16:35:34','2025-05-08 16:37:05');
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_acc_trans_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_acc_trans_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_acc_trans_mappings` WRITE;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_account_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_type` varchar(191) DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `show_balance` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=155 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_account_types` WRITE;
/*!40000 ALTER TABLE `accounting_account_types` DISABLE KEYS */;
INSERT INTO `accounting_account_types` VALUES
(1,'accounts_receivable',NULL,NULL,'asset','sub_type',NULL,NULL,0,NULL,NULL),
(2,'current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(3,'cash_and_cash_equivalents',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(4,'fixed_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(5,'non_current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),
(6,'accounts_payable',NULL,NULL,'liability','sub_type',NULL,NULL,0,NULL,NULL),
(7,'credit_card',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),
(8,'current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),
(9,'non_current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),
(10,'owners_equity',NULL,NULL,'equity','sub_type',NULL,NULL,1,NULL,NULL),
(11,'income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),
(12,'other_income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),
(13,'cost_of_sale',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),
(14,'expenses',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),
(15,'other_expense',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),
(16,'accounts_receivable',NULL,NULL,NULL,'detail_type',1,'',1,NULL,NULL),
(17,'allowance_for_bad_debts',NULL,NULL,NULL,'detail_type',2,'allowance_for_bad_debts_desc',1,NULL,NULL),
(18,'assets_available_for_sale',NULL,NULL,NULL,'detail_type',2,'assets_available_for_sale_desc',1,NULL,NULL),
(19,'development_costs',NULL,NULL,NULL,'detail_type',2,'development_costs_desc',1,NULL,NULL),
(20,'employee_cash_advances',NULL,NULL,NULL,'detail_type',2,'employee_cash_advances_desc',1,NULL,NULL),
(21,'inventory',NULL,NULL,NULL,'detail_type',2,'inventory_desc',1,NULL,NULL),
(22,'investments_-_other',NULL,NULL,NULL,'detail_type',2,'investments_-_other_desc',1,NULL,NULL),
(23,'loans_to_officers',NULL,NULL,NULL,'detail_type',2,'loans_to_officers_desc',1,NULL,NULL),
(24,'loans_to_others',NULL,NULL,NULL,'detail_type',2,'loans_to_others_desc',1,NULL,NULL),
(25,'loans_to_shareholders',NULL,NULL,NULL,'detail_type',2,'loans_to_shareholders_desc',1,NULL,NULL),
(26,'other_current_assets',NULL,NULL,NULL,'detail_type',2,'other_current_assets_desc',1,NULL,NULL),
(27,'prepaid_expenses',NULL,NULL,NULL,'detail_type',2,'prepaid_expenses_desc',1,NULL,NULL),
(28,'retainage',NULL,NULL,NULL,'detail_type',2,'retainage_desc',1,NULL,NULL),
(29,'undeposited_funds',NULL,NULL,NULL,'detail_type',2,'undeposited_funds_desc',1,NULL,NULL),
(30,'bank',NULL,NULL,NULL,'detail_type',3,'bank_desc',1,NULL,NULL),
(31,'cash_and_cash_equivalents',NULL,NULL,NULL,'detail_type',3,'cash_and_cash_equivalents_desc',1,NULL,NULL),
(32,'cash_on_hand',NULL,NULL,NULL,'detail_type',3,'cash_on_hand_desc',1,NULL,NULL),
(33,'client_trust_account',NULL,NULL,NULL,'detail_type',3,'client_trust_account_desc',1,NULL,NULL),
(34,'money_market',NULL,NULL,NULL,'detail_type',3,'money_market_desc',1,NULL,NULL),
(35,'rents_held_in_trust',NULL,NULL,NULL,'detail_type',3,'rents_held_in_trust_desc',1,NULL,NULL),
(36,'savings',NULL,NULL,NULL,'detail_type',3,'savings_desc',1,NULL,NULL),
(37,'accumulated_depletion',NULL,NULL,NULL,'detail_type',4,'accumulated_depletion_desc',1,NULL,NULL),
(38,'accumulated_depreciation_on_property,_plant_and_equipment',NULL,NULL,NULL,'detail_type',4,'accumulated_depreciation_on_property,_plant_and_equipment_desc',1,NULL,NULL),
(39,'buildings',NULL,NULL,NULL,'detail_type',4,'buildings_desc',1,NULL,NULL),
(40,'depletable_assets',NULL,NULL,NULL,'detail_type',4,'depletable_assets_desc',1,NULL,NULL),
(41,'furniture_and_fixtures',NULL,NULL,NULL,'detail_type',4,'furniture_and_fixtures_desc',1,NULL,NULL),
(42,'land',NULL,NULL,NULL,'detail_type',4,'land_desc',1,NULL,NULL),
(43,'leasehold_improvements',NULL,NULL,NULL,'detail_type',4,'leasehold_improvements_desc',1,NULL,NULL),
(44,'machinery_and_equipment',NULL,NULL,NULL,'detail_type',4,'machinery_and_equipment_desc',1,NULL,NULL),
(45,'other_fixed_assets',NULL,NULL,NULL,'detail_type',4,'other_fixed_assets_desc',1,NULL,NULL),
(46,'vehicles',NULL,NULL,NULL,'detail_type',4,'vehicles_desc',1,NULL,NULL),
(47,'accumulated_amortisation_of_non-current_assets',NULL,NULL,NULL,'detail_type',5,'accumulated_amortisation_of_non-current_assets_desc',1,NULL,NULL),
(48,'assets_held_for_sale',NULL,NULL,NULL,'detail_type',5,'assets_held_for_sale_desc',1,NULL,NULL),
(49,'deferred_tax',NULL,NULL,NULL,'detail_type',5,'deferred_tax_desc',1,NULL,NULL),
(50,'goodwill',NULL,NULL,NULL,'detail_type',5,'goodwill_desc',1,NULL,NULL),
(51,'intangible_assets',NULL,NULL,NULL,'detail_type',5,'intangible_assets_desc',1,NULL,NULL),
(52,'lease_buyout',NULL,NULL,NULL,'detail_type',5,'lease_buyout_desc',1,NULL,NULL),
(53,'licences',NULL,NULL,NULL,'detail_type',5,'licences_desc',1,NULL,NULL),
(54,'long-term_investments',NULL,NULL,NULL,'detail_type',5,'long-term_investments_desc',1,NULL,NULL),
(55,'organisational_costs',NULL,NULL,NULL,'detail_type',5,'organisational_costs_desc',1,NULL,NULL),
(56,'other_non-current_assets',NULL,NULL,NULL,'detail_type',5,'other_non-current_assets_desc',1,NULL,NULL),
(57,'security_deposits',NULL,NULL,NULL,'detail_type',5,'security_deposits_desc',1,NULL,NULL),
(58,'accounts_payable_(a/p)',NULL,NULL,NULL,'detail_type',6,'accounts_payable_(a/p)_desc',1,NULL,NULL),
(59,'credit_card',NULL,NULL,NULL,'detail_type',7,'credit_card_desc',1,NULL,NULL),
(60,'accrued_liabilities',NULL,NULL,NULL,'detail_type',8,'accrued_liabilities_desc',1,NULL,NULL),
(61,'client_trust_accounts_-_liabilities',NULL,NULL,NULL,'detail_type',8,'client_trust_accounts_-_liabilities_desc',1,NULL,NULL),
(62,'current_tax_liability',NULL,NULL,NULL,'detail_type',8,'current_tax_liability_desc',1,NULL,NULL),
(63,'current_portion_of_obligations_under_finance_leases',NULL,NULL,NULL,'detail_type',8,'current_portion_of_obligations_under_finance_leases_desc',1,NULL,NULL),
(64,'dividends_payable',NULL,NULL,NULL,'detail_type',8,'dividends_payable_desc',1,NULL,NULL),
(65,'income_tax_payable',NULL,NULL,NULL,'detail_type',8,'income_tax_payable_desc',1,NULL,NULL),
(66,'insurance_payable',NULL,NULL,NULL,'detail_type',8,'insurance_payable_desc',1,NULL,NULL),
(67,'line_of_credit',NULL,NULL,NULL,'detail_type',8,'line_of_credit_desc',1,NULL,NULL),
(68,'loan_payable',NULL,NULL,NULL,'detail_type',8,'loan_payable_desc',1,NULL,NULL),
(69,'other_current_liabilities',NULL,NULL,NULL,'detail_type',8,'other_current_liabilities_desc',1,NULL,NULL),
(70,'payroll_clearing',NULL,NULL,NULL,'detail_type',8,'payroll_clearing_desc',1,NULL,NULL),
(71,'payroll_liabilities',NULL,NULL,NULL,'detail_type',8,'payroll_liabilities_desc',1,NULL,NULL),
(72,'prepaid_expenses_payable',NULL,NULL,NULL,'detail_type',8,'prepaid_expenses_payable_desc',1,NULL,NULL),
(73,'rents_in_trust_-_liability',NULL,NULL,NULL,'detail_type',8,'rents_in_trust_-_liability_desc',1,NULL,NULL),
(74,'sales_and_service_tax_payable',NULL,NULL,NULL,'detail_type',8,'sales_and_service_tax_payable_desc',1,NULL,NULL),
(75,'accrued_holiday_payable',NULL,NULL,NULL,'detail_type',9,'accrued_holiday_payable_desc',1,NULL,NULL),
(76,'accrued_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'accrued_non-current_liabilities_desc',1,NULL,NULL),
(77,'liabilities_related_to_assets_held_for_sale',NULL,NULL,NULL,'detail_type',9,'liabilities_related_to_assets_held_for_sale_desc',1,NULL,NULL),
(78,'long-term_debt',NULL,NULL,NULL,'detail_type',9,'long-term_debt_desc',1,NULL,NULL),
(79,'notes_payable',NULL,NULL,NULL,'detail_type',9,'notes_payable_desc',1,NULL,NULL),
(80,'other_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'other_non-current_liabilities_desc',1,NULL,NULL),
(81,'shareholder_notes_payable',NULL,NULL,NULL,'detail_type',9,'shareholder_notes_payable_desc',1,NULL,NULL),
(82,'accumulated_adjustment',NULL,NULL,NULL,'detail_type',10,'accumulated_adjustment_desc',1,NULL,NULL),
(83,'dividend_disbursed',NULL,NULL,NULL,'detail_type',10,'dividend_disbursed_desc',1,NULL,NULL),
(84,'equity_in_earnings_of_subsidiaries',NULL,NULL,NULL,'detail_type',10,'equity_in_earnings_of_subsidiaries_desc',1,NULL,NULL),
(85,'opening_balance_equity',NULL,NULL,NULL,'detail_type',10,'opening_balance_equity_desc',1,NULL,NULL),
(86,'ordinary_shares',NULL,NULL,NULL,'detail_type',10,'ordinary_shares_desc',1,NULL,NULL),
(87,'other_comprehensive_income',NULL,NULL,NULL,'detail_type',10,'other_comprehensive_income_desc',1,NULL,NULL),
(88,'owner\'s_equity',NULL,NULL,NULL,'detail_type',10,'owner\'s_equity_desc',1,NULL,NULL),
(89,'paid-in_capital_or_surplus',NULL,NULL,NULL,'detail_type',10,'paid-in_capital_or_surplus_desc',1,NULL,NULL),
(90,'partner_contributions',NULL,NULL,NULL,'detail_type',10,'partner_contributions_desc',1,NULL,NULL),
(91,'partner_distributions',NULL,NULL,NULL,'detail_type',10,'partner_distributions_desc',1,NULL,NULL),
(92,'partner\'s_equity',NULL,NULL,NULL,'detail_type',10,'partner\'s_equity_desc',1,NULL,NULL),
(93,'preferred_shares',NULL,NULL,NULL,'detail_type',10,'preferred_shares_desc',1,NULL,NULL),
(94,'retained_earnings',NULL,NULL,NULL,'detail_type',10,'retained_earnings_desc',1,NULL,NULL),
(95,'share_capital',NULL,NULL,NULL,'detail_type',10,'share_capital_desc',1,NULL,NULL),
(96,'treasury_shares',NULL,NULL,NULL,'detail_type',10,'treasury_shares_desc',1,NULL,NULL),
(97,'discounts/refunds_given',NULL,NULL,NULL,'detail_type',11,'discounts/refunds_given_desc',1,NULL,NULL),
(98,'non-profit_income',NULL,NULL,NULL,'detail_type',11,'non-profit_income_desc',1,NULL,NULL),
(99,'other_primary_income',NULL,NULL,NULL,'detail_type',11,'other_primary_income_desc',1,NULL,NULL),
(100,'revenue_-_general',NULL,NULL,NULL,'detail_type',11,'revenue_-_general_desc',1,NULL,NULL),
(101,'sales_-_retail',NULL,NULL,NULL,'detail_type',11,'sales_-_retail_desc',1,NULL,NULL),
(102,'sales_-_wholesale',NULL,NULL,NULL,'detail_type',11,'sales_-_wholesale_desc',1,NULL,NULL),
(103,'sales_of_product_income',NULL,NULL,NULL,'detail_type',11,'sales_of_product_income_desc',1,NULL,NULL),
(104,'service/fee_income',NULL,NULL,NULL,'detail_type',11,'service/fee_income_desc',1,NULL,NULL),
(105,'unapplied_cash_payment_income',NULL,NULL,NULL,'detail_type',11,'unapplied_cash_payment_income_desc',1,NULL,NULL),
(106,'dividend_income',NULL,NULL,NULL,'detail_type',12,'dividend_income_desc',1,NULL,NULL),
(107,'interest_earned',NULL,NULL,NULL,'detail_type',12,'interest_earned_desc',1,NULL,NULL),
(108,'loss_on_disposal_of_assets',NULL,NULL,NULL,'detail_type',12,'loss_on_disposal_of_assets_desc',1,NULL,NULL),
(109,'other_investment_income',NULL,NULL,NULL,'detail_type',12,'other_investment_income_desc',1,NULL,NULL),
(110,'other_miscellaneous_income',NULL,NULL,NULL,'detail_type',12,'other_miscellaneous_income_desc',1,NULL,NULL),
(111,'other_operating_income',NULL,NULL,NULL,'detail_type',12,'other_operating_income_desc',1,NULL,NULL),
(112,'tax-exempt_interest',NULL,NULL,NULL,'detail_type',12,'tax-exempt_interest_desc',1,NULL,NULL),
(113,'unrealised_loss_on_securities,_net_of_tax',NULL,NULL,NULL,'detail_type',12,'unrealised_loss_on_securities,_net_of_tax_desc',1,NULL,NULL),
(114,'cost_of_labour_-_cos',NULL,NULL,NULL,'detail_type',13,'cost_of_labour_-_cos_desc',1,NULL,NULL),
(115,'equipment_rental_-_cos',NULL,NULL,NULL,'detail_type',13,'equipment_rental_-_cos_desc',1,NULL,NULL),
(116,'freight_and_delivery_-_cos',NULL,NULL,NULL,'detail_type',13,'freight_and_delivery_-_cos_desc',1,NULL,NULL),
(117,'other_costs_of_sales_-_cos',NULL,NULL,NULL,'detail_type',13,'other_costs_of_sales_-_cos_desc',1,NULL,NULL),
(118,'supplies_and_materials_-_cos',NULL,NULL,NULL,'detail_type',13,'supplies_and_materials_-_cos_desc',1,NULL,NULL),
(119,'advertising/promotional',NULL,NULL,NULL,'detail_type',14,'advertising/promotional_desc',1,NULL,NULL),
(120,'amortisation_expense',NULL,NULL,NULL,'detail_type',14,'amortisation_expense_desc',1,NULL,NULL),
(121,'auto',NULL,NULL,NULL,'detail_type',14,'auto_desc',1,NULL,NULL),
(122,'bad_debts',NULL,NULL,NULL,'detail_type',14,'bad_debts_desc',1,NULL,NULL),
(123,'bank_charges',NULL,NULL,NULL,'detail_type',14,'bank_charges_desc',1,NULL,NULL),
(124,'charitable_contributions',NULL,NULL,NULL,'detail_type',14,'charitable_contributions_desc',1,NULL,NULL),
(125,'commissions_and_fees',NULL,NULL,NULL,'detail_type',14,'commissions_and_fees_desc',1,NULL,NULL),
(126,'cost_of_labour',NULL,NULL,NULL,'detail_type',14,'cost_of_labour_desc',1,NULL,NULL),
(127,'dues_and_subscriptions',NULL,NULL,NULL,'detail_type',14,'dues_and_subscriptions_desc',1,NULL,NULL),
(128,'equipment_rental',NULL,NULL,NULL,'detail_type',14,'equipment_rental_desc',1,NULL,NULL),
(129,'finance_costs',NULL,NULL,NULL,'detail_type',14,'finance_costs_desc',1,NULL,NULL),
(130,'income_tax_expense',NULL,NULL,NULL,'detail_type',14,'income_tax_expense_desc',1,NULL,NULL),
(131,'insurance',NULL,NULL,NULL,'detail_type',14,'insurance_desc',1,NULL,NULL),
(132,'interest_paid',NULL,NULL,NULL,'detail_type',14,'interest_paid_desc',1,NULL,NULL),
(133,'legal_and_professional_fees',NULL,NULL,NULL,'detail_type',14,'legal_and_professional_fees_desc',1,NULL,NULL),
(134,'loss_on_discontinued_operations,_net_of_tax',NULL,NULL,NULL,'detail_type',14,'loss_on_discontinued_operations,_net_of_tax_desc',1,NULL,NULL),
(135,'management_compensation',NULL,NULL,NULL,'detail_type',14,'management_compensation_desc',1,NULL,NULL),
(136,'meals_and_entertainment',NULL,NULL,NULL,'detail_type',14,'meals_and_entertainment_desc',1,NULL,NULL),
(137,'office/general_administrative_expenses',NULL,NULL,NULL,'detail_type',14,'office/general_administrative_expenses_desc',1,NULL,NULL),
(138,'other_miscellaneous_service_cost',NULL,NULL,NULL,'detail_type',14,'other_miscellaneous_service_cost_desc',1,NULL,NULL),
(139,'other_selling_expenses',NULL,NULL,NULL,'detail_type',14,'other_selling_expenses_desc',1,NULL,NULL),
(140,'payroll_expenses',NULL,NULL,NULL,'detail_type',14,'payroll_expenses_desc',1,NULL,NULL),
(141,'rent_or_lease_of_buildings',NULL,NULL,NULL,'detail_type',14,'rent_or_lease_of_buildings_desc',1,NULL,NULL),
(142,'repair_and_maintenance',NULL,NULL,NULL,'detail_type',14,'repair_and_maintenance_desc',1,NULL,NULL),
(143,'shipping_and_delivery_expense',NULL,NULL,NULL,'detail_type',14,'shipping_and_delivery_expense_desc',1,NULL,NULL),
(144,'supplies_and_materials',NULL,NULL,NULL,'detail_type',14,'supplies_and_materials_desc',1,NULL,NULL),
(145,'taxes_paid',NULL,NULL,NULL,'detail_type',14,'taxes_paid_desc',1,NULL,NULL),
(146,'travel_expenses_-_general_and_admin_expenses',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_general_and_admin_expenses_desc',1,NULL,NULL),
(147,'travel_expenses_-_selling_expense',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_selling_expense_desc',1,NULL,NULL),
(148,'unapplied_cash_bill_payment_expense',NULL,NULL,NULL,'detail_type',14,'unapplied_cash_bill_payment_expense_desc',1,NULL,NULL),
(149,'utilities',NULL,NULL,NULL,'detail_type',14,'utilities_desc',1,NULL,NULL),
(150,'amortisation',NULL,NULL,NULL,'detail_type',15,'amortisation_desc',1,NULL,NULL),
(151,'depreciation',NULL,NULL,NULL,'detail_type',15,'depreciation_desc',1,NULL,NULL),
(152,'exchange_gain_or_loss',NULL,NULL,NULL,'detail_type',15,'exchange_gain_or_loss_desc',1,NULL,NULL),
(153,'other_expense',NULL,NULL,NULL,'detail_type',15,'other_expense_desc',1,NULL,NULL),
(154,'penalties_and_settlements',NULL,NULL,NULL,'detail_type',15,'penalties_and_settlements_desc',1,NULL,NULL);
/*!40000 ALTER TABLE `accounting_account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `gl_code` varchar(191) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_sub_type_id` bigint(20) DEFAULT NULL,
  `detail_type_id` bigint(20) DEFAULT NULL,
  `parent_account_id` bigint(20) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts` WRITE;
/*!40000 ALTER TABLE `accounting_accounts` DISABLE KEYS */;
INSERT INTO `accounting_accounts` VALUES
(1,'Accounts Payable (A/P)',NULL,1,'liability',6,58,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(2,'Credit Card',NULL,1,'liability',7,59,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(3,'Wage expenses',NULL,1,'expenses',14,140,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(4,'Utilities',NULL,1,'expenses',14,149,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(5,'Unrealised loss on securities, net of tax',NULL,1,'income',12,113,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(6,'Undeposited Funds',NULL,1,'asset',2,29,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(7,'Uncategorised Income',NULL,1,'income',11,103,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(8,'Uncategorised Expense',NULL,1,'expenses',14,138,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(9,'Uncategorised Asset',NULL,1,'asset',2,26,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(10,'Unapplied Cash Payment Income',NULL,1,'income',11,105,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(11,'Travel expenses - selling expense',NULL,1,'expenses',14,147,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(12,'Travel expenses - general and admin expenses',NULL,1,'expenses',14,146,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(13,'Supplies',NULL,1,'expenses',14,145,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(14,'Subcontractors - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(15,'Stationery and printing',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(16,'Short-term debit',NULL,1,'liability',8,69,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(17,'Shipping and delivery expense',NULL,1,'expenses',14,143,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(18,'Share capital',NULL,1,'equity',10,95,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(19,'Sales of Product Income',NULL,1,'income',11,103,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(20,'Sales - wholesale',NULL,1,'income',11,102,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(21,'Sales - retail',NULL,1,'income',11,101,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(22,'Sales',NULL,1,'income',11,103,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(23,'Revenue - General',NULL,1,'income',11,100,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(24,'Retained Earnings',NULL,1,'equity',10,94,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(25,'Repair and maintenance',NULL,1,'expenses',14,142,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(26,'Rent or lease payments',NULL,1,'expenses',14,141,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(27,'Reconciliation Discrepancies',NULL,1,'expenses',15,153,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(28,'Purchases',NULL,1,'expenses',14,144,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(29,'Property, plant and equipment',NULL,1,'asset',4,42,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(30,'Prepaid Expenses',NULL,1,'asset',2,27,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(31,'Payroll liabilities',NULL,1,'liability',8,71,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(32,'Payroll Expenses',NULL,1,'expenses',14,140,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(33,'Payroll Clearing',NULL,1,'liability',8,70,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(34,'Overhead - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(35,'Other Types of Expenses-Advertising Expenses',NULL,1,'expenses',14,119,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(36,'Other selling expenses',NULL,1,'expenses',14,139,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(37,'Other operating income (expenses)',NULL,1,'income',12,111,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(38,'Other general and administrative expenses',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(39,'Other comprehensive income',NULL,1,'equity',10,87,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(40,'Other - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(41,'Office expenses',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(42,'Meals and entertainment',NULL,1,'expenses',14,137,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(43,'Materials - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(44,'Management compensation',NULL,1,'expenses',14,135,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(45,'Loss on disposal of assets',NULL,1,'income',12,108,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(46,'Loss on discontinued operations, net of tax',NULL,1,'expenses',14,134,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(47,'Long-term investments',NULL,1,'asset',5,54,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(48,'Long-term debt',NULL,1,'liability',9,78,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(49,'Liabilities related to assets held for sale',NULL,1,'liability',9,77,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(50,'Legal and professional fees',NULL,1,'expenses',14,133,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(51,'Inventory Asset',NULL,1,'asset',2,21,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(52,'Inventory',NULL,1,'asset',2,21,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(53,'Interest income',NULL,1,'income',12,107,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(54,'Interest expense',NULL,1,'expenses',14,132,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(55,'Intangibles',NULL,1,'asset',5,51,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(56,'Insurance - Liability',NULL,1,'expenses',14,131,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(57,'Insurance - General',NULL,1,'expenses',14,131,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(58,'Insurance - Disability',NULL,1,'expenses',14,131,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(59,'Income tax payable',NULL,1,'liability',8,65,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(60,'Income tax expense',NULL,1,'expenses',14,130,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(61,'Goodwill',NULL,1,'asset',5,50,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(62,'Freight and delivery - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(63,'Equity in earnings of subsidiaries',NULL,1,'equity',10,84,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(64,'Equipment rental',NULL,1,'expenses',14,128,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(65,'Dues and Subscriptions',NULL,1,'expenses',14,127,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(66,'Dividends payable',NULL,1,'liability',8,64,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(67,'Dividend income',NULL,1,'income',12,106,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(68,'Dividend disbursed',NULL,1,'equity',10,83,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(69,'Discounts given - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(70,'Direct labour - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(71,'Deferred tax assets',NULL,1,'asset',5,49,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(72,'Cost of sales',NULL,1,'expenses',13,118,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(73,'Commissions and fees',NULL,1,'expenses',14,125,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(74,'Change in inventory - COS',NULL,1,'expenses',13,114,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(75,'Cash and cash equivalents',NULL,1,'asset',3,31,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(76,'Billable Expense Income',NULL,1,'income',11,103,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(77,'Bank charges',NULL,1,'expenses',14,123,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(78,'Bad debts',NULL,1,'expenses',14,122,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(79,'Available for sale assets (short-term)',NULL,1,'asset',2,18,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(80,'Assets held for sale',NULL,1,'asset',5,48,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(81,'Amortisation expense',NULL,1,'expenses',14,120,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(82,'Allowance for bad debts',NULL,1,'asset',2,17,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(83,'Accumulated depreciation on property, plant and equipment',NULL,1,'asset',4,38,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(84,'Accrued non-current liabilities',NULL,1,'liability',9,76,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(85,'Accrued liabilities',NULL,1,'liability',8,60,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(86,'Accrued holiday payable',NULL,1,'liability',9,75,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07'),
(87,'Accounts Receivable (A/R)',NULL,1,'asset',1,16,NULL,NULL,'active',1,'2025-04-07 16:07:07','2025-04-07 16:07:07');
/*!40000 ALTER TABLE `accounting_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `acc_trans_mapping_id` int(11) DEFAULT NULL COMMENT 'id form accounting_acc_trans_mapping table',
  `transaction_id` int(11) DEFAULT NULL COMMENT 'id form transactions table',
  `transaction_payment_id` int(11) DEFAULT NULL COMMENT 'id form transaction_payments table',
  `amount` decimal(22,4) NOT NULL,
  `type` varchar(100) NOT NULL COMMENT 'debit, credit etc',
  `sub_type` varchar(100) NOT NULL,
  `map_type` varchar(100) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounting_accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_budgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_budgets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `financial_year` int(11) NOT NULL,
  `jan` decimal(22,4) DEFAULT NULL,
  `feb` decimal(22,4) DEFAULT NULL,
  `mar` decimal(22,4) DEFAULT NULL,
  `apr` decimal(22,4) DEFAULT NULL,
  `may` decimal(22,4) DEFAULT NULL,
  `jun` decimal(22,4) DEFAULT NULL,
  `jul` decimal(22,4) DEFAULT NULL,
  `aug` decimal(22,4) DEFAULT NULL,
  `sep` decimal(22,4) DEFAULT NULL,
  `oct` decimal(22,4) DEFAULT NULL,
  `nov` decimal(22,4) DEFAULT NULL,
  `dec` decimal(22,4) DEFAULT NULL,
  `quarter_1` decimal(22,4) DEFAULT NULL,
  `quarter_2` decimal(22,4) DEFAULT NULL,
  `quarter_3` decimal(22,4) DEFAULT NULL,
  `quarter_4` decimal(22,4) DEFAULT NULL,
  `yearly` decimal(22,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_budgets` WRITE;
/*!40000 ALTER TABLE `accounting_budgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_budgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `account_details` text DEFAULT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES
(1,1,'Caisse','02552350001','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',0,NULL,1,0,NULL,'2025-04-20 22:37:59','2025-04-20 22:37:59');
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) DEFAULT NULL,
  `event` varchar(191) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) DEFAULT NULL,
  `properties` text DEFAULT NULL,
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=352 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES
(1,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-06 19:30:08','2025-02-06 19:30:08'),
(2,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-07 16:21:32','2025-02-07 16:21:32'),
(3,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-07 16:26:00','2025-02-07 16:26:00'),
(4,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-07 17:39:45','2025-02-07 17:39:45'),
(5,'default','added',2,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-02-07 18:06:34','2025-02-07 18:06:34'),
(6,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-08 16:48:08','2025-02-08 16:48:08'),
(7,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-08 16:48:31','2025-02-08 16:48:31'),
(8,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-08 19:16:22','2025-02-08 19:16:22'),
(9,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-10 09:43:29','2025-02-10 09:43:29'),
(10,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-16 13:46:11','2025-02-16 13:46:11'),
(11,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-16 15:03:46','2025-02-16 15:03:46'),
(12,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-18 03:35:44','2025-02-18 03:35:44'),
(13,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-18 17:02:55','2025-02-18 17:02:55'),
(14,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-18 23:38:51','2025-02-18 23:38:51'),
(15,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-23 14:19:06','2025-02-23 14:19:06'),
(16,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-24 11:51:47','2025-02-24 11:51:47'),
(17,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-27 18:29:54','2025-02-27 18:29:54'),
(18,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-27 19:23:45','2025-02-27 19:23:45'),
(19,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-28 12:04:34','2025-02-28 12:04:34'),
(20,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-28 12:08:25','2025-02-28 12:08:25'),
(21,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-02 06:23:36','2025-03-02 06:23:36'),
(22,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-03 20:46:26','2025-03-03 20:46:26'),
(23,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-09 16:56:04','2025-03-09 16:56:04'),
(24,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-09 16:57:00','2025-03-09 16:57:00'),
(25,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-11 05:21:35','2025-03-11 05:21:35'),
(26,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-12 10:21:57','2025-03-12 10:21:57'),
(27,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-13 09:33:13','2025-03-13 09:33:13'),
(28,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-15 05:45:53','2025-03-15 05:45:53'),
(29,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-23 14:07:16','2025-03-23 14:07:16'),
(30,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-25 16:15:53','2025-03-25 16:15:53'),
(31,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-27 18:19:35','2025-03-27 18:19:35'),
(32,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-30 04:05:58','2025-03-30 04:05:58'),
(33,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-03-31 22:09:31','2025-03-31 22:09:31'),
(34,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-01 23:27:37','2025-04-01 23:27:37'),
(35,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-03 14:45:25','2025-04-03 14:45:25'),
(36,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-05 16:10:32','2025-04-05 16:10:32'),
(37,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-06 18:41:59','2025-04-06 18:41:59'),
(38,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-06 18:43:33','2025-04-06 18:43:33'),
(39,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-06 18:43:52','2025-04-06 18:43:52'),
(40,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-06 18:43:53','2025-04-06 18:43:53'),
(41,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-06 18:44:17','2025-04-06 18:44:17'),
(42,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-06 18:53:35','2025-04-06 18:53:35'),
(43,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-06 21:10:38','2025-04-06 21:10:38'),
(44,'default','added',2,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":167.5}}',NULL,'2025-04-06 21:25:08','2025-04-06 21:25:08'),
(45,'default','shipping_edited',2,'App\\Transaction',NULL,1,1,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"packed\",\"payment_status\":\"paid\",\"final_total\":\"167.5000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"167.5000\"}}',NULL,'2025-04-06 21:27:35','2025-04-06 21:27:35'),
(46,'default','created',1,'Modules\\Project\\Entities\\Project','created',NULL,1,'App\\User','{\"attributes\":{\"id\":1,\"business_id\":1,\"name\":\"Biell\",\"contact_id\":1,\"status\":\"on_hold\",\"lead_id\":1,\"start_date\":\"2025-04-06 00:00:00\",\"end_date\":\"2025-04-08 00:00:00\",\"description\":null,\"created_by\":1,\"settings\":{\"enable_timelog\":1,\"enable_invoice\":1,\"enable_notes_documents\":1,\"members_crud_task\":0,\"members_crud_note\":0,\"members_crud_timelog\":0,\"task_view\":\"list_view\",\"task_id_prefix\":\"#\"},\"custom_field1\":null,\"custom_field2\":null,\"custom_field3\":null,\"custom_field4\":null,\"created_at\":\"2025-04-06T21:39:01.000000Z\",\"updated_at\":\"2025-04-06T21:39:01.000000Z\"}}',NULL,'2025-04-06 21:39:01','2025-04-06 21:39:01'),
(47,'default','login',4,'App\\User',NULL,1,4,'App\\User','[]',NULL,'2025-04-06 21:45:02','2025-04-06 21:45:02'),
(48,'default','logout',4,'App\\User',NULL,1,4,'App\\User','[]',NULL,'2025-04-06 21:48:27','2025-04-06 21:48:27'),
(49,'default','login',4,'App\\User',NULL,1,4,'App\\User','[]',NULL,'2025-04-06 21:48:40','2025-04-06 21:48:40'),
(50,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-07 21:23:58','2025-04-07 21:23:58'),
(51,'default','added',4,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":227.5}}',NULL,'2025-04-07 17:00:29','2025-04-07 17:00:29'),
(52,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-09 02:19:41','2025-04-09 02:19:41'),
(53,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-09 02:21:37','2025-04-09 02:21:37'),
(54,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-09 02:22:07','2025-04-09 02:22:07'),
(55,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-09 09:57:22','2025-04-09 09:57:22'),
(56,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-10 21:35:33','2025-04-10 21:35:33'),
(57,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-13 11:16:50','2025-04-13 11:16:50'),
(58,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 02:48:48','2025-04-20 02:48:48'),
(59,'default','added',5,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":167.5}}',NULL,'2025-04-20 02:52:47','2025-04-20 02:52:47'),
(60,'default','added',6,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":167.5}}',NULL,'2025-04-20 02:55:31','2025-04-20 02:55:31'),
(61,'default','added',7,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":167.5}}',NULL,'2025-04-20 02:55:31','2025-04-20 02:55:31'),
(62,'default','added',8,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":167.5}}',NULL,'2025-04-20 02:56:25','2025-04-20 02:56:25'),
(63,'default','added',9,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":167.5}}',NULL,'2025-04-20 02:56:55','2025-04-20 02:56:55'),
(64,'default','added',10,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":37500}}',NULL,'2025-04-20 03:02:55','2025-04-20 03:02:55'),
(65,'default','added',11,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32495}}',NULL,'2025-04-19 22:41:20','2025-04-19 22:41:20'),
(66,'default','added',4,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-04-19 22:44:50','2025-04-19 22:44:50'),
(67,'default','sell_deleted',10,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":10,\"invoice_no\":\"0007\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"37500.0000\"}}',NULL,'2025-04-19 23:43:07','2025-04-19 23:43:07'),
(68,'default','sell_deleted',8,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":8,\"invoice_no\":\"0005\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"167.5000\"}}',NULL,'2025-04-19 23:43:19','2025-04-19 23:43:19'),
(69,'default','sell_deleted',11,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":11,\"invoice_no\":\"0008\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"32495.0000\"}}',NULL,'2025-04-19 23:43:21','2025-04-19 23:43:21'),
(70,'default','sell_deleted',4,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":4,\"invoice_no\":\"0002\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"227.5000\"}}',NULL,'2025-04-19 23:43:21','2025-04-19 23:43:21'),
(71,'default','sell_deleted',9,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":9,\"invoice_no\":\"0006\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"167.5000\"}}',NULL,'2025-04-19 23:43:22','2025-04-19 23:43:22'),
(72,'default','sell_deleted',6,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":6,\"invoice_no\":\"0004\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"167.5000\"}}',NULL,'2025-04-19 23:43:39','2025-04-19 23:43:39'),
(73,'default','sell_deleted',7,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":7,\"invoice_no\":\"0004\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"167.5000\"}}',NULL,'2025-04-19 23:43:42','2025-04-19 23:43:42'),
(74,'default','sell_deleted',2,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":2,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"packed\",\"payment_status\":\"paid\",\"final_total\":\"167.5000\"}}',NULL,'2025-04-19 23:43:45','2025-04-19 23:43:45'),
(75,'default','added',12,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5535}}',NULL,'2025-04-19 23:44:44','2025-04-19 23:44:44'),
(76,'default','added',13,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1080}}',NULL,'2025-04-19 23:45:57','2025-04-19 23:45:57'),
(77,'default','added',14,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":720}}',NULL,'2025-04-19 23:46:51','2025-04-19 23:46:51'),
(78,'default','added',15,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":990}}',NULL,'2025-04-19 23:49:22','2025-04-19 23:49:22'),
(79,'default','added',16,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":167.5}}',NULL,'2025-04-19 23:51:39','2025-04-19 23:51:39'),
(80,'default','added',17,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2025-04-19 23:52:01','2025-04-19 23:52:01'),
(81,'default','added',18,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":760}}',NULL,'2025-04-19 23:55:42','2025-04-19 23:55:42'),
(82,'default','sell_deleted',18,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":18,\"invoice_no\":\"0015\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"760.0000\"}}',NULL,'2025-04-19 23:58:44','2025-04-19 23:58:44'),
(83,'default','added',19,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2025-04-19 23:59:20','2025-04-19 23:59:20'),
(84,'default','added',20,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":335}}',NULL,'2025-04-20 00:01:26','2025-04-20 00:01:26'),
(85,'default','sell_deleted',20,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":20,\"invoice_no\":\"0017\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"335.0000\"}}',NULL,'2025-04-20 00:05:19','2025-04-20 00:05:20'),
(86,'default','sell_deleted',17,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":17,\"invoice_no\":\"0014\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"300.0000\"}}',NULL,'2025-04-20 00:05:20','2025-04-20 00:05:20'),
(87,'default','sell_deleted',19,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":19,\"invoice_no\":\"0016\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"360.0000\"}}',NULL,'2025-04-20 00:05:24','2025-04-20 00:05:24'),
(88,'default','sell_deleted',14,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":14,\"invoice_no\":\"0011\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"720.0000\"}}',NULL,'2025-04-20 00:05:27','2025-04-20 00:05:27'),
(89,'default','sell_deleted',15,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":15,\"invoice_no\":\"0012\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"990.0000\"}}',NULL,'2025-04-20 00:05:27','2025-04-20 00:05:28'),
(90,'default','sell_deleted',16,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":16,\"invoice_no\":\"0013\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"167.5000\"}}',NULL,'2025-04-20 00:05:28','2025-04-20 00:05:28'),
(91,'default','sell_deleted',13,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":13,\"invoice_no\":\"0010\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1080.0000\"}}',NULL,'2025-04-20 00:05:29','2025-04-20 00:05:29'),
(92,'default','sell_deleted',12,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":12,\"invoice_no\":\"0009\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5535.0000\"}}',NULL,'2025-04-20 00:05:29','2025-04-20 00:05:29'),
(93,'default','added',21,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2025-04-20 00:07:35','2025-04-20 00:07:35'),
(94,'default','added',22,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2025-04-20 00:08:21','2025-04-20 00:08:21'),
(95,'default','sell_deleted',21,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":21,\"invoice_no\":\"0018\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5000.0000\"}}',NULL,'2025-04-20 00:09:38','2025-04-20 00:09:38'),
(96,'default','sell_deleted',22,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":22,\"invoice_no\":\"0019\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15000.0000\"}}',NULL,'2025-04-20 00:09:40','2025-04-20 00:09:40'),
(97,'default','added',23,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8000}}',NULL,'2025-04-20 00:10:52','2025-04-20 00:10:52'),
(98,'default','added',24,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2025-04-20 00:12:59','2025-04-20 00:12:59'),
(99,'default','sell_deleted',24,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":24,\"invoice_no\":\"0021\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15000.0000\"}}',NULL,'2025-04-20 00:15:45','2025-04-20 00:15:45'),
(100,'default','sell_deleted',23,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":23,\"invoice_no\":\"0020\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8000.0000\"}}',NULL,'2025-04-20 00:15:48','2025-04-20 00:15:48'),
(101,'default','added',25,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000}}',NULL,'2025-04-20 00:16:22','2025-04-20 00:16:22'),
(102,'default','added',26,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25000}}',NULL,'2025-04-20 00:17:19','2025-04-20 00:17:19'),
(103,'default','sell_deleted',25,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":25,\"invoice_no\":\"0022\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10000.0000\"}}',NULL,'2025-04-20 00:19:50','2025-04-20 00:19:50'),
(104,'default','sell_deleted',26,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":26,\"invoice_no\":\"0023\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25000.0000\"}}',NULL,'2025-04-20 00:19:52','2025-04-20 00:19:52'),
(105,'default','added',27,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2025-04-20 00:20:35','2025-04-20 00:20:35'),
(106,'default','added',28,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2025-04-20 00:20:57','2025-04-20 00:20:57'),
(107,'default','sell_deleted',27,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":27,\"invoice_no\":\"0024\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15000.0000\"}}',NULL,'2025-04-20 00:22:57','2025-04-20 00:22:57'),
(108,'default','sell_deleted',28,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":28,\"invoice_no\":\"0025\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15000.0000\"}}',NULL,'2025-04-20 00:22:59','2025-04-20 00:22:59'),
(109,'default','added',29,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20000}}',NULL,'2025-04-20 00:23:51','2025-04-20 00:23:51'),
(110,'default','sell_deleted',29,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":29,\"invoice_no\":\"0026\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"20000.0000\"}}',NULL,'2025-04-20 00:25:28','2025-04-20 00:25:28'),
(111,'default','added',30,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2025-04-20 00:26:26','2025-04-20 00:26:26'),
(112,'default','sell_deleted',30,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":30,\"invoice_no\":\"0027\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15000.0000\"}}',NULL,'2025-04-20 00:27:33','2025-04-20 00:27:33'),
(113,'default','added',31,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2025-04-20 00:27:51','2025-04-20 00:27:51'),
(114,'default','sell_deleted',31,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":31,\"invoice_no\":\"0028\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15000.0000\"}}',NULL,'2025-04-20 00:29:26','2025-04-20 00:29:26'),
(115,'default','added',5,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 00:31:22','2025-04-20 00:31:22'),
(116,'default','added',6,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 00:31:23','2025-04-20 00:31:23'),
(117,'default','added',32,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4000}}',NULL,'2025-04-20 00:31:46','2025-04-20 00:31:46'),
(118,'default','added',33,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2025-04-20 00:32:41','2025-04-20 00:32:41'),
(119,'default','sell_deleted',33,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":33,\"invoice_no\":\"0030\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6000.0000\"}}',NULL,'2025-04-20 00:33:46','2025-04-20 00:33:46'),
(120,'default','sell_deleted',32,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":32,\"invoice_no\":\"0029\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4000.0000\"}}',NULL,'2025-04-20 00:33:49','2025-04-20 00:33:49'),
(121,'default','added',34,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2025-04-20 00:34:33','2025-04-20 00:34:33'),
(122,'default','sell_deleted',34,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":34,\"invoice_no\":\"0031\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6000.0000\"}}',NULL,'2025-04-20 00:35:51','2025-04-20 00:35:51'),
(123,'default','added',35,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-04-20 00:36:25','2025-04-20 00:36:25'),
(124,'default','sell_deleted',35,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":35,\"invoice_no\":\"0032\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"}}',NULL,'2025-04-20 00:40:32','2025-04-20 00:40:32'),
(125,'default','added',36,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-04-20 00:40:55','2025-04-20 00:40:55'),
(126,'default','added',37,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4500}}',NULL,'2025-04-20 00:41:44','2025-04-20 00:41:44'),
(127,'default','sell_deleted',36,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":36,\"invoice_no\":\"0033\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"}}',NULL,'2025-04-20 00:43:22','2025-04-20 00:43:22'),
(128,'default','sell_deleted',37,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":37,\"invoice_no\":\"0034\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4500.0000\"}}',NULL,'2025-04-20 00:43:23','2025-04-20 00:43:23'),
(129,'default','added',38,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2025-04-20 00:43:51','2025-04-20 00:43:51'),
(130,'default','sell_deleted',38,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":38,\"invoice_no\":\"0035\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6000.0000\"}}',NULL,'2025-04-20 00:46:00','2025-04-20 00:46:00'),
(131,'default','added',39,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6000}}',NULL,'2025-04-20 00:46:52','2025-04-20 00:46:52'),
(132,'default','added',40,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12000}}',NULL,'2025-04-20 00:48:00','2025-04-20 00:48:00'),
(133,'default','added',41,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4400}}',NULL,'2025-04-20 00:49:43','2025-04-20 00:49:43'),
(134,'default','added',42,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2025-04-20 00:50:30','2025-04-20 00:50:30'),
(135,'default','added',43,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4990}}',NULL,'2025-04-20 00:51:16','2025-04-20 00:51:16'),
(136,'default','added',44,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2025-04-20 00:51:42','2025-04-20 00:51:42'),
(137,'default','sell_deleted',39,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":39,\"invoice_no\":\"0036\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6000.0000\"}}',NULL,'2025-04-20 00:53:02','2025-04-20 00:53:02'),
(138,'default','sell_deleted',43,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":43,\"invoice_no\":\"0040\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4990.0000\"}}',NULL,'2025-04-20 00:53:25','2025-04-20 00:53:25'),
(139,'default','sell_deleted',41,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":41,\"invoice_no\":\"0038\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"}}',NULL,'2025-04-20 00:53:25','2025-04-20 00:53:25'),
(140,'default','sell_deleted',40,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":40,\"invoice_no\":\"0037\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12000.0000\"}}',NULL,'2025-04-20 00:53:25','2025-04-20 00:53:25'),
(141,'default','sell_deleted',42,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":42,\"invoice_no\":\"0039\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"}}',NULL,'2025-04-20 00:53:28','2025-04-20 00:53:29'),
(142,'default','sell_deleted',44,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":44,\"invoice_no\":\"0041\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5000.0000\"}}',NULL,'2025-04-20 00:53:29','2025-04-20 00:53:29'),
(143,'default','contact_deleted',5,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 00:54:21','2025-04-20 00:54:21'),
(144,'default','added',45,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2025-04-20 00:54:50','2025-04-20 00:54:50'),
(145,'default','added',46,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000}}',NULL,'2025-04-20 00:55:38','2025-04-20 00:55:38'),
(146,'default','sell_deleted',45,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":45,\"invoice_no\":\"0042\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5000.0000\"}}',NULL,'2025-04-20 00:56:48','2025-04-20 00:56:48'),
(147,'default','sell_deleted',46,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":46,\"invoice_no\":\"0043\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10000.0000\"}}',NULL,'2025-04-20 00:56:53','2025-04-20 00:56:53'),
(148,'default','added',47,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000}}',NULL,'2025-04-20 00:57:27','2025-04-20 00:57:27'),
(149,'default','sell_deleted',47,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":47,\"invoice_no\":\"0044\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10000.0000\"}}',NULL,'2025-04-20 00:58:54','2025-04-20 00:58:54'),
(150,'default','added',48,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000}}',NULL,'2025-04-20 00:59:34','2025-04-20 00:59:34'),
(151,'default','added',49,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2025-04-20 01:01:19','2025-04-20 01:01:19'),
(152,'default','added',50,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9999}}',NULL,'2025-04-20 01:02:19','2025-04-20 01:02:19'),
(153,'default','added',51,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10800}}',NULL,'2025-04-20 01:04:19','2025-04-20 01:04:19'),
(154,'default','sell_deleted',48,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":48,\"invoice_no\":\"0045\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10000.0000\"}}',NULL,'2025-04-20 01:05:22','2025-04-20 01:05:22'),
(155,'default','sell_deleted',50,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":50,\"invoice_no\":\"0047\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9999.0000\"}}',NULL,'2025-04-20 01:05:26','2025-04-20 01:05:26'),
(156,'default','sell_deleted',49,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":49,\"invoice_no\":\"0046\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15000.0000\"}}',NULL,'2025-04-20 01:05:29','2025-04-20 01:05:29'),
(157,'default','sell_deleted',51,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":51,\"invoice_no\":\"0048\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10800.0000\"}}',NULL,'2025-04-20 01:05:34','2025-04-20 01:05:34'),
(158,'default','added',52,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000}}',NULL,'2025-04-20 01:05:59','2025-04-20 01:05:59'),
(159,'default','sell_deleted',52,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":52,\"invoice_no\":\"0049\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10000.0000\"}}',NULL,'2025-04-20 01:08:56','2025-04-20 01:08:56'),
(160,'default','added',53,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2025-04-20 01:09:35','2025-04-20 01:09:35'),
(161,'default','added',54,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7500}}',NULL,'2025-04-20 01:10:52','2025-04-20 01:10:52'),
(162,'default','added',55,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":74800}}',NULL,'2025-04-20 01:13:20','2025-04-20 01:13:20'),
(163,'default','added',56,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 01:18:19','2025-04-20 01:18:19'),
(164,'default','added',57,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15000}}',NULL,'2025-04-20 01:26:21','2025-04-20 01:26:21'),
(165,'default','added',58,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18500}}',NULL,'2025-04-20 01:26:54','2025-04-20 01:26:54'),
(166,'default','sell_deleted',58,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":58,\"invoice_no\":\"0055\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"18500.0000\"}}',NULL,'2025-04-20 01:49:17','2025-04-20 01:49:17'),
(167,'default','sell_deleted',56,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":56,\"invoice_no\":\"0053\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 01:49:18','2025-04-20 01:49:18'),
(168,'default','sell_deleted',57,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":57,\"invoice_no\":\"0054\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15000.0000\"}}',NULL,'2025-04-20 01:49:20','2025-04-20 01:49:20'),
(169,'default','sell_deleted',55,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":55,\"invoice_no\":\"0052\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"74800.0000\"}}',NULL,'2025-04-20 01:49:21','2025-04-20 01:49:21'),
(170,'default','sell_deleted',54,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":54,\"invoice_no\":\"0051\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7500.0000\"}}',NULL,'2025-04-20 01:49:23','2025-04-20 01:49:23'),
(171,'default','sell_deleted',53,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":53,\"invoice_no\":\"0050\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5000.0000\"}}',NULL,'2025-04-20 01:49:23','2025-04-20 01:49:23'),
(172,'default','added',59,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 01:50:19','2025-04-20 01:50:19'),
(173,'default','added',60,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50000}}',NULL,'2025-04-20 01:50:57','2025-04-20 01:50:57'),
(174,'default','sell_deleted',59,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":59,\"invoice_no\":\"0056\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 01:52:13','2025-04-20 01:52:13'),
(175,'default','sell_deleted',60,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":60,\"invoice_no\":\"0057\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"50000.0000\"}}',NULL,'2025-04-20 01:52:20','2025-04-20 01:52:20'),
(176,'default','added',61,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 01:52:50','2025-04-20 01:52:50'),
(177,'default','added',62,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50000}}',NULL,'2025-04-20 01:53:44','2025-04-20 01:53:44'),
(178,'default','added',63,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225000}}',NULL,'2025-04-20 01:54:41','2025-04-20 01:54:41'),
(179,'default','sell_deleted',61,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":61,\"invoice_no\":\"0058\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 01:55:27','2025-04-20 01:55:27'),
(180,'default','sell_deleted',62,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":62,\"invoice_no\":\"0059\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"50000.0000\"}}',NULL,'2025-04-20 01:55:30','2025-04-20 01:55:30'),
(181,'default','sell_deleted',63,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":63,\"invoice_no\":\"0060\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"225000.0000\"}}',NULL,'2025-04-20 01:55:34','2025-04-20 01:55:34'),
(182,'default','added',64,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225000}}',NULL,'2025-04-20 01:56:20','2025-04-20 01:56:20'),
(183,'default','sell_deleted',64,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":64,\"invoice_no\":\"0061\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"225000.0000\"}}',NULL,'2025-04-20 01:57:26','2025-04-20 01:57:26'),
(184,'default','added',65,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300000}}',NULL,'2025-04-20 01:58:21','2025-04-20 01:58:21'),
(185,'default','added',66,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20000}}',NULL,'2025-04-20 01:58:49','2025-04-20 01:58:49'),
(186,'default','added',67,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40000}}',NULL,'2025-04-20 02:00:59','2025-04-20 02:00:59'),
(187,'default','sell_deleted',65,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":65,\"invoice_no\":\"0062\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"300000.0000\"}}',NULL,'2025-04-20 02:07:40','2025-04-20 02:07:40'),
(188,'default','sell_deleted',66,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":66,\"invoice_no\":\"0063\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"20000.0000\"}}',NULL,'2025-04-20 02:07:42','2025-04-20 02:07:42'),
(189,'default','sell_deleted',67,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":67,\"invoice_no\":\"0064\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"40000.0000\"}}',NULL,'2025-04-20 02:07:44','2025-04-20 02:07:44'),
(190,'default','added',7,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 02:09:02','2025-04-20 02:09:02'),
(191,'default','added',68,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000}}',NULL,'2025-04-20 02:11:33','2025-04-20 02:11:33'),
(192,'default','added',69,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12000}}',NULL,'2025-04-20 02:12:20','2025-04-20 02:12:20'),
(193,'default','sell_deleted',68,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":68,\"invoice_no\":\"0065\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10000.0000\"}}',NULL,'2025-04-20 02:17:21','2025-04-20 02:17:21'),
(194,'default','sell_deleted',69,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":69,\"invoice_no\":\"0066\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12000.0000\"}}',NULL,'2025-04-20 02:17:22','2025-04-20 02:17:22'),
(195,'default','added',70,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000}}',NULL,'2025-04-20 02:17:52','2025-04-20 02:17:52'),
(196,'default','sell_deleted',70,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":70,\"invoice_no\":\"0067\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10000.0000\"}}',NULL,'2025-04-20 02:19:23','2025-04-20 02:19:23'),
(197,'default','added',71,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10000}}',NULL,'2025-04-20 02:20:24','2025-04-20 02:20:24'),
(198,'default','added',72,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90000}}',NULL,'2025-04-20 02:21:21','2025-04-20 02:21:21'),
(199,'default','sell_deleted',72,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":72,\"invoice_no\":\"0069\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"90000.0000\"}}',NULL,'2025-04-20 02:22:38','2025-04-20 02:22:38'),
(200,'default','sell_deleted',71,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":71,\"invoice_no\":\"0068\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10000.0000\"}}',NULL,'2025-04-20 02:22:41','2025-04-20 02:22:41'),
(201,'default','added',73,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 02:24:50','2025-04-20 02:24:50'),
(202,'default','sell_deleted',73,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":73,\"invoice_no\":\"0070\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 02:27:46','2025-04-20 02:27:46'),
(203,'default','added',74,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 02:28:29','2025-04-20 02:28:29'),
(204,'default','edited',74,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 02:30:39','2025-04-20 02:30:39'),
(205,'default','sell_deleted',74,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":74,\"invoice_no\":\"0071\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 02:31:25','2025-04-20 02:31:25'),
(206,'default','added',75,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 02:32:50','2025-04-20 02:32:50'),
(207,'default','sell_deleted',75,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":75,\"invoice_no\":\"0072\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 02:34:32','2025-04-20 02:34:32'),
(208,'default','added',76,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 02:35:19','2025-04-20 02:35:19'),
(209,'default','sell_deleted',76,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":76,\"invoice_no\":\"0073\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 02:36:24','2025-04-20 02:36:24'),
(210,'default','added',77,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 02:37:20','2025-04-20 02:37:20'),
(211,'default','sell_deleted',77,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":77,\"invoice_no\":\"0074\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 02:38:39','2025-04-20 02:38:39'),
(212,'default','added',78,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 02:39:21','2025-04-20 02:39:21'),
(213,'default','edited',78,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 02:39:40','2025-04-20 02:39:40'),
(214,'default','sell_deleted',78,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":78,\"invoice_no\":\"0075\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 02:40:20','2025-04-20 02:40:20'),
(215,'default','contact_deleted',7,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 02:41:39','2025-04-20 02:41:39'),
(216,'default','contact_deleted',4,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 02:41:50','2025-04-20 02:41:50'),
(217,'default','added',79,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 02:43:00','2025-04-20 02:43:00'),
(218,'default','added',80,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 02:50:58','2025-04-20 02:50:58'),
(219,'default','added',81,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-04-20 02:52:01','2025-04-20 02:52:01'),
(220,'default','sell_deleted',79,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":79,\"invoice_no\":\"0076\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 02:55:37','2025-04-20 02:55:37'),
(221,'default','sell_deleted',80,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":80,\"invoice_no\":\"0077\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 02:55:39','2025-04-20 02:55:39'),
(222,'default','sell_deleted',81,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":81,\"invoice_no\":\"0078\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"}}',NULL,'2025-04-20 02:55:40','2025-04-20 02:55:40'),
(223,'default','added',82,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 02:56:45','2025-04-20 02:56:45'),
(224,'default','added',83,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100000}}',NULL,'2025-04-20 02:57:21','2025-04-20 02:57:21'),
(225,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 07:16:30','2025-04-20 07:16:30'),
(226,'default','sell_deleted',82,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":82,\"invoice_no\":\"0079\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 07:23:58','2025-04-20 07:23:58'),
(227,'default','sell_deleted',83,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":83,\"invoice_no\":\"0080\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100000.0000\"}}',NULL,'2025-04-20 07:24:21','2025-04-20 07:24:21'),
(228,'default','sell_deleted',5,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":5,\"invoice_no\":\"0003\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"167.5000\"}}',NULL,'2025-04-20 07:24:25','2025-04-20 07:24:25'),
(229,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 21:52:40','2025-04-20 21:52:40'),
(230,'default','added',85,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":25000}}',NULL,'2025-04-20 22:00:39','2025-04-20 22:00:39'),
(231,'default','added',86,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23750}}',NULL,'2025-04-20 22:01:44','2025-04-20 22:01:44'),
(232,'default','added',87,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 22:07:59','2025-04-20 22:07:59'),
(233,'default','sell_deleted',85,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":85,\"invoice_no\":\"0081\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"25000.0000\"}}',NULL,'2025-04-20 22:10:44','2025-04-20 22:10:44'),
(234,'default','sell_deleted',86,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":86,\"invoice_no\":\"0082\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"23750.0000\"}}',NULL,'2025-04-20 22:10:46','2025-04-20 22:10:46'),
(235,'default','added',89,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5625}}',NULL,'2025-04-20 22:17:42','2025-04-20 22:17:42'),
(236,'default','added',90,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 22:19:39','2025-04-20 22:19:39'),
(237,'default','added',91,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 22:21:20','2025-04-20 22:21:20'),
(238,'default','added',92,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 22:22:20','2025-04-20 22:22:20'),
(239,'default','added',93,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 22:23:32','2025-04-20 22:23:32'),
(240,'default','added',94,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-04-20 22:29:31','2025-04-20 22:29:31'),
(241,'default','added',95,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":45000}}',NULL,'2025-04-20 22:34:30','2025-04-20 22:34:30'),
(242,'default','payment_edited',95,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"45000.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"45000.0000\"}}',NULL,'2025-04-20 22:39:47','2025-04-20 22:39:47'),
(243,'default','added',96,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5625}}',NULL,'2025-04-20 22:41:37','2025-04-20 22:41:37'),
(244,'default','added',97,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5063}}',NULL,'2025-04-20 22:48:41','2025-04-20 22:48:41'),
(245,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-21 21:21:23','2025-04-21 21:21:23'),
(246,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-21 21:33:33','2025-04-21 21:33:33'),
(247,'default','sell_deleted',89,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":89,\"invoice_no\":\"0083\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5625.0000\"}}',NULL,'2025-04-21 21:37:33','2025-04-21 21:37:33'),
(248,'default','sell_deleted',96,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":96,\"invoice_no\":\"0084\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5625.0000\"}}',NULL,'2025-04-21 21:37:35','2025-04-21 21:37:35'),
(249,'default','sell_deleted',97,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":97,\"invoice_no\":\"0085\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5063.0000\"}}',NULL,'2025-04-21 21:37:37','2025-04-21 21:37:37'),
(250,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 05:16:14','2025-04-22 05:16:15'),
(251,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 13:06:48','2025-04-22 13:06:48'),
(252,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-22 23:02:34','2025-04-22 23:02:34'),
(253,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-23 00:01:30','2025-04-23 00:01:30'),
(254,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-25 04:15:39','2025-04-25 04:15:39'),
(255,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-26 17:02:55','2025-04-26 17:02:55'),
(256,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-27 19:16:32','2025-04-27 19:16:32'),
(257,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-04-28 13:52:44','2025-04-28 13:52:44'),
(258,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-01 11:30:00','2025-05-01 11:30:00'),
(259,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-01 22:50:25','2025-05-01 22:50:25'),
(260,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-01 22:55:55','2025-05-01 22:55:55'),
(261,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-01 23:33:58','2025-05-01 23:33:58'),
(262,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-02 02:25:49','2025-05-02 02:25:49'),
(263,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-02 02:39:49','2025-05-02 02:39:49'),
(264,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-02 06:11:01','2025-05-02 06:11:01'),
(265,'default','added',98,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":6500}}',NULL,'2025-05-02 06:30:05','2025-05-02 06:30:05'),
(266,'default','added',99,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-05-02 07:36:36','2025-05-02 07:36:36'),
(267,'default','shipping_edited',99,'App\\Transaction',NULL,1,1,'App\\User','{\"update_note\":null,\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"}}',NULL,'2025-05-02 07:37:37','2025-05-02 07:37:37'),
(268,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-02 12:31:48','2025-05-02 12:31:48'),
(269,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-02 17:35:51','2025-05-02 17:35:51'),
(270,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-02 17:51:18','2025-05-02 17:51:18'),
(271,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-03 04:30:37','2025-05-03 04:30:37'),
(272,'default','added',100,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13000}}',NULL,'2025-05-03 04:32:57','2025-05-03 04:32:57'),
(273,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-03 10:36:33','2025-05-03 10:36:33'),
(274,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-03 11:16:31','2025-05-03 11:16:31'),
(275,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-03 11:17:01','2025-05-03 11:17:01'),
(276,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-03 11:17:51','2025-05-03 11:17:51'),
(277,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-03 11:18:02','2025-05-03 11:18:02'),
(278,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-03 11:32:28','2025-05-03 11:32:28'),
(279,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-03 16:44:16','2025-05-03 16:44:16'),
(280,'default','added',101,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13000}}',NULL,'2025-05-03 17:25:25','2025-05-03 17:25:25'),
(281,'default','added',102,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-05-03 17:26:20','2025-05-03 17:26:20'),
(282,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-03 20:02:43','2025-05-03 20:02:43'),
(283,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-04 08:22:17','2025-05-04 08:22:17'),
(284,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-04 08:24:39','2025-05-04 08:24:39'),
(285,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-04 12:43:04','2025-05-04 12:43:04'),
(286,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-04 12:45:12','2025-05-04 12:45:12'),
(287,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-05 14:00:45','2025-05-05 14:00:45'),
(288,'default','added',103,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-05-05 14:06:45','2025-05-05 14:06:45'),
(289,'default','added',104,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-05-05 15:56:08','2025-05-05 15:56:08'),
(290,'default','added',105,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-05-05 15:58:11','2025-05-05 15:58:11'),
(291,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-05 23:32:23','2025-05-05 23:32:23'),
(292,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-07 08:23:12','2025-05-07 08:23:12'),
(293,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-07 08:39:14','2025-05-07 08:39:14'),
(294,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-07 17:04:06','2025-05-07 17:04:06'),
(295,'default','added',107,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-05-07 17:11:04','2025-05-07 17:11:04'),
(296,'default','sell_deleted',100,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":100,\"invoice_no\":\"0087\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13000.0000\"}}',NULL,'2025-05-07 17:11:26','2025-05-07 17:11:26'),
(297,'default','sell_deleted',101,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":101,\"invoice_no\":\"0088\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13000.0000\"}}',NULL,'2025-05-07 17:11:28','2025-05-07 17:11:28'),
(298,'default','sell_deleted',102,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":102,\"invoice_no\":\"0089\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"}}',NULL,'2025-05-07 17:11:30','2025-05-07 17:11:30'),
(299,'default','sell_deleted',103,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":103,\"invoice_no\":\"0090\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"}}',NULL,'2025-05-07 17:11:33','2025-05-07 17:11:33'),
(300,'default','sell_deleted',104,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":104,\"invoice_no\":\"0091\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"}}',NULL,'2025-05-07 17:11:35','2025-05-07 17:11:35'),
(301,'default','sell_deleted',105,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":105,\"invoice_no\":\"0092\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"}}',NULL,'2025-05-07 17:11:37','2025-05-07 17:11:37'),
(302,'default','sell_deleted',107,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":107,\"invoice_no\":\"0093\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"}}',NULL,'2025-05-07 17:11:40','2025-05-07 17:11:40'),
(303,'default','added',108,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"paid\",\"final_total\":13500}}',NULL,'2025-05-07 17:15:13','2025-05-07 17:15:13'),
(304,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-08 16:26:25','2025-05-08 16:26:25'),
(305,'default','sell_deleted',108,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":108,\"invoice_no\":\"0094\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"paid\",\"final_total\":\"13500.0000\"}}',NULL,'2025-05-08 16:26:51','2025-05-08 16:26:51'),
(306,'default','added',110,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-05-08 16:33:40','2025-05-08 16:33:40'),
(307,'default','added',111,'App\\Transaction',NULL,1,1,'App\\User','[]',NULL,'2025-05-08 16:34:32','2025-05-08 16:34:32'),
(308,'default','sell_deleted',99,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":99,\"invoice_no\":\"0086\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"delivered\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"}}',NULL,'2025-05-08 16:37:05','2025-05-08 16:37:05'),
(309,'default','purchase_deleted',95,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"partial\",\"final_total\":\"45000.0000\"}}',NULL,'2025-05-08 16:37:19','2025-05-08 16:37:19'),
(310,'default','edited',6,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-05-08 16:45:23','2025-05-08 16:45:23'),
(311,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-10 17:51:26','2025-05-10 17:51:26'),
(312,'default','edited',6,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2025-05-10 18:02:31','2025-05-10 18:02:31'),
(313,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-11 15:57:03','2025-05-11 15:57:03'),
(314,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-11 16:00:40','2025-05-11 16:00:40'),
(315,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-11 19:22:10','2025-05-11 19:22:10'),
(316,'default','added',112,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-05-11 19:23:47','2025-05-11 19:23:47'),
(317,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-12 07:45:01','2025-05-12 07:45:01'),
(318,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-16 11:33:12','2025-05-16 11:33:12'),
(319,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-17 09:55:17','2025-05-17 09:55:17'),
(320,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-19 07:17:30','2025-05-19 07:17:30'),
(321,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-19 15:40:56','2025-05-19 15:40:56'),
(322,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-21 17:10:31','2025-05-21 17:10:31'),
(323,'default','login',5,'App\\User',NULL,3,5,'App\\User','[]',NULL,'2025-05-24 05:19:51','2025-05-24 05:19:51'),
(324,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-27 08:57:15','2025-05-27 08:57:15'),
(325,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-04 01:34:21','2025-06-04 01:34:21'),
(326,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-04 12:56:32','2025-06-04 12:56:32'),
(327,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-04 13:05:13','2025-06-04 13:05:13'),
(328,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-08 08:30:01','2025-06-08 08:30:01'),
(329,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-10 04:05:14','2025-06-10 04:05:14'),
(330,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-10 04:16:12','2025-06-10 04:16:12'),
(331,'default','login',6,'App\\User',NULL,4,6,'App\\User','[]',NULL,'2025-06-20 07:44:18','2025-06-20 07:44:18'),
(332,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-22 16:40:15','2025-06-22 16:40:15'),
(333,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-25 05:38:42','2025-06-25 05:38:42'),
(334,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-25 10:52:39','2025-06-25 10:52:39'),
(335,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-25 15:55:50','2025-06-25 15:55:50'),
(336,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-25 15:58:10','2025-06-25 15:58:10'),
(337,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-25 16:02:19','2025-06-25 16:02:19'),
(338,'default','added',113,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-06-25 16:07:51','2025-06-25 16:07:51'),
(339,'default','added',114,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":108887.5}}',NULL,'2025-06-25 16:09:16','2025-06-25 16:09:16'),
(340,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-25 16:12:21','2025-06-25 16:12:21'),
(341,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-25 16:13:21','2025-06-25 16:13:21'),
(342,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-25 16:13:25','2025-06-25 16:13:25'),
(343,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-25 16:21:40','2025-06-25 16:21:41'),
(344,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-25 16:48:11','2025-06-25 16:48:11'),
(345,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-25 17:24:07','2025-06-25 17:24:07'),
(346,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 10:29:00','2025-06-26 10:29:00'),
(347,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 12:37:20','2025-06-26 12:37:20'),
(348,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-26 13:15:05','2025-06-26 13:15:05'),
(349,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-27 06:52:12','2025-06-27 06:52:12'),
(350,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-27 13:25:42','2025-06-27 13:25:42'),
(351,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-06-28 07:53:22','2025-06-28 07:53:22');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `aiassistance_history`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `aiassistance_history` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `tool_type` varchar(191) NOT NULL,
  `input_data` text DEFAULT NULL,
  `tokens_used` int(11) NOT NULL DEFAULT 0,
  `output_data` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `aiassistance_history` WRITE;
/*!40000 ALTER TABLE `aiassistance_history` DISABLE KEYS */;
/*!40000 ALTER TABLE `aiassistance_history` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_maintenances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_maintenances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `asset_id` int(11) NOT NULL,
  `maitenance_id` varchar(191) DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `priority` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `assigned_to` int(11) DEFAULT NULL,
  `details` text DEFAULT NULL,
  `maintenance_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_maintenances_business_id_index` (`business_id`),
  KEY `asset_maintenances_asset_id_index` (`asset_id`),
  KEY `asset_maintenances_status_index` (`status`),
  KEY `asset_maintenances_priority_index` (`priority`),
  KEY `asset_maintenances_created_by_index` (`created_by`),
  KEY `asset_maintenances_assigned_to_index` (`assigned_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_maintenances` WRITE;
/*!40000 ALTER TABLE `asset_maintenances` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_maintenances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `asset_id` int(10) unsigned DEFAULT NULL,
  `transaction_type` varchar(191) NOT NULL,
  `ref_no` varchar(191) NOT NULL,
  `receiver` int(10) unsigned DEFAULT NULL COMMENT 'id from users table, who receives asset',
  `quantity` decimal(22,4) NOT NULL,
  `transaction_datetime` datetime NOT NULL,
  `allocated_upto` date DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL COMMENT 'id from asset_transactions table',
  `created_by` int(10) unsigned NOT NULL COMMENT 'id from users table, who allocated asset',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `asset_transactions_business_id_foreign` (`business_id`),
  KEY `asset_transactions_asset_id_foreign` (`asset_id`),
  KEY `asset_transactions_receiver_foreign` (`receiver`),
  KEY `asset_transactions_parent_id_foreign` (`parent_id`),
  KEY `asset_transactions_created_by_foreign` (`created_by`),
  CONSTRAINT `asset_transactions_asset_id_foreign` FOREIGN KEY (`asset_id`) REFERENCES `assets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `asset_transactions_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `asset_transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `asset_transactions_receiver_foreign` FOREIGN KEY (`receiver`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_transactions` WRITE;
/*!40000 ALTER TABLE `asset_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `asset_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `asset_warranties` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `additional_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `asset_warranties` WRITE;
/*!40000 ALTER TABLE `asset_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `asset_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `asset_code` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `model` varchar(191) DEFAULT NULL,
  `serial_no` varchar(191) DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_type` varchar(191) DEFAULT NULL,
  `unit_price` decimal(22,4) NOT NULL,
  `depreciation` decimal(22,4) DEFAULT NULL,
  `is_allocatable` tinyint(1) NOT NULL DEFAULT 0,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `assets_business_id_foreign` (`business_id`),
  KEY `assets_category_id_foreign` (`category_id`),
  KEY `assets_created_by_foreign` (`created_by`),
  CONSTRAINT `assets_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `assets_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`),
  CONSTRAINT `assets_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES
(1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 00:43:44','2017-12-18 00:43:44'),
(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 00:34:39','2017-12-18 00:40:40'),
(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 00:25:40','2017-12-18 00:25:40'),
(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 00:28:40','2017-12-18 00:28:40'),
(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10'),
(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) NOT NULL,
  `booking_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `use_for_repair` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'brands to be used on repair module',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES
(1,1,'Samsung',NULL,1,0,NULL,'2025-02-07 18:11:36','2025-02-07 18:11:36'),
(2,1,'lux sabun','lux sabun',1,0,NULL,'2025-04-05 16:15:21','2025-04-05 16:15:21'),
(3,1,'RENAULT TRUCKS',NULL,1,1,NULL,'2025-05-08 16:28:05','2025-05-08 16:28:05'),
(4,1,'RENAULT',NULL,1,1,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(5,1,'SKF',NULL,1,1,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(6,1,'TRUCK TECHNIC',NULL,1,1,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(7,1,'KNORR BREMSE',NULL,1,1,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(8,1,'EURO POIDS LOURDS',NULL,1,1,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(9,1,'VALEO',NULL,1,1,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(10,1,'AYFAR',NULL,1,1,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(11,1,'EURORICAMBI',NULL,1,1,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) DEFAULT NULL,
  `tax_label_1` varchar(10) DEFAULT NULL,
  `tax_number_2` varchar(100) DEFAULT NULL,
  `tax_label_2` varchar(10) DEFAULT NULL,
  `code_label_1` varchar(191) DEFAULT NULL,
  `code_1` varchar(191) DEFAULT NULL,
  `code_label_2` varchar(191) DEFAULT NULL,
  `code_2` varchar(191) DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') NOT NULL DEFAULT 'includes',
  `logo` varchar(191) DEFAULT NULL,
  `sku_prefix` varchar(191) DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text DEFAULT NULL,
  `pos_settings` text DEFAULT NULL,
  `woocommerce_api_settings` text DEFAULT NULL,
  `woocommerce_skipped_orders` text DEFAULT NULL,
  `woocommerce_wh_oc_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_ou_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_od_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_or_secret` varchar(191) DEFAULT NULL,
  `manufacturing_settings` text DEFAULT NULL,
  `essentials_settings` longtext DEFAULT NULL,
  `weighing_scale_setting` text NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT 0,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') NOT NULL DEFAULT 'before',
  `enabled_modules` text DEFAULT NULL,
  `date_format` varchar(191) NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT 2,
  `quantity_precision` tinyint(4) NOT NULL DEFAULT 2,
  `ref_no_prefixes` text DEFAULT NULL,
  `theme_color` char(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `zatca_settings` longtext DEFAULT NULL,
  `gym_settings` longtext DEFAULT NULL,
  `repair_settings` text DEFAULT NULL,
  `repair_jobsheet_settings` text DEFAULT NULL,
  `prj_setting` longtext DEFAULT NULL,
  `hms_settings` longtext DEFAULT NULL,
  `crm_settings` text DEFAULT NULL,
  `asset_settings` text DEFAULT NULL,
  `accounting_settings` text DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text DEFAULT NULL,
  `sms_settings` text DEFAULT NULL,
  `custom_labels` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES
(1,'POS11',53,'2025-02-06',NULL,'19AHWPA259',NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,1,'Asia/Kolkata',4,'fifo',0.00,'includes','1744212619_app_launcher.png',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":null,\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"enable_sales_order\":\"1\",\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"disable_discount\":1,\"disable_order_tax\":1,\"enable_transaction_date\":\"1\",\"enable_weighing_scale\":\"1\",\"show_invoice_layout\":\"1\",\"print_on_suspend\":\"1\",\"show_pricing_on_product_sugesstion\":\"1\",\"customer_display_screen\":\"1\",\"display_screen_heading\":\"<p>11111<\\/p>\",\"cash_denominations\":null,\"enable_cash_denomination_on\":\"all_screens\",\"carousel_image_1\":\"1746307647_100.jpg\",\"carousel_image_2\":\"1746307647_100.jpg\",\"carousel_image_3\":\"1746307647_100.jpg\",\"carousel_image_4\":\"1746307647_100.jpg\",\"carousel_image_5\":\"1746307647_100.jpg\",\"carousel_image_6\":\"1746307647_100.jpg\",\"carousel_image_7\":\"1746307647_100.jpg\",\"carousel_image_8\":\"1746307647_100.jpg\",\"carousel_image_9\":\"1746307647_100.jpg\",\"carousel_image_10\":\"1746654003_313699 Z010 .jpg\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"is_pos_subtotal_editable\":0}','{\"woocommerce_app_url\":null,\"woocommerce_consumer_key\":\"admin\",\"woocommerce_consumer_secret\":\"Admin@123\",\"location_id\":\"1\",\"default_tax_class\":null,\"product_tax_type\":\"inc\",\"default_selling_price_group\":null,\"sync_description_as\":\"long\",\"product_fields_for_create\":[\"category\",\"quantity\"],\"manage_stock_for_create\":\"none\",\"in_stock_for_create\":\"none\",\"product_fields_for_update\":[\"name\",\"price\",\"category\",\"quantity\"],\"manage_stock_for_update\":\"none\",\"in_stock_for_update\":\"none\",\"order_statuses\":{\"pending\":null,\"processing\":null,\"on-hold\":null,\"completed\":null,\"cancelled\":null,\"refunded\":null,\"failed\":null,\"shipped\":null},\"shipping_statuses\":{\"pending\":null,\"processing\":null,\"on-hold\":null,\"completed\":null,\"cancelled\":null,\"refunded\":null,\"failed\":null,\"shipped\":null},\"woocommerce_wh_oc_secret\":null,\"woocommerce_wh_ou_secret\":null,\"woocommerce_wh_od_secret\":null,\"woocommerce_wh_or_secret\":null}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,1,NULL,1,1,1,1,1,'cmsn_agnt',1,1,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\",\"tables\",\"modifiers\",\"service_staff\",\"booking\",\"kitchen\",\"subscription\",\"types_of_service\"]','d-m-Y','24',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":\"EP\",\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}','primary',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"order_request_prefix\":\"demande de commande\",\"enable_order_request\":1}',NULL,'{\"journal_entry_prefix\":null,\"transfer_prefix\":null,\"accounting_default_map\":{\"1\":{\"sale\":{\"payment_account\":null,\"deposit_to\":null},\"sell_payment\":{\"payment_account\":null,\"deposit_to\":null},\"purchases\":{\"payment_account\":null,\"deposit_to\":null},\"purchase_payment\":{\"payment_account\":null,\"deposit_to\":null},\"expense\":{\"payment_account\":null,\"deposit_to\":null}}}}',1,'Trucks 2025',20.0000,3000.0000,NULL,1.0000,1.0000,NULL,NULL,24,'month','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":\"admin\",\"mail_password\":\"Admin@123\",\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":\"1\",\"custom_field_2\":\"2\",\"custom_field_3\":\"3\",\"custom_field_4\":\"4\",\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"enable_product_warranty\":\"1\",\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2025-02-06 19:30:03','2025-06-25 15:57:39'),
(2,'themobiletouch',53,'2025-02-08',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,3,'Asia/Kolkata',2,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(3,'Hshs',135,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,5,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(4,'test',53,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,6,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2025-06-20 07:44:09','2025-06-20 07:44:09');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) DEFAULT NULL,
  `name` varchar(256) NOT NULL,
  `landmark` text DEFAULT NULL,
  `country` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `city` varchar(100) NOT NULL,
  `zip_code` char(7) NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `sale_invoice_scheme_id` int(11) DEFAULT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT 1,
  `receipt_printer_type` enum('browser','printer') NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `featured_products` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `default_payment_accounts` text DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `zatca_details` longtext DEFAULT NULL,
  `zatca_response` longtext DEFAULT NULL,
  `accounting_default_map` text DEFAULT NULL COMMENT 'Default transactions mapping of accounting module',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES
(1,1,'BL0001','POS11','Landmark','INDIA','Test State','Test City','123456',1,NULL,1,1,NULL,1,'browser',NULL,'1234567891','','','https://pos11.testsoftwares.site',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,'{\"portal_mode\":\"developer-portal\",\"otp\":\"111222\",\"email\":\"email@gmail.com\",\"common_name\":\"TSTCO\",\"country_code\":\"SA\",\"organization_unit_name\":\"TSTCO-SA\",\"organization_name\":\"TSTCO-SA\",\"egs_serial_number\":\"1-SDSA|2-FGDS|3-SDFG\",\"vat_number\":\"300000000000003\",\"vat_name\":\"TSTCO VAT\",\"invoice_type\":\"1100\",\"registered_address\":\"RMRE1234\",\"business_category\":\"Transportations\",\"crn\":\"CRN123456\",\"street_name\":\"Main Street\",\"building_number\":\"123\",\"plot_identification\":\"Plot567\",\"sub_division_name\":\"Zone A\",\"city_name\":\"Riyadh\",\"postal_number\":\"11564\",\"country_name\":\"Saudi Arabia\"}','{\"success\":true,\"message\":\"ISSUED\",\"data\":{\"complianceCertificate\":\"TUlJQjZqQ0NBWStnQXdJQkFnSUdBWmVsbmlscU1Bb0dDQ3FHU000OUJBTUNNQlV4RXpBUkJnTlZCQU1NQ21WSmJuWnZhV05wYm1jd0hoY05NalV3TmpJMU1EVTBORFV3V2hjTk16QXdOakkwTWpFd01EQXdXakJETVE0d0RBWURWUVFEREFWVVUxUkRUekVSTUE4R0ExVUVDd3dJVkZOVVEwOHRVMEV4RVRBUEJnTlZCQW9NQ0ZSVFZFTlBMVk5CTVFzd0NRWURWUVFHRXdKVFFUQldNQkFHQnlxR1NNNDlBZ0VHQlN1QkJBQUtBMElBQklOU3pROG1TUTJ3UDF3TkVWV0Y5cXZWWVNJanNYaXM5clU3VlZMYldrM3dOQnpEbmtZZUp2a3FpZW8ydVA3RVBsa0FxT21tZlRxUnFmUXNQM2U0a21XamdaOHdnWnd3REFZRFZSMFRBUUgvQkFJd0FEQ0Jpd1lEVlIwUkJJR0RNSUdBcEg0d2ZERWRNQnNHQTFVRUJBd1VNUzFUUkZOQmZESXRSa2RFVTN3ekxWTkVSa2N4SHpBZEJnb0praWFKay9Jc1pBRUJEQTh6TURBd01EQXdNREF3TURBd01ETXhEVEFMQmdOVkJBd01CREV4TURBeEVUQVBCZ05WQkJvTUNGSk5Va1V4TWpNME1SZ3dGZ1lEVlFRUERBOVVjbUZ1YzNCdmNuUmhkR2x2Ym5Nd0NnWUlLb1pJemowRUF3SURTUUF3UmdJaEFJMFl2QkRzMEp4WkJhYVh6eTVjSHg2czkreXBuZ2Y2QnJnM1VTODJoOFN2QWlFQSsxR2Z6aUZ2eTc0OUdpSnp3a0tHL1EySEEzQmJnRXZiUTg1VmRQbjFSMFU9\",\"complianceSecret\":\"XLtiCLSqyNGBEVt\\/+Xy40WvU5iJxzDkdPvrbk0z2tzA=\",\"complianceRequestID\":\"1234567890123\",\"productionCertificate\":\"TUlJRDNqQ0NBNFNnQXdJQkFnSVRFUUFBT0FQRjkwQWpzL3hjWHdBQkFBQTRBekFLQmdncWhrak9QUVFEQWpCaU1SVXdFd1lLQ1pJbWlaUHlMR1FCR1JZRmJHOWpZV3d4RXpBUkJnb0praWFKay9Jc1pBRVpGZ05uYjNZeEZ6QVZCZ29Ka2lhSmsvSXNaQUVaRmdkbGVIUm5ZWHAwTVJzd0dRWURWUVFERXhKUVVscEZTVTVXVDBsRFJWTkRRVFF0UTBFd0hoY05NalF3TVRFeE1Ea3hPVE13V2hjTk1qa3dNVEE1TURreE9UTXdXakIxTVFzd0NRWURWUVFHRXdKVFFURW1NQ1FHQTFVRUNoTWRUV0Y0YVcxMWJTQlRjR1ZsWkNCVVpXTm9JRk4xY0hCc2VTQk1WRVF4RmpBVUJnTlZCQXNURFZKcGVXRmthQ0JDY21GdVkyZ3hKakFrQmdOVkJBTVRIVlJUVkMwNE9EWTBNekV4TkRVdE16azVPVGs1T1RrNU9UQXdNREF6TUZZd0VBWUhLb1pJemowQ0FRWUZLNEVFQUFvRFFnQUVvV0NLYTBTYTlGSUVyVE92MHVBa0MxVklLWHhVOW5QcHgydmxmNHloTWVqeThjMDJYSmJsRHE3dFB5ZG84bXEwYWhPTW1Obzhnd25pN1h0MUtUOVVlS09DQWdjd2dnSURNSUd0QmdOVkhSRUVnYVV3Z2FLa2daOHdnWnd4T3pBNUJnTlZCQVFNTWpFdFZGTlVmREl0VkZOVWZETXRaV1F5TW1ZeFpEZ3RaVFpoTWkweE1URTRMVGxpTlRndFpEbGhPR1l4TVdVME5EVm1NUjh3SFFZS0NaSW1pWlB5TEdRQkFRd1BNems1T1RrNU9UazVPVEF3TURBek1RMHdDd1lEVlFRTURBUXhNVEF3TVJFd0R3WURWUVFhREFoU1VsSkVNamt5T1RFYU1CZ0dBMVVFRHd3UlUzVndjR3g1SUdGamRHbDJhWFJwWlhNd0hRWURWUjBPQkJZRUZFWCtZdm1tdG5Zb0RmOUJHYktvN29jVEtZSzFNQjhHQTFVZEl3UVlNQmFBRkp2S3FxTHRtcXdza0lGelZ2cFAyUHhUKzlObk1Ic0dDQ3NHQVFVRkJ3RUJCRzh3YlRCckJnZ3JCZ0VGQlFjd0FvWmZhSFIwY0RvdkwyRnBZVFF1ZW1GMFkyRXVaMjkyTG5OaEwwTmxjblJGYm5KdmJHd3ZVRkphUlVsdWRtOXBZMlZUUTBFMExtVjRkR2RoZW5RdVoyOTJMbXh2WTJGc1gxQlNXa1ZKVGxaUFNVTkZVME5CTkMxRFFTZ3hLUzVqY25Rd0RnWURWUjBQQVFIL0JBUURBZ2VBTUR3R0NTc0dBUVFCZ2pjVkJ3UXZNQzBHSlNzR0FRUUJnamNWQ0lHR3FCMkUwUHNTaHUyZEpJZk8reG5Ud0ZWbWgvcWxaWVhaaEQ0Q0FXUUNBUkl3SFFZRFZSMGxCQll3RkFZSUt3WUJCUVVIQXdNR0NDc0dBUVVGQndNQ01DY0dDU3NHQVFRQmdqY1ZDZ1FhTUJnd0NnWUlLd1lCQlFVSEF3TXdDZ1lJS3dZQkJRVUhBd0l3Q2dZSUtvWkl6ajBFQXdJRFNBQXdSUUloQUxFL2ljaG1uV1hDVUtVYmNhM3ljaThvcXdhTHZGZEhWalFydmVJOXVxQWJBaUE5aEM0TThqZ01CQURQU3ptZDJ1aVBKQTZnS1IzTEUwM1U3NWVxYkMvclhBPT0=\",\"productionCertificateSecret\":\"CkYsEXfV8c1gFHAtFWoZv73pGMvh\\/Qyo4LzKM2h\\/8Hg=\",\"productionCertificateRequestID\":\"30368\",\"privateKey\":\"LS0tLS1CRUdJTiBQUklWQVRFIEtFWS0tLS0tCk1JR0VBZ0VBTUJBR0J5cUdTTTQ5QWdFR0JTdUJCQUFLQkcwd2F3SUJBUVFnbXI0cGdaZjhSbDVxYS9FZE5NSEgKdnpVRnlERGIrOUFGTDIvVDVJRHZDcnFoUkFOQ0FBU0RVczBQSmtrTnNEOWNEUkZWaGZhcjFXRWlJN0Y0clBhMQpPMVZTMjFwTjhEUWN3NTVHSGliNUtvbnFOcmoreEQ1WkFLanBwbjA2a2FuMExEOTN1SkpsCi0tLS0tRU5EIFBSSVZBVEUgS0VZLS0tLS0K\",\"publicKey\":\"LS0tLS1CRUdJTiBQVUJMSUMgS0VZLS0tLS0KTUZZd0VBWUhLb1pJemowQ0FRWUZLNEVFQUFvRFFnQUVnMUxORHlaSkRiQS9YQTBSVllYMnE5VmhJaU94ZUt6Mgp0VHRWVXR0YVRmQTBITU9lUmg0bStTcUo2amE0L3NRK1dRQ282YVo5T3BHcDlDdy9kN2lTWlE9PQotLS0tLUVORCBQVUJMSUMgS0VZLS0tLS0K\",\"csrKey\":\"LS0tLS1CRUdJTiBDRVJUSUZJQ0FURSBSRVFVRVNULS0tLS0KTUlJQnhqQ0NBV3NDQVFBd1F6RU9NQXdHQTFVRUF3d0ZWRk5VUTA4eEVUQVBCZ05WQkFzTUNGUlRWRU5QTFZOQgpNUkV3RHdZRFZRUUtEQWhVVTFSRFR5MVRRVEVMTUFrR0ExVUVCaE1DVTBFd1ZqQVFCZ2NxaGtqT1BRSUJCZ1VyCmdRUUFDZ05DQUFTRFVzMFBKa2tOc0Q5Y0RSRlZoZmFyMVdFaUk3RjRyUGExTzFWUzIxcE44RFFjdzU1R0hpYjUKS29ucU5yait4RDVaQUtqcHBuMDZrYW4wTEQ5M3VKSmxvSUhJTUlIRkJna3Foa2lHOXcwQkNRNHhnYmN3Z2JRdwpKQVlKS3dZQkJBR0NOeFFDQkJjVEZWUlRWRnBCVkVOQkxVTnZaR1V0VTJsbmJtbHVaekNCaXdZRFZSMFJCSUdECk1JR0FwSDR3ZkRFZE1Cc0dBMVVFQkF3VU1TMVRSRk5CZkRJdFJrZEVVM3d6TFZORVJrY3hIekFkQmdvSmtpYUoKay9Jc1pBRUJEQTh6TURBd01EQXdNREF3TURBd01ETXhEVEFMQmdOVkJBd01CREV4TURBeEVUQVBCZ05WQkJvTQpDRkpOVWtVeE1qTTBNUmd3RmdZRFZRUVBEQTlVY21GdWMzQnZjblJoZEdsdmJuTXdDZ1lJS29aSXpqMEVBd0lEClNRQXdSZ0loQUlMU1I3WEExeDF4bkp2MURiTEZHbytUOW14RERNb2dWM0ZocGFGQlZXenNBaUVBczZacDZFWHIKNEN2OEJsTC9SWGZmS1VlQmxLdCtKK2tpVzRpVnd1NjFtQ2c9Ci0tLS0tRU5EIENFUlRJRklDQVRFIFJFUVVFU1QtLS0tLQo=\",\"configData\":\"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\"}}','{\"sale\":{\"payment_account\":null,\"deposit_to\":null},\"sell_payment\":{\"payment_account\":null,\"deposit_to\":null},\"purchases\":{\"payment_account\":null,\"deposit_to\":null},\"purchase_payment\":{\"payment_account\":null,\"deposit_to\":null},\"expense\":{\"payment_account\":null,\"deposit_to\":null}}',NULL,'2025-02-06 19:30:03','2025-06-25 05:44:58'),
(2,2,'BL0001','themobiletouch','KAIJ','India','Maharashtra','Kaij','431123',2,NULL,2,2,NULL,1,'browser',NULL,'7020106607','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(3,3,'BL0001','Hshs','Bcbc','United States','Hshdd','Ududu','69696',3,NULL,3,3,NULL,1,'browser',NULL,'6969696999','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(4,4,'BL0001','test','admin@demo.com','india','india','india','67890',4,NULL,4,4,NULL,1,'browser',NULL,'','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-20 07:44:09','2025-06-20 07:44:09');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_denominations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int(11) NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pay_method` varchar(191) DEFAULT NULL,
  `type` enum('debit','credit') NOT NULL,
  `transaction_type` varchar(191) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=98 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES
(1,1,100.0000,'cash','credit','initial',NULL,'2025-02-06 19:48:52','2025-02-06 19:48:52'),
(95,1,6500.0000,'cash','credit','sell',112,'2025-05-11 19:23:47','2025-05-11 19:23:47'),
(96,1,6500.0000,'cash','credit','sell',113,'2025-06-25 16:07:51','2025-06-25 16:07:51'),
(97,1,108887.5000,'cash','credit','sell',114,'2025-06-25 16:09:16','2025-06-25 16:09:16');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_card_slips` int(11) NOT NULL DEFAULT 0,
  `total_cheques` int(11) NOT NULL DEFAULT 0,
  `denominations` text DEFAULT NULL,
  `closing_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES
(1,1,1,1,'open',NULL,0.0000,0,0,NULL,NULL,'2025-02-06 19:48:00','2025-02-06 19:48:52');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_cat_id` int(11) DEFAULT NULL,
  `category_type` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `slug` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_woocommerce_cat_id_index` (`woocommerce_cat_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES
(1,'Mobile',1,'1',0,1,NULL,'product',NULL,NULL,NULL,'2025-02-07 18:11:05','2025-02-07 18:11:05'),
(2,'trucks',1,NULL,0,1,NULL,'followup_category',NULL,NULL,NULL,'2025-04-06 22:05:37','2025-04-06 22:05:37'),
(3,'renaulr',1,NULL,0,1,NULL,'followup_category',NULL,NULL,NULL,'2025-04-06 22:05:48','2025-04-06 22:05:48'),
(4,'volvo',1,NULL,0,1,NULL,'followup_category',NULL,NULL,NULL,'2025-04-06 22:05:55','2025-04-06 22:05:55'),
(5,'renault vie',1,NULL,0,1,NULL,'life_stage',NULL,NULL,NULL,'2025-04-06 22:06:21','2025-04-06 22:06:21'),
(6,'volvo vie',1,NULL,0,1,NULL,'life_stage',NULL,NULL,NULL,'2025-04-06 22:06:32','2025-04-06 22:06:32'),
(7,'trucks vie',1,NULL,0,1,NULL,'life_stage',NULL,NULL,NULL,'2025-04-06 22:06:50','2025-04-06 22:06:50'),
(8,'trucks source',1,NULL,0,1,NULL,'source',NULL,NULL,NULL,'2025-04-06 22:07:12','2025-04-06 22:07:12'),
(9,'volvo source',1,NULL,0,1,NULL,'source',NULL,NULL,NULL,'2025-04-06 22:07:35','2025-04-06 22:07:35'),
(10,'renault source',1,NULL,0,1,NULL,'source',NULL,NULL,NULL,'2025-04-06 22:07:50','2025-04-06 22:07:50'),
(11,'AUTRE MARQUES',1,NULL,0,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(12,'RENAULT AVANT 2000',1,NULL,11,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(13,'BOITE VITESSE',1,NULL,0,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(14,'Boite Vitesse B18 - B9',1,NULL,13,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(15,'CONSOMMABLE',1,NULL,0,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(16,'Roulement, Les Joints',1,NULL,15,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(17,'SNVI',1,NULL,11,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(18,'RENAULT',1,NULL,0,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(19,'D\'AIR , Échappement',1,NULL,18,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(20,'MAN',1,NULL,0,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(21,'Eclairage',1,NULL,20,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46'),
(22,'Boite Vitesse ZF',1,NULL,13,1,NULL,'product',NULL,NULL,NULL,'2025-05-10 18:55:46','2025-05-10 18:55:46');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cms_page_metas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_page_metas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cms_page_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(191) NOT NULL,
  `meta_value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cms_page_metas_cms_page_id_foreign` (`cms_page_id`),
  CONSTRAINT `cms_page_metas_cms_page_id_foreign` FOREIGN KEY (`cms_page_id`) REFERENCES `cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cms_page_metas` WRITE;
/*!40000 ALTER TABLE `cms_page_metas` DISABLE KEYS */;
INSERT INTO `cms_page_metas` VALUES
(1,3,'industry','{\"id\":\"1\",\"title\":\"We\'re Ready For Your Business!\",\"description\":\"<p>If you\'re in need of business management software, you\'ve come to the right place.&nbsp;<\\/p>\\r\\n<p>We have a clean, modern modular design that is sure to fit your business!<\\/p>\",\"content\":[{\"icon\":\"fas fa-store-alt\",\"title\":\"Departmental Store\",\"description\":\"Looking for a software solution that can help you manage and sell all of your essential items in one place? Look no further than our one-stop departmental store software. Whether you need to sell clothes, shoes, bags, or any other type of item, our software has you covered. Plus, our easy-to-use interface makes it simple to get started selling right away. So why wait? Get started today!\"},{\"icon\":\"fas fa-store\",\"title\":\"Retail & Wholesale\",\"description\":\"A complete suite of features to manage both retail & wholesales stores. Set multiple prices for different customer segments or different business locations.\"},{\"icon\":\"fas fa-notes-medical\",\"title\":\"Pharmacy\",\"description\":\"Our software is perfect for any pharmaceutical company. You can set product expiration dates and lot numbers, and sell in different units of measure. Stop selling expired & to-be-expired items to customers. Check details reports on stock expiry by lot numbers\"},{\"icon\":\"fas fa-prescription-bottle\",\"title\":\"Liquor\",\"description\":\"Easy to use for every liquor shop. Sell in ml of simple sell the bottle, you can easily manage them.\"},{\"icon\":\"fas fa-mobile-alt\",\"title\":\"Mobile & Electronics\",\"description\":\"Record inventory serial number, sell items with particular serial number,\"},{\"icon\":\"fas fa-wrench\",\"title\":\"Repair Shop\",\"description\":\"A complete suite of features to manage repair business, create job sheet, assign job sheet to technician, repair status, convert job sheet to invoices. Self link for customers to check repair progress\"},{\"icon\":\"fas fa-home\",\"title\":null,\"description\":null},{\"icon\":\"fas fa-home\",\"title\":null,\"description\":null}]}',NULL,'2022-10-20 11:00:15'),
(2,3,'feature','{\"id\":\"2\",\"title\":\"Features to skyrocket \\ud83d\\ude80 your business growth\",\"description\":\"<p>The pace of business growth has never been faster.<\\/p>\\r\\n<p>That\'s why we&rsquo;ve designed our cloud-based POS software to help you get ahead.<\\/p>\\r\\n<p>The easiest, most reliable way to grow and manage your business is right at your fingertips with our cloud-based POS and inventory management system.<\\/p>\\r\\n<p>Right software can be a lifesaver for your business, and with it, you can revolutionize your business\'s growth<\\/p>\",\"content\":[{\"icon\":\"fas fa-cloud\",\"title\":\"Access Anywhere!\",\"description\":\"Check your business data from anywhere, anytime. \\r\\nSee live updates in realtime\"},{\"icon\":\"fas fa-check-double\",\"title\":\"No Installation\",\"description\":\"No software to install, No hardware dependency. Just open browser & start using.\"},{\"icon\":\"fas fa-sitemap\",\"title\":\"MultiBranches & Warehouse\",\"description\":\"Manage stock of multiple branches  in one place effortlessly & real-time.\"},{\"icon\":\"fas fa-user-lock\",\"title\":\"User access limit\",\"description\":\"Powerful user Role & Permission management to limit employees  access to business data\"},{\"icon\":\"fas fa-cubes\",\"title\":\"Stock Management\",\"description\":\"Manage stocks with from multiple locations, stock expiry, lot number, stock history & much more.\"},{\"icon\":\"fas fa-wrench\",\"title\":\"Service Management\",\"description\":\"Manage & easily invoice for services. Also dedicated repair service management features to schedule & deliver services on time\"},{\"icon\":\"fas fa-users\",\"title\":\"HR Management\",\"description\":\"With HR management easily track daily attendance, shift management, leaves, payroll, Holidays, Departments,  & Designations\"},{\"icon\":\"fas fa-handshake\",\"title\":\"Customer Management\",\"description\":\"CRM module help you to track leads lifecycle, followup with leads, sources, followup, launch campaigns, proposals and lot more\"},{\"icon\":\"fas fa-hand-peace\",\"title\":\"Simplified Interface\",\"description\":\"Simple to use interface to get work done in few clicks. Save your time & make it easy for staffs to use.\"},{\"icon\":\"fas fa-chart-line\",\"title\":\"Reports\",\"description\":\"Comes inbuilt with lot of report to help business owners analyse every revenue, inventory, payments & human resource.\"}]}','2022-09-15 10:04:41','2022-10-20 10:09:11');
/*!40000 ALTER TABLE `cms_page_metas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cms_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) NOT NULL,
  `layout` varchar(191) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `content` longtext DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `tags` varchar(191) DEFAULT NULL,
  `feature_image` varchar(191) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cms_pages` WRITE;
/*!40000 ALTER TABLE `cms_pages` DISABLE KEYS */;
INSERT INTO `cms_pages` VALUES
(1,'testimonial',NULL,'David Parr','<p class=\"testimonial-card-1__paragraph mb-3\">This software has become one of the backbones of our business. It helped us streamline the data of all our warehouses &amp; shops on one platform. I am not much of a techy guy but the admin panel also allows you to customize every aspect of the application.</p>\r\n          <p class=\"testimonial-card-1__paragraph mb-3\">All the reports help me to give an overview of different aspects of our business.</p>\r\n          <p class=\"testimonial-card-1__paragraph mb-3\">It is very powerful!</p>',NULL,NULL,NULL,3,9,1,'2022-08-19 05:55:05','2022-10-20 12:18:29'),
(2,'testimonial',NULL,'Tim Johnson','<p>It is truly designed to help my business run more smoothly and efficiently. I can now track and manage inventory, customer information, and sales easily. The installation was quick and easy, and the interface is very user-friendly. I can now manage almost every business operation with one single software!</p>',NULL,NULL,NULL,NULL,1,1,'2022-09-10 10:37:17','2025-05-10 17:58:34'),
(3,'page','home','Automate your business management at very-Low cost','<p>Best POS, Invoicing, Inventory &amp; Service management application for your growing business!</p>',NULL,NULL,NULL,1,0,1,'2022-09-10 10:56:24','2022-10-20 11:00:15'),
(4,'page','contact','Contact Us','<p>We\'re happy to receive your message. Ask us anything, we\'ll respond as soon as possible.</p>',NULL,NULL,NULL,NULL,0,1,'2022-09-10 10:56:24','2022-09-16 06:34:20'),
(5,'testimonial',NULL,'Krishna Watt','<p>We have used this for 9 months now. It has helped our business grow by leaps and bounds. The interface and its simplicity have made it easy for us to learn and get familiar with. The best thing about this software is that it is cloud-based and we can use it from our shop, warehouse, or mobile while traveling. I can also see its potential as we continue to grow. Highly Satisfied!</p>',NULL,NULL,NULL,NULL,1,1,'2022-09-16 06:37:25','2022-10-20 11:57:31');
/*!40000 ALTER TABLE `cms_pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cms_site_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_site_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `site_key` varchar(191) NOT NULL,
  `site_value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cms_site_details` WRITE;
/*!40000 ALTER TABLE `cms_site_details` DISABLE KEYS */;
INSERT INTO `cms_site_details` VALUES
(1,'faqs','[{\"question\":\"Why should we switch to cloud-based business management software compared to traditional desktop software?\",\"answer\":\"Cloud-based software provides you a low-cost, secure & mobile software solutions. Compared to traditional software that requires it to install on a computer - cloud-based can be accessed from anywhere without any hardware dependency.\"},{\"question\":\"How secure is my business data?\",\"answer\":\"All data are stored in our centralized database which is highly protected with multi-layers of privileges. We takes regular frequency interval automated backup to protect from any unwanted consequences.\"},{\"question\":\"Whom should I reach out to in case of any problems?\",\"answer\":\"Please contact our support, write us in the contact section or call to the number mentioned. You\'re assured to receive a response in a maximum of 24 hours.\"},{\"question\":\"Is this POS application Free?\",\"answer\":\"We do provide a free tier for very small business or business that is about to start. To take more advantage of this POS software we recommend that you upgrade to a better plan that unlocks more features.\"},{\"question\":\"Do you provide consultancy or implementation solutions for using this POS software?\",\"answer\":\"Yes, with a pro plan you can connect with one of our experts who will help you with implementing the solution for your business.\"},{\"question\":\"Are there any additional hardware required or subscription charges?\",\"answer\":\"This is cloud-based software. You\'ll only need a device with an internet connection & chrome browser. It runs within the browser. No additional hardware is required. But you can use some hardware like barcode scanners, and printers for your convenience to speed up work.\"}]','2022-09-13 13:14:10','2022-10-20 11:46:28'),
(2,'statistics','{\"tagline\":\"POS\'s Stats & Numbers\",\"description\":\"More & More businesses are adopting our cloud-based business management solution\",\"content\":[{\"stats\":\"75\",\"title\":\"REGISTERED BUSINESSES\"},{\"stats\":\"400+\",\"title\":\"DAILY USERS\"},{\"stats\":\"50K\",\"title\":\"INVOICES CREATED\"},{\"stats\":\"126+\",\"title\":\"ONLINE RESOURCES\"}]}','2022-09-13 13:14:10','2022-10-20 11:38:07'),
(3,'google_analytics','null','2022-09-14 05:44:40','2022-09-16 06:19:09'),
(4,'fb_pixel','null','2022-09-14 05:44:40','2022-09-16 06:19:09'),
(5,'custom_js','null','2022-09-14 05:44:40','2022-09-16 06:19:09'),
(6,'custom_css','null','2022-09-14 05:44:40','2022-09-16 06:19:09'),
(7,'meta_tags','null','2022-09-14 05:44:40','2022-09-16 06:19:09'),
(8,'chat_widget','null','2022-09-14 05:57:14','2022-09-16 06:19:09'),
(9,'contact_us','[{\"label\":\"Call\",\"num\":\"0000000000\"},{\"label\":\"Support\",\"num\":\"0000000000\"},{\"label\":\"Enquiry\",\"num\":\"0000000000\"}]','2022-09-14 06:54:38','2022-09-16 06:19:09'),
(10,'mail_us','[{\"label\":\"Contact\",\"email\":\"contact@example.com\"},{\"label\":\"Support\",\"email\":\"support@example.com\"}]','2022-09-14 06:54:38','2022-09-16 06:19:09'),
(11,'follow_us','{\"facebook\":\"https:\\/\\/www.facebook.com\\/test\",\"instagram\":\"https:\\/\\/www.instagram.com\\/test\",\"twitter\":\"https:\\/\\/twitter.com\\/test\",\"linkedin\":\"https:\\/\\/in.linkedin.com\\/company\\/test\",\"youtube\":\"https:\\/\\/www.youtube.com\\/c\\/test\"}','2022-09-14 07:05:39','2022-10-20 11:38:07'),
(12,'logo','\"logo.png\"','2022-09-14 08:08:53','2025-02-06 19:49:44'),
(13,'notifiable_email','\"notifyme@example.com\"','2022-09-14 08:08:53','2022-09-16 06:19:09'),
(14,'btns','{\"navbar\":{\"text\":\"Try For Free\",\"link\":\"https:\\/\\/pos11.testsoftwares.site\\/business\\/register\"},\"hero\":{\"text\":\"Start your Free Trial\",\"link\":\"https:\\/\\/pos11.testsoftwares.site\\/business\\/register\"},\"industry\":{\"text\":\"Get Started\",\"link\":\"https:\\/\\/pos11.testsoftwares.site\\/business\\/register\"},\"cta\":{\"text\":\"Try Now\",\"link\":\"https:\\/\\/pos11.testsoftwares.site\\/business\\/register\"}}','2025-02-06 19:49:44','2025-02-06 19:49:44'),
(15,'chat','{\"enable\":\"in_app_chat\",\"mobile\":{\"1\":null,\"2\":null},\"mail\":{\"1\":null,\"2\":null},\"whatsapp\":{\"1\":null,\"2\":null},\"messanger_link\":null,\"telegram\":null}','2025-02-06 19:49:44','2025-02-06 19:49:44');
/*!40000 ALTER TABLE `cms_site_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) NOT NULL,
  `contact_type` varchar(191) DEFAULT NULL,
  `land_mark` varchar(191) DEFAULT NULL,
  `street_name` varchar(191) DEFAULT NULL,
  `building_number` varchar(191) DEFAULT NULL,
  `additional_number` varchar(191) DEFAULT NULL,
  `supplier_business_name` varchar(191) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `prefix` varchar(191) DEFAULT NULL,
  `first_name` varchar(191) DEFAULT NULL,
  `middle_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `gym_member_profile_photo` varchar(191) DEFAULT NULL,
  `gym_member_gender` varchar(191) DEFAULT NULL,
  `contact_id` varchar(191) DEFAULT NULL,
  `contact_status` varchar(191) NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `address_line_1` text DEFAULT NULL,
  `address_line_2` text DEFAULT NULL,
  `zip_code` varchar(191) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) NOT NULL,
  `landline` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `converted_by` int(11) DEFAULT NULL,
  `converted_on` datetime DEFAULT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_rp` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `shipping_address` text DEFAULT NULL,
  `shipping_custom_field_details` longtext DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_field_1` varchar(191) DEFAULT NULL,
  `export_custom_field_2` varchar(191) DEFAULT NULL,
  `export_custom_field_3` varchar(191) DEFAULT NULL,
  `export_custom_field_4` varchar(191) DEFAULT NULL,
  `export_custom_field_5` varchar(191) DEFAULT NULL,
  `export_custom_field_6` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `crm_source` varchar(191) DEFAULT NULL,
  `crm_life_stage` varchar(191) DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `custom_field5` varchar(191) DEFAULT NULL,
  `custom_field6` varchar(191) DEFAULT NULL,
  `custom_field7` varchar(191) DEFAULT NULL,
  `custom_field8` varchar(191) DEFAULT NULL,
  `custom_field9` varchar(191) DEFAULT NULL,
  `custom_field10` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  KEY `contacts_crm_source_index` (`crm_source`),
  KEY `contacts_crm_life_stage_index` (`crm_life_stage`),
  KEY `contacts_converted_by_index` (`converted_by`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES
(1,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(2,1,'supplier','individual',NULL,NULL,NULL,NULL,NULL,'Ganesh  G B D','Ganesh ','G','B','D',NULL,NULL,NULL,'01','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'9860142377',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-07 18:06:34','2025-02-07 18:06:34'),
(3,2,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,3,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(4,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'m Hadji Samy','m','Hadji',NULL,'Samy','epl.samy19@gmail.com',NULL,NULL,'CO0003','active',NULL,'Setif','DZ-19','DZ',NULL,NULL,NULL,NULL,'0555333363',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,2,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 02:41:50','2025-04-19 22:44:50','2025-04-20 02:41:50'),
(5,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'M Hadji Adam','M','Hadji',NULL,'Adam','epl.samy19@gmail.com',NULL,NULL,'CO0004','active',NULL,'Setif','DZ-19','DZ',NULL,NULL,NULL,NULL,'0555999920',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,-600,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 00:54:21','2025-04-20 00:31:22','2025-04-20 00:54:21'),
(6,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'M Hadji Adam','M','Hadji',NULL,'Adam','epl.samy19@gmail.com',NULL,NULL,'CO0005','active',NULL,'Setif','DZ-19','DZ',NULL,NULL,NULL,NULL,'0555999920',NULL,'2203',NULL,NULL,NULL,1,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 00:31:23','2025-05-10 18:02:31'),
(7,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'M didi Hadji','M','didi',NULL,'Hadji','epl.sassmy19@gmail.com',NULL,NULL,'CO0006','active',NULL,'Setif','DZ-19','DZ',NULL,NULL,NULL,NULL,'0555999929',NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0.0000,-5000,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 02:41:39','2025-04-20 02:09:02','2025-04-20 02:41:39'),
(8,3,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,5,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(9,4,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,6,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-20 07:44:09','2025-06-20 07:44:09');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_call_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_call_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `call_type` varchar(191) DEFAULT NULL,
  `mobile_number` varchar(191) NOT NULL,
  `mobile_name` varchar(191) DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_call_logs_business_id_index` (`business_id`),
  KEY `crm_call_logs_user_id_index` (`user_id`),
  KEY `crm_call_logs_contact_id_index` (`contact_id`),
  KEY `crm_call_logs_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_call_logs` WRITE;
/*!40000 ALTER TABLE `crm_call_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_call_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_campaigns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_campaigns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `campaign_type` enum('sms','email') NOT NULL DEFAULT 'email',
  `subject` varchar(191) DEFAULT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `sent_on` datetime DEFAULT NULL,
  `contact_ids` text NOT NULL,
  `additional_info` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_campaigns_business_id_foreign` (`business_id`),
  KEY `crm_campaigns_created_by_index` (`created_by`),
  CONSTRAINT `crm_campaigns_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_campaigns` WRITE;
/*!40000 ALTER TABLE `crm_campaigns` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_campaigns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_contact_person_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_contact_person_commissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_person_id` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `commission_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_contact_person_commissions` WRITE;
/*!40000 ALTER TABLE `crm_contact_person_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_contact_person_commissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_followup_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_followup_invoices` (
  `follow_up_id` int(11) NOT NULL,
  `transaction_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_followup_invoices` WRITE;
/*!40000 ALTER TABLE `crm_followup_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_followup_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_lead_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_lead_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_lead_users_user_id_index` (`user_id`),
  KEY `crm_lead_users_contact_id_index` (`contact_id`),
  CONSTRAINT `crm_lead_users_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_lead_users` WRITE;
/*!40000 ALTER TABLE `crm_lead_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_lead_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_marketplaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_marketplaces` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `marketplace` varchar(191) DEFAULT NULL,
  `site_key` varchar(191) DEFAULT NULL,
  `site_id` varchar(191) DEFAULT NULL,
  `assigned_users` text DEFAULT NULL,
  `crm_source_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_marketplaces` WRITE;
/*!40000 ALTER TABLE `crm_marketplaces` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_marketplaces` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_proposal_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_proposal_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `subject` text NOT NULL,
  `body` longtext NOT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_proposal_templates_business_id_foreign` (`business_id`),
  KEY `crm_proposal_templates_created_by_index` (`created_by`),
  CONSTRAINT `crm_proposal_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_proposal_templates` WRITE;
/*!40000 ALTER TABLE `crm_proposal_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_proposal_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_proposals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_proposals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `subject` text NOT NULL,
  `body` longtext NOT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `sent_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_proposals_business_id_foreign` (`business_id`),
  KEY `crm_proposals_contact_id_foreign` (`contact_id`),
  KEY `crm_proposals_sent_by_index` (`sent_by`),
  CONSTRAINT `crm_proposals_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `crm_proposals_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_proposals` WRITE;
/*!40000 ALTER TABLE `crm_proposals` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_proposals` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedule_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_schedule_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` bigint(20) unsigned NOT NULL,
  `log_type` enum('call','sms','meeting','email') NOT NULL DEFAULT 'email',
  `start_datetime` datetime NOT NULL,
  `end_datetime` datetime NOT NULL,
  `subject` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedule_logs_schedule_id_foreign` (`schedule_id`),
  KEY `crm_schedule_logs_created_by_index` (`created_by`),
  CONSTRAINT `crm_schedule_logs_schedule_id_foreign` FOREIGN KEY (`schedule_id`) REFERENCES `crm_schedules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedule_logs` WRITE;
/*!40000 ALTER TABLE `crm_schedule_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedule_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedule_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_schedule_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` bigint(20) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedule_users_schedule_id_foreign` (`schedule_id`),
  KEY `crm_schedule_users_user_id_index` (`user_id`),
  CONSTRAINT `crm_schedule_users_schedule_id_foreign` FOREIGN KEY (`schedule_id`) REFERENCES `crm_schedules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedule_users` WRITE;
/*!40000 ALTER TABLE `crm_schedule_users` DISABLE KEYS */;
INSERT INTO `crm_schedule_users` VALUES
(1,1,1,NULL,NULL);
/*!40000 ALTER TABLE `crm_schedule_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_schedules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `status` varchar(191) DEFAULT NULL,
  `start_datetime` datetime DEFAULT NULL,
  `end_datetime` datetime DEFAULT NULL,
  `description` text DEFAULT NULL,
  `schedule_type` enum('call','sms','meeting','email') NOT NULL DEFAULT 'email',
  `followup_category_id` int(11) DEFAULT NULL,
  `allow_notification` tinyint(1) NOT NULL DEFAULT 1,
  `notify_via` text DEFAULT NULL,
  `notify_before` int(11) DEFAULT NULL,
  `notify_type` enum('minute','hour','day') NOT NULL DEFAULT 'hour',
  `created_by` int(11) NOT NULL,
  `is_recursive` tinyint(1) NOT NULL DEFAULT 0,
  `recursion_days` int(11) DEFAULT NULL,
  `followup_additional_info` text DEFAULT NULL,
  `follow_up_by` varchar(191) DEFAULT NULL,
  `follow_up_by_value` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedules_created_by_index` (`created_by`),
  KEY `crm_schedules_business_id_index` (`business_id`),
  KEY `crm_schedules_contact_id_index` (`contact_id`),
  KEY `crm_schedules_schedule_type_index` (`schedule_type`),
  KEY `crm_schedules_notify_type_index` (`notify_type`),
  CONSTRAINT `crm_schedules_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedules` WRITE;
/*!40000 ALTER TABLE `crm_schedules` DISABLE KEYS */;
INSERT INTO `crm_schedules` VALUES
(1,1,1,'Followup: , Walk-In Customer',NULL,'2025-04-07 03:40:00','2025-04-09 03:40:00',NULL,'email',4,1,'{\"sms\":0,\"mail\":1}',1,'hour',1,0,NULL,NULL,'contact_name',NULL,'2025-04-06 22:10:35','2025-04-06 22:10:35');
/*!40000 ALTER TABLE `crm_schedules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `code` varchar(25) NOT NULL,
  `symbol` varchar(25) NOT NULL,
  `thousand_separator` varchar(10) NOT NULL,
  `decimal_separator` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES
(1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),
(2,'America','Dollars','USD','$',',','.',NULL,NULL),
(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),
(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),
(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),
(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),
(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),
(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),
(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),
(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),
(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),
(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),
(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),
(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),
(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),
(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),
(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),
(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),
(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),
(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),
(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),
(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),
(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),
(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),
(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),
(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),
(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),
(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),
(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),
(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),
(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),
(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),
(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),
(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),
(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),
(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),
(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),
(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),
(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),
(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),
(41,'France','Euro','EUR','€','.',',',NULL,NULL),
(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),
(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),
(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),
(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),
(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),
(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),
(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),
(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),
(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),
(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),
(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),
(53,'India','Rupees','INR','₹',',','.',NULL,NULL),
(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),
(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),
(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),
(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),
(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),
(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),
(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),
(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),
(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),
(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),
(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),
(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),
(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),
(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),
(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),
(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),
(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),
(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),
(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),
(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),
(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),
(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),
(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),
(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),
(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),
(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),
(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),
(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),
(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),
(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),
(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),
(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),
(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),
(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),
(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),
(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),
(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),
(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),
(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),
(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),
(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),
(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),
(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),
(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),
(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),
(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),
(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),
(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),
(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),
(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),
(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),
(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),
(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),
(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),
(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),
(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),
(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),
(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),
(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),
(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),
(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),
(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),
(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),
(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),
(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),
(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),
(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),
(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),
(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),
(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),
(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),
(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),
(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),
(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),
(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),
(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),
(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),
(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),
(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),
(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),
(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),
(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),
(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),
(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),
(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),
(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),
(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),
(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `color` varchar(191) NOT NULL,
  `configuration` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `spg` varchar(100) DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) NOT NULL,
  `heading` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_allowances_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_allowances_and_deductions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `description` varchar(191) NOT NULL,
  `type` enum('allowance','deduction') NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `amount_type` enum('fixed','percent') NOT NULL,
  `applicable_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_allowances_and_deductions_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_allowances_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `clock_in_time` datetime DEFAULT NULL,
  `clock_out_time` datetime DEFAULT NULL,
  `essentials_shift_id` int(11) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `clock_in_note` text DEFAULT NULL,
  `clock_out_note` text DEFAULT NULL,
  `clock_in_location` text DEFAULT NULL,
  `clock_out_location` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_attendances_user_id_index` (`user_id`),
  KEY `essentials_attendances_business_id_index` (`business_id`),
  KEY `essentials_attendances_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_attendances` WRITE;
/*!40000 ALTER TABLE `essentials_attendances` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_attendances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_document_shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_document_shares` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(11) NOT NULL,
  `value_type` enum('user','role') NOT NULL,
  `value` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_document_shares_document_id_index` (`document_id`),
  KEY `essentials_document_shares_value_type_index` (`value_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_document_shares` WRITE;
/*!40000 ALTER TABLE `essentials_document_shares` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_document_shares` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `type` varchar(191) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `description` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_documents` WRITE;
/*!40000 ALTER TABLE `essentials_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_documents` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_holidays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_holidays_business_id_index` (`business_id`),
  KEY `essentials_holidays_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_holidays` WRITE;
/*!40000 ALTER TABLE `essentials_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_holidays` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_kb` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` bigint(20) unsigned NOT NULL,
  `title` varchar(191) NOT NULL,
  `content` longtext DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `kb_type` varchar(191) NOT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL COMMENT 'id from essentials_kb table',
  `share_with` varchar(191) DEFAULT NULL COMMENT 'public, private, only_with',
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_business_id_index` (`business_id`),
  KEY `essentials_kb_parent_id_index` (`parent_id`),
  KEY `essentials_kb_created_by_index` (`created_by`),
  CONSTRAINT `essentials_kb_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `essentials_kb` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb` WRITE;
/*!40000 ALTER TABLE `essentials_kb` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_kb_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `kb_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_users_kb_id_index` (`kb_id`),
  KEY `essentials_kb_users_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb_users` WRITE;
/*!40000 ALTER TABLE `essentials_kb_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leave_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_leave_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leave_type` varchar(191) NOT NULL,
  `max_leave_count` int(11) DEFAULT NULL,
  `leave_count_interval` enum('month','year') DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leave_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leave_types` WRITE;
/*!40000 ALTER TABLE `essentials_leave_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leave_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leaves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_leaves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `essentials_leave_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `ref_no` varchar(191) DEFAULT NULL,
  `status` enum('pending','approved','cancelled') DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `status_note` text DEFAULT NULL,
  `is_additional` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leaves_essentials_leave_type_id_index` (`essentials_leave_type_id`),
  KEY `essentials_leaves_business_id_index` (`business_id`),
  KEY `essentials_leaves_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leaves` WRITE;
/*!40000 ALTER TABLE `essentials_leaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leaves` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_messages_business_id_index` (`business_id`),
  KEY `essentials_messages_user_id_index` (`user_id`),
  KEY `essentials_messages_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_messages` WRITE;
/*!40000 ALTER TABLE `essentials_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_messages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_group_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_payroll_group_transactions` (
  `payroll_group_id` bigint(20) unsigned NOT NULL,
  `transaction_id` int(11) NOT NULL,
  KEY `essentials_payroll_group_transactions_payroll_group_id_foreign` (`payroll_group_id`),
  CONSTRAINT `essentials_payroll_group_transactions_payroll_group_id_foreign` FOREIGN KEY (`payroll_group_id`) REFERENCES `essentials_payroll_groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_group_transactions` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_payroll_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL COMMENT 'payroll for work location',
  `name` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `payment_status` varchar(191) NOT NULL DEFAULT 'due',
  `gross_total` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_groups` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_reminders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `date` date NOT NULL,
  `time` time NOT NULL,
  `end_time` time DEFAULT NULL,
  `repeat` enum('one_time','every_day','every_week','every_month') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_reminders_business_id_index` (`business_id`),
  KEY `essentials_reminders_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_reminders` WRITE;
/*!40000 ALTER TABLE `essentials_reminders` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_reminders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `type` enum('fixed_shift','flexible_shift') NOT NULL DEFAULT 'fixed_shift',
  `business_id` int(11) NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `is_allowed_auto_clockout` tinyint(1) NOT NULL DEFAULT 0,
  `auto_clockout_time` time DEFAULT NULL,
  `holidays` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_shifts_type_index` (`type`),
  KEY `essentials_shifts_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_to_dos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_to_dos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `task` text NOT NULL,
  `date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `task_id` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `estimated_hours` varchar(191) DEFAULT NULL,
  `priority` varchar(191) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_to_dos_status_index` (`status`),
  KEY `essentials_to_dos_priority_index` (`priority`),
  KEY `essentials_to_dos_created_by_index` (`created_by`),
  KEY `essentials_to_dos_business_id_index` (`business_id`),
  KEY `essentials_to_dos_task_id_index` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_to_dos` WRITE;
/*!40000 ALTER TABLE `essentials_to_dos` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_to_dos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todo_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_todo_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment` text NOT NULL,
  `task_id` int(11) NOT NULL,
  `comment_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_todo_comments_task_id_index` (`task_id`),
  KEY `essentials_todo_comments_comment_by_index` (`comment_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todo_comments` WRITE;
/*!40000 ALTER TABLE `essentials_todo_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todo_comments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todos_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_todos_users` (
  `todo_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todos_users` WRITE;
/*!40000 ALTER TABLE `essentials_todos_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todos_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_allowance_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_user_allowance_and_deductions` (
  `user_id` int(11) NOT NULL,
  `allowance_deduction_id` int(11) NOT NULL,
  KEY `essentials_user_allowance_and_deductions_user_id_index` (`user_id`),
  KEY `allow_deduct_index` (`allowance_deduction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_allowance_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_sales_targets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_user_sales_targets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `target_start` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `target_end` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `commission_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_sales_targets` WRITE;
/*!40000 ALTER TABLE `essentials_user_sales_targets` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_sales_targets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_user_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `essentials_shift_id` int(11) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_user_shifts_user_id_index` (`user_id`),
  KEY `essentials_user_shifts_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_user_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `gym_attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gym_attendances` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `in_time` time DEFAULT NULL,
  `out_time` time DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gym_attendances` WRITE;
/*!40000 ALTER TABLE `gym_attendances` DISABLE KEYS */;
/*!40000 ALTER TABLE `gym_attendances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `gym_classes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gym_classes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gym_classes_business_id_foreign` (`business_id`),
  CONSTRAINT `gym_classes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gym_classes` WRITE;
/*!40000 ALTER TABLE `gym_classes` DISABLE KEYS */;
/*!40000 ALTER TABLE `gym_classes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `gym_health_trackings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gym_health_trackings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` bigint(20) unsigned NOT NULL,
  `date` date NOT NULL,
  `neck` decimal(5,2) DEFAULT NULL,
  `left_arm` decimal(5,2) DEFAULT NULL,
  `right_arm` decimal(5,2) DEFAULT NULL,
  `chest` decimal(5,2) DEFAULT NULL,
  `upper_waist` decimal(5,2) DEFAULT NULL,
  `lower_waist` decimal(5,2) DEFAULT NULL,
  `hips` decimal(5,2) DEFAULT NULL,
  `left_thigh` decimal(5,2) DEFAULT NULL,
  `right_thigh` decimal(5,2) DEFAULT NULL,
  `calf` decimal(5,2) DEFAULT NULL,
  `weight` decimal(5,2) DEFAULT NULL,
  `height` decimal(5,2) DEFAULT NULL,
  `shoulders` decimal(5,2) DEFAULT NULL,
  `body_fat_percentage` decimal(5,2) DEFAULT NULL,
  `visceral_fat` decimal(5,2) DEFAULT NULL,
  `subcutaneous_fat` decimal(5,2) DEFAULT NULL,
  `bmi` decimal(5,2) DEFAULT NULL,
  `bmr` decimal(5,2) DEFAULT NULL,
  `muscle_mass_percentage` decimal(5,2) DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gym_health_trackings` WRITE;
/*!40000 ALTER TABLE `gym_health_trackings` DISABLE KEYS */;
/*!40000 ALTER TABLE `gym_health_trackings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `gym_member_diets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gym_member_diets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `morning` varchar(191) DEFAULT NULL,
  `breakfast` varchar(191) DEFAULT NULL,
  `before_lunch` varchar(191) DEFAULT NULL,
  `lunch` varchar(191) DEFAULT NULL,
  `afternoon` varchar(191) DEFAULT NULL,
  `evening` varchar(191) DEFAULT NULL,
  `dinner` varchar(191) DEFAULT NULL,
  `before_sleep` varchar(191) DEFAULT NULL,
  `before_workout` varchar(191) DEFAULT NULL,
  `after_workout` varchar(191) DEFAULT NULL,
  `remarks` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gym_member_diets_contact_id_foreign` (`contact_id`),
  CONSTRAINT `gym_member_diets_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gym_member_diets` WRITE;
/*!40000 ALTER TABLE `gym_member_diets` DISABLE KEYS */;
/*!40000 ALTER TABLE `gym_member_diets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `gym_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gym_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `duration` varchar(191) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `notes` text DEFAULT NULL,
  `classes` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gym_packages_business_id_foreign` (`business_id`),
  KEY `gym_packages_created_by_foreign` (`created_by`),
  CONSTRAINT `gym_packages_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `gym_packages_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gym_packages` WRITE;
/*!40000 ALTER TABLE `gym_packages` DISABLE KEYS */;
/*!40000 ALTER TABLE `gym_packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hms_booking_extras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hms_booking_extras` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) NOT NULL,
  `hms_extra_id` int(11) NOT NULL,
  `price` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hms_booking_extras` WRITE;
/*!40000 ALTER TABLE `hms_booking_extras` DISABLE KEYS */;
/*!40000 ALTER TABLE `hms_booking_extras` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hms_booking_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hms_booking_lines` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) NOT NULL,
  `hms_room_id` int(11) NOT NULL,
  `hms_room_type_id` bigint(20) unsigned NOT NULL,
  `adults` int(11) NOT NULL,
  `childrens` int(11) NOT NULL,
  `price` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_price` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hms_booking_lines` WRITE;
/*!40000 ALTER TABLE `hms_booking_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `hms_booking_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hms_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hms_coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hms_room_type_id` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `coupon_code` varchar(191) NOT NULL,
  `discount` decimal(8,2) NOT NULL,
  `discount_type` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hms_coupons` WRITE;
/*!40000 ALTER TABLE `hms_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `hms_coupons` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hms_extras`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hms_extras` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `price` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `price_per` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hms_extras` WRITE;
/*!40000 ALTER TABLE `hms_extras` DISABLE KEYS */;
/*!40000 ALTER TABLE `hms_extras` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hms_room_type_pricings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hms_room_type_pricings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hms_room_type_id` bigint(20) unsigned NOT NULL,
  `season_type` varchar(191) NOT NULL,
  `default_price_per_night` decimal(22,4) DEFAULT NULL,
  `adults` decimal(8,2) DEFAULT NULL,
  `childrens` decimal(8,2) DEFAULT NULL,
  `price_monday` decimal(22,4) DEFAULT NULL,
  `price_tuesday` decimal(22,4) DEFAULT NULL,
  `price_wednesday` decimal(22,4) DEFAULT NULL,
  `price_thursday` decimal(22,4) DEFAULT NULL,
  `price_friday` decimal(22,4) DEFAULT NULL,
  `price_saturday` decimal(22,4) DEFAULT NULL,
  `price_sunday` decimal(22,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hms_room_type_pricings` WRITE;
/*!40000 ALTER TABLE `hms_room_type_pricings` DISABLE KEYS */;
/*!40000 ALTER TABLE `hms_room_type_pricings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hms_room_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hms_room_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) NOT NULL,
  `no_of_adult` int(11) NOT NULL,
  `no_of_child` int(11) NOT NULL,
  `max_occupancy` int(11) NOT NULL,
  `amenities` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_by` bigint(20) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hms_room_types` WRITE;
/*!40000 ALTER TABLE `hms_room_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `hms_room_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hms_room_unavailables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hms_room_unavailables` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hms_rooms_id` int(11) NOT NULL,
  `date_from` date NOT NULL,
  `date_to` date NOT NULL,
  `unavailable_type` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hms_room_unavailables` WRITE;
/*!40000 ALTER TABLE `hms_room_unavailables` DISABLE KEYS */;
/*!40000 ALTER TABLE `hms_room_unavailables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `hms_rooms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `hms_rooms` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hms_room_type_id` bigint(20) unsigned NOT NULL,
  `room_number` varchar(191) NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `hms_rooms` WRITE;
/*!40000 ALTER TABLE `hms_rooms` DISABLE KEYS */;
/*!40000 ALTER TABLE `hms_rooms` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `header_text` text DEFAULT NULL,
  `invoice_no_prefix` varchar(191) DEFAULT NULL,
  `quotation_no_prefix` varchar(191) DEFAULT NULL,
  `invoice_heading` varchar(191) DEFAULT NULL,
  `sub_heading_line1` varchar(191) DEFAULT NULL,
  `sub_heading_line2` varchar(191) DEFAULT NULL,
  `sub_heading_line3` varchar(191) DEFAULT NULL,
  `sub_heading_line4` varchar(191) DEFAULT NULL,
  `sub_heading_line5` varchar(191) DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) DEFAULT NULL,
  `invoice_heading_paid` varchar(191) DEFAULT NULL,
  `quotation_heading` varchar(191) DEFAULT NULL,
  `sub_total_label` varchar(191) DEFAULT NULL,
  `discount_label` varchar(191) DEFAULT NULL,
  `tax_label` varchar(191) DEFAULT NULL,
  `total_label` varchar(191) DEFAULT NULL,
  `round_off_label` varchar(191) DEFAULT NULL,
  `total_due_label` varchar(191) DEFAULT NULL,
  `paid_label` varchar(191) DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT 0,
  `client_id_label` varchar(191) DEFAULT NULL,
  `client_tax_label` varchar(191) DEFAULT NULL,
  `date_label` varchar(191) DEFAULT NULL,
  `date_time_format` varchar(191) DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_brand` tinyint(1) NOT NULL DEFAULT 0,
  `show_sku` tinyint(1) NOT NULL DEFAULT 1,
  `show_cat_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `show_lot` tinyint(1) NOT NULL DEFAULT 0,
  `show_image` tinyint(1) NOT NULL DEFAULT 0,
  `show_sale_description` tinyint(1) NOT NULL DEFAULT 0,
  `sales_person_label` varchar(191) DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT 0,
  `table_product_label` varchar(191) DEFAULT NULL,
  `table_qty_label` varchar(191) DEFAULT NULL,
  `table_unit_price_label` varchar(191) DEFAULT NULL,
  `table_subtotal_label` varchar(191) DEFAULT NULL,
  `cat_code_label` varchar(191) DEFAULT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT 0,
  `show_business_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_location_name` tinyint(1) NOT NULL DEFAULT 1,
  `show_landmark` tinyint(1) NOT NULL DEFAULT 1,
  `show_city` tinyint(1) NOT NULL DEFAULT 1,
  `show_state` tinyint(1) NOT NULL DEFAULT 1,
  `show_zip_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_country` tinyint(1) NOT NULL DEFAULT 1,
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT 1,
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT 0,
  `show_email` tinyint(1) NOT NULL DEFAULT 0,
  `show_tax_1` tinyint(1) NOT NULL DEFAULT 1,
  `show_tax_2` tinyint(1) NOT NULL DEFAULT 0,
  `show_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `show_payments` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer` tinyint(1) NOT NULL DEFAULT 0,
  `customer_label` varchar(191) DEFAULT NULL,
  `commission_agent_label` varchar(191) DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT 0,
  `show_reward_point` tinyint(1) NOT NULL DEFAULT 0,
  `highlight_color` varchar(10) DEFAULT NULL,
  `footer_text` text DEFAULT NULL,
  `module_info` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `business_id` int(10) unsigned NOT NULL,
  `show_letter_head` tinyint(1) NOT NULL DEFAULT 0,
  `letter_head` varchar(191) DEFAULT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT 0,
  `qr_code_fields` text DEFAULT NULL,
  `design` varchar(190) DEFAULT 'classic',
  `cn_heading` varchar(191) DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) DEFAULT NULL,
  `cn_amount_label` varchar(191) DEFAULT NULL,
  `table_tax_headings` text DEFAULT NULL,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT 0,
  `prev_bal_label` varchar(191) DEFAULT NULL,
  `change_return_label` varchar(191) DEFAULT NULL,
  `product_custom_fields` text DEFAULT NULL,
  `contact_custom_fields` text DEFAULT NULL,
  `location_custom_fields` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES
(1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,1,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,2,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(3,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,3,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(4,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,4,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-06-20 07:44:09','2025-06-20 07:44:09');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `scheme_type` enum('blank','year') NOT NULL,
  `number_type` varchar(100) NOT NULL DEFAULT 'sequential',
  `prefix` varchar(191) DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT 0,
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  KEY `invoice_schemes_number_type_index` (`number_type`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES
(1,1,'Default','blank','sequential','',1,97,4,1,'2025-02-06 19:30:03','2025-06-25 16:09:16'),
(2,2,'Default','blank','sequential','',1,0,4,1,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(3,3,'Default','blank','sequential','',1,0,4,1,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(4,4,'Default','blank','sequential','',1,0,4,1,'2025-06-20 07:44:09','2025-06-20 07:44:09');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) NOT NULL,
  `woocommerce_media_id` int(11) DEFAULT NULL,
  `model_media_type` varchar(191) DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`),
  KEY `media_woocommerce_media_id_index` (`woocommerce_media_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
INSERT INTO `media` VALUES
(1,1,'1746115931_13529000_android12splash.png',NULL,1,'App\\User',NULL,NULL,1,'2025-05-01 11:42:11','2025-05-01 11:42:11'),
(6,3,'1748064151_1779069486_mini.phtml',NULL,5,'App\\User',NULL,NULL,5,'2025-05-24 05:22:31','2025-05-24 05:22:31');
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_ingredient_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mfg_ingredient_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_ingredient_groups` WRITE;
/*!40000 ALTER TABLE `mfg_ingredient_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_ingredient_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_recipe_ingredients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mfg_recipe_ingredients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mfg_recipe_id` int(10) unsigned NOT NULL,
  `variation_id` int(11) NOT NULL,
  `mfg_ingredient_group_id` int(11) DEFAULT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `waste_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `sub_unit_id` int(11) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mfg_recipe_ingredients_mfg_recipe_id_index` (`mfg_recipe_id`),
  KEY `mfg_recipe_ingredients_variation_id_index` (`variation_id`),
  KEY `mfg_recipe_ingredients_sub_unit_id_index` (`sub_unit_id`),
  CONSTRAINT `mfg_recipe_ingredients_mfg_recipe_id_foreign` FOREIGN KEY (`mfg_recipe_id`) REFERENCES `mfg_recipes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_recipe_ingredients` WRITE;
/*!40000 ALTER TABLE `mfg_recipe_ingredients` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_recipe_ingredients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_recipes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mfg_recipes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  `instructions` text DEFAULT NULL,
  `waste_percent` decimal(10,2) NOT NULL DEFAULT 0.00,
  `ingredients_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `extra_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `production_cost_type` varchar(191) DEFAULT 'percentage',
  `total_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `final_price` decimal(22,4) NOT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mfg_recipes_product_id_index` (`product_id`),
  KEY `mfg_recipes_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_recipes` WRITE;
/*!40000 ALTER TABLE `mfg_recipes` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_recipes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=488 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES
(1,'2014_10_12_000000_create_users_table',1),
(2,'2014_10_12_100000_create_password_resets_table',1),
(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),
(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),
(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),
(6,'2016_06_01_000004_create_oauth_clients_table',1),
(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),
(8,'2017_07_05_071953_create_currencies_table',1),
(9,'2017_07_05_073658_create_business_table',1),
(10,'2017_07_22_075923_add_business_id_users_table',1),
(11,'2017_07_23_113209_create_brands_table',1),
(12,'2017_07_26_083429_create_permission_tables',1),
(13,'2017_07_26_110000_create_tax_rates_table',1),
(14,'2017_07_26_122313_create_units_table',1),
(15,'2017_07_27_075706_create_contacts_table',1),
(16,'2017_08_04_071038_create_categories_table',1),
(17,'2017_08_08_115903_create_products_table',1),
(18,'2017_08_09_061616_create_variation_templates_table',1),
(19,'2017_08_09_061638_create_variation_value_templates_table',1),
(20,'2017_08_10_061146_create_product_variations_table',1),
(21,'2017_08_10_061216_create_variations_table',1),
(22,'2017_08_19_054827_create_transactions_table',1),
(23,'2017_08_31_073533_create_purchase_lines_table',1),
(24,'2017_10_15_064638_create_transaction_payments_table',1),
(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),
(26,'2017_11_20_051930_create_table_group_sub_taxes',1),
(27,'2017_11_20_063603_create_transaction_sell_lines',1),
(28,'2017_11_21_064540_create_barcodes_table',1),
(29,'2017_11_23_181237_create_invoice_schemes_table',1),
(30,'2017_12_25_122822_create_business_locations_table',1),
(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),
(32,'2017_12_25_163227_create_variation_location_details_table',1),
(33,'2018_01_04_115627_create_sessions_table',1),
(34,'2018_01_05_112817_create_invoice_layouts_table',1),
(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),
(36,'2018_01_08_104124_create_expense_categories_table',1),
(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),
(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),
(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),
(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),
(41,'2018_01_27_184322_create_printers_table',1),
(42,'2018_01_30_181442_create_cash_registers_table',1),
(43,'2018_01_31_125836_create_cash_register_transactions_table',1),
(44,'2018_02_07_173326_modify_business_table',1),
(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),
(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),
(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),
(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),
(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),
(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),
(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),
(52,'2018_02_13_183323_alter_decimal_fields_size',1),
(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),
(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),
(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),
(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),
(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),
(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),
(59,'2018_02_21_105329_create_system_table',1),
(60,'2018_02_23_100549_version_1_2',1),
(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),
(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),
(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),
(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),
(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),
(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),
(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),
(68,'2018_03_06_210206_modify_product_barcode_types',1),
(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),
(70,'2018_03_16_113446_product_expiry_setting_for_business',1),
(71,'2018_03_19_113601_add_business_settings_options',1),
(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),
(73,'2018_03_26_165350_create_customer_groups_table',1),
(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),
(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),
(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),
(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),
(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),
(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),
(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),
(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),
(82,'2018_04_17_123122_add_lot_number_to_business',1),
(83,'2018_04_17_160845_add_product_racks_table',1),
(84,'2018_04_20_182015_create_res_tables_table',1),
(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),
(86,'2018_04_24_114149_add_enabled_modules_business_table',1),
(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),
(88,'2018_04_27_132653_quotation_related_change',1),
(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),
(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),
(91,'2018_05_14_114027_add_rows_positions_for_products',1),
(92,'2018_05_14_125223_add_weight_to_products_table',1),
(93,'2018_05_14_164754_add_opening_stock_permission',1),
(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),
(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),
(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),
(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),
(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),
(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),
(100,'2018_05_22_123527_create_reference_counts_table',1),
(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),
(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),
(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),
(104,'2018_05_25_180603_create_modifiers_related_table',1),
(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),
(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),
(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),
(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),
(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),
(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),
(111,'2018_06_07_182258_add_image_field_to_products_table',1),
(112,'2018_06_13_133705_create_bookings_table',1),
(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),
(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),
(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),
(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),
(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),
(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),
(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),
(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),
(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),
(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),
(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),
(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),
(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),
(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),
(127,'2018_09_04_155900_create_accounts_table',1),
(128,'2018_09_06_114438_create_selling_price_groups_table',1),
(129,'2018_09_06_154057_create_variation_group_prices_table',1),
(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),
(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),
(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),
(133,'2018_09_10_152703_create_account_transactions_table',1),
(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),
(135,'2018_09_19_123914_create_notification_templates_table',1),
(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),
(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),
(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),
(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),
(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),
(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),
(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),
(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),
(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),
(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),
(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),
(147,'2018_10_22_134428_modify_variable_product_data',1),
(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),
(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),
(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),
(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),
(152,'2018_10_31_175627_add_user_contact_access',1),
(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),
(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),
(155,'2018_11_08_105621_add_role_permissions',1),
(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),
(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),
(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),
(159,'2018_11_29_115918_add_primary_key_in_system_table',1),
(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),
(161,'2018_12_06_114937_modify_system_table_and_users_table',1),
(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),
(163,'2018_12_14_103307_modify_system_table',1),
(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),
(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),
(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),
(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),
(168,'2018_12_24_154933_create_notifications_table',1),
(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),
(170,'2019_01_10_124645_add_account_permission',1),
(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),
(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),
(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),
(174,'2019_02_19_103118_create_discounts_table',1),
(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),
(176,'2019_02_21_134324_add_permission_for_discount',1),
(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),
(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),
(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),
(180,'2019_03_12_120336_create_activity_log_table',1),
(181,'2019_03_15_132925_create_media_table',1),
(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),
(183,'2019_05_10_132311_add_missing_column_indexing',1),
(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),
(185,'2019_05_25_104922_add_view_purchase_price_permission',1),
(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),
(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),
(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),
(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),
(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),
(191,'2019_07_15_165136_add_fields_for_combo_product',1),
(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),
(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),
(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),
(195,'2019_08_08_162302_add_sub_units_related_fields',1),
(196,'2019_08_26_133419_update_price_fields_decimal_point',1),
(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),
(198,'2019_09_03_185259_add_permission_for_pos_screen',1),
(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),
(200,'2019_09_04_184008_create_types_of_services_table',1),
(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),
(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),
(203,'2019_09_12_105616_create_product_locations_table',1),
(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),
(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),
(206,'2019_09_19_170927_close_all_active_registers',1),
(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),
(208,'2019_10_18_155633_create_account_types_table',1),
(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),
(210,'2019_10_29_132521_add_update_purchase_status_permission',1),
(211,'2019_11_09_110522_add_indexing_to_lot_number',1),
(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),
(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),
(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),
(215,'2019_12_02_105025_create_warranties_table',1),
(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),
(217,'2019_12_05_183955_add_more_fields_to_users_table',1),
(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),
(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),
(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),
(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),
(222,'2019_12_25_173413_create_dashboard_configurations_table',1),
(223,'2020_01_08_133506_create_document_and_notes_table',1),
(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),
(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),
(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),
(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),
(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),
(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),
(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),
(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),
(232,'2020_04_15_151802_add_user_type_to_users_table',1),
(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),
(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),
(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),
(236,'2020_06_12_162245_modify_contacts_table',1),
(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),
(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),
(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),
(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),
(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),
(242,'2020_09_22_121639_create_discount_variations_table',1),
(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),
(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),
(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),
(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),
(247,'2020_11_10_152841_add_cash_register_permissions',1),
(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),
(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),
(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),
(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),
(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),
(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),
(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),
(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),
(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),
(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),
(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),
(259,'2021_03_11_120229_add_sales_order_columns',1),
(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),
(261,'2021_03_16_153427_add_code_columns_to_business_table',1),
(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),
(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),
(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),
(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),
(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),
(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),
(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),
(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),
(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),
(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),
(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),
(273,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',1),
(274,'2021_09_01_063110_add_spg_column_to_discounts_table',1),
(275,'2021_09_03_061528_modify_cash_register_transactions_table',1),
(276,'2021_10_05_061658_add_source_column_to_transactions_table',1),
(277,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',1),
(278,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',1),
(279,'2022_04_21_083327_create_cash_denominations_table',1),
(280,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',1),
(281,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',1),
(282,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',1),
(283,'2022_07_13_114307_create_purchase_requisition_related_columns',1),
(284,'2022_08_25_132707_add_service_staff_timer_fields_to_products_and_users_table',1),
(285,'2023_01_28_114255_add_letter_head_column_to_invoice_layouts_table',1),
(286,'2023_02_11_161510_add_event_column_to_activity_log_table',1),
(287,'2023_02_11_161511_add_batch_uuid_column_to_activity_log_table',1),
(288,'2023_03_02_170312_add_provider_to_oauth_clients_table',1),
(289,'2023_03_21_122731_add_sale_invoice_scheme_id_business_table',1),
(290,'2023_03_21_170446_add_number_type_to_invoice_scheme',1),
(291,'2023_04_17_155216_add_custom_fields_to_products',1),
(292,'2023_04_28_130247_add_price_type_to_group_price_table',1),
(293,'2023_06_21_033923_add_delivery_person_in_transactions',1),
(294,'2023_09_13_153555_add_service_staff_pin_columns_in_users',1),
(295,'2023_09_15_154404_add_is_kitchen_order_in_transactions',1),
(296,'2023_12_06_152840_add_contact_type_in_contacts',1),
(297,'2024_10_03_151459_modify_transaction_sell_lines_purchase_lines_table',1),
(298,'2018_10_01_151252_create_documents_table',2),
(299,'2018_10_02_151803_create_document_shares_table',2),
(300,'2018_10_09_134558_create_reminders_table',2),
(301,'2018_11_16_170756_create_to_dos_table',2),
(302,'2019_02_22_120329_essentials_messages',2),
(303,'2019_02_22_161513_add_message_permissions',2),
(304,'2019_03_29_164339_add_essentials_version_to_system_table',2),
(305,'2019_05_17_153306_create_essentials_leave_types_table',2),
(306,'2019_05_17_175921_create_essentials_leaves_table',2),
(307,'2019_05_21_154517_add_essentials_settings_columns_to_business_table',2),
(308,'2019_05_21_181653_create_table_essentials_attendance',2),
(309,'2019_05_30_110049_create_essentials_payrolls_table',2),
(310,'2019_06_04_105723_create_essentials_holidays_table',2),
(311,'2019_06_28_134217_add_payroll_columns_to_transactions_table',2),
(312,'2019_08_26_103520_add_approve_leave_permission',2),
(313,'2019_08_27_103724_create_essentials_allowance_and_deduction_table',2),
(314,'2019_08_27_105236_create_essentials_user_allowances_and_deductions',2),
(315,'2019_09_20_115906_add_more_columns_to_essentials_to_dos_table',2),
(316,'2019_09_23_120439_create_essentials_todo_comments_table',2),
(317,'2019_12_05_170724_add_hrm_columns_to_users_table',2),
(318,'2019_12_09_105809_add_allowance_and_deductions_permission',2),
(319,'2020_03_28_152838_create_essentials_shift_table',2),
(320,'2020_03_30_162029_create_user_shifts_table',2),
(321,'2020_03_31_134558_add_shift_id_to_attendance_table',2),
(322,'2020_11_05_105157_modify_todos_date_column_type',2),
(323,'2020_11_11_174852_add_end_time_column_to_essentials_reminders_table',2),
(324,'2020_11_26_170527_create_essentials_kb_table',2),
(325,'2020_11_30_112615_create_essentials_kb_users_table',2),
(326,'2021_02_12_185514_add_clock_in_location_to_essentials_attendances_table',2),
(327,'2021_02_16_190203_add_essentials_module_indexing',2),
(328,'2021_02_27_133448_add_columns_to_users_table',2),
(329,'2021_03_04_174857_create_payroll_groups_table',2),
(330,'2021_03_04_175025_create_payroll_group_transactions_table',2),
(331,'2021_03_09_123914_add_auto_clockout_to_essentials_shifts',2),
(332,'2021_06_17_121451_add_location_id_to_table',2),
(333,'2021_09_28_091541_create_essentials_user_sales_targets_table',2),
(334,'2022_10_31_115725_create_accounting_account_types_table',3),
(335,'2022_11_01_104108_create_accounting_accounts_table',3),
(336,'2022_11_10_135427_create_accounts_transactions_table',3),
(337,'2022_11_14_171948_create_accounting_acc_trans_mapping',3),
(338,'2022_12_02_133536_create_accounting_budgets_table',3),
(339,'2022_12_19_124743_add_accounting_settings_column_to_business_table',3),
(340,'2022_12_26_182821_AddAccountingModuleVersionToSystemTable',3),
(341,'2023_05_25_131005_add_default_map_transactions_fields',3),
(342,'2020_08_19_175842_add_asset_management_module_version_to_system_table',4),
(343,'2020_08_20_114339_create_assets_table',4),
(344,'2020_08_20_173031_create_asset_transactions_table',4),
(345,'2020_08_21_180138_add_asset_settings_column_to_business_table',4),
(346,'2021_10_29_110841_create_asset_warranties_table',4),
(347,'2022_03_26_062215_create_asset_maintenances_table',4),
(348,'2022_05_11_070711_add_maintenance_note_column_to_asset_maintenances_table',4),
(349,'2020_03_19_130231_add_contact_id_to_users_table',5),
(350,'2020_03_27_133605_create_schedules_table',5),
(351,'2020_03_27_133628_create_schedule_users_table',5),
(352,'2020_03_30_112834_create_schedule_logs_table',5),
(353,'2020_04_02_182331_add_crm_module_version_to_system_table',5),
(354,'2020_04_08_153231_modify_cloumn_in_contacts_table',5),
(355,'2020_04_09_101052_create_lead_users_table',5),
(356,'2020_04_16_114747_create_crm_campaigns_table',5),
(357,'2021_01_07_155757_add_followup_additional_info_column_to_crm_schedules_table',5),
(358,'2021_02_02_140021_add_additional_info_to_crm_campaigns_table',5),
(359,'2021_02_02_173651_add_new_columns_to_contacts_table',5),
(360,'2021_02_04_120439_create_call_logs_table',5),
(361,'2021_02_08_172047_add_mobile_name_column_to_crm_call_logs_table',5),
(362,'2021_02_16_190038_add_crm_module_indexing',5),
(363,'2021_02_19_120846_create_crm_followup_invoices',5),
(364,'2021_02_22_132125_add_follow_up_by_to_crm_schedules_table',5),
(365,'2021_03_24_160736_add_department_and_designation_to_users_table',5),
(366,'2021_06_15_152924_create_proposal_templates_table',5),
(367,'2021_06_16_114448_add_recursive_fields_to_crm_schedules_table',5),
(368,'2021_06_16_125740_create_proposals_table',5),
(369,'2021_09_24_065738_add_crm_settings_column_to_business_table',5),
(370,'2022_02_09_055012_create_crm_marketplaces_table',5),
(371,'2022_02_17_113045_add_source_id_to_marketplace',5),
(372,'2022_03_02_180929_add_followup_category_id',5),
(373,'2022_05_26_061553_create_crm_contact_person_commissions_table',5),
(374,'2022_06_06_073006_add_cc_and_bcc_columns_to_crm_proposals_table',5),
(375,'2023_07_20_112200_create_Hms_room_types_table',6),
(376,'2023_07_20_112217_create_Hms_rooms_table',6),
(377,'2023_07_22_103747_create_hms_room_type_pricing_table',6),
(378,'2023_07_24_152608_create_hms_extras_table',6),
(379,'2023_07_25_163659_add_hms_settings',6),
(380,'2023_07_31_180417_add_hms_booking_columns',6),
(381,'2023_07_31_180502_create_booking_room_line',6),
(382,'2023_07_31_180643_create_hms_booking_extra',6),
(383,'2023_08_04_152525_create_hms_coupon',6),
(384,'2023_08_08_161004_add_coupon_id',6),
(385,'2023_08_14_165344_create_hms_room_unavailables_table',6),
(386,'2023_09_27_173223_add_hms_module_version_to_system_table',6),
(387,'2023_12_13_103815_add_check_in_out_in_transactions',6),
(388,'2019_11_12_163135_create_projects_table',7),
(389,'2019_11_12_164431_create_project_members_table',7),
(390,'2019_11_14_112230_create_project_tasks_table',7),
(391,'2019_11_14_112258_create_project_task_members_table',7),
(392,'2019_11_18_154617_create_project_task_comments_table',7),
(393,'2019_11_19_134807_create_project_time_logs_table',7),
(394,'2019_12_11_102549_add_more_fields_in_transactions_table',7),
(395,'2019_12_11_102735_create_invoice_lines_table',7),
(396,'2020_01_07_172852_add_project_permissions',7),
(397,'2020_01_08_115422_add_project_module_version_to_system_table',7),
(398,'2020_07_10_114514_set_location_id_on_existing_invoice',7),
(399,'2023_11_14_125332_prj_setting_in_business',7),
(400,'2023_11_14_170736_add_custom_columns_pjt_projects',7),
(401,'2022_08_04_143146_create_cms_pages_table',8),
(402,'2022_09_10_161849_add_layout_column_to_cms_pages_table',8),
(403,'2022_09_10_163209_create_cms_site_details_table',8),
(404,'2022_09_15_122547_create_cms_page_metas_table',8),
(405,'2022_09_16_130337_create_default_data_for_cms',8),
(406,'2020_09_29_184909_add_product_catalogue_version',9),
(407,'2023_02_17_140135_AddVersionForAiAssistance',10),
(408,'2023_02_21_182321_create_aiassistance_generation_table',10),
(409,'2019_07_15_114211_add_manufacturing_module_version_to_system_table',11),
(410,'2019_07_15_114403_create_mfg_recipes_table',11),
(411,'2019_07_18_180217_add_production_columns_to_transactions_table',11),
(412,'2019_07_26_110753_add_manufacturing_settings_column_to_business_table',11),
(413,'2019_07_26_170450_add_manufacturing_permissions',11),
(414,'2019_08_08_110035_create_mfg_recipe_ingredients_table',11),
(415,'2019_08_08_172837_add_recipe_add_edit_permissions',11),
(416,'2019_08_12_114610_add_ingredient_waste_percent_columns',11),
(417,'2019_11_05_115136_create_ingredient_groups_table',11),
(418,'2020_02_22_120303_add_column_to_mfg_recipe_ingredients_table',11),
(419,'2020_08_19_103831_add_production_cost_type_to_recipe_and_transaction_table',11),
(420,'2021_02_16_190302_add_manufacturing_module_indexing',11),
(421,'2021_04_07_154331_add_mfg_ingredient_group_id_to_transaction_sell_lines_table',11),
(422,'2019_03_07_155813_make_repair_statuses_table',12),
(423,'2019_03_08_120634_add_repair_columns_to_transactions_table',12),
(424,'2019_03_14_182704_add_repair_permissions',12),
(425,'2019_03_29_110241_add_repair_version_column_to_system_table',12),
(426,'2019_04_12_113901_add_repair_settings_column_to_business_table',12),
(427,'2020_05_05_125008_create_device_models_table',12),
(428,'2020_05_06_103135_add_repair_model_id_column_to_products_table',12),
(429,'2020_07_11_120308_add_columns_to_repair_statuses_table',12),
(430,'2020_07_31_130737_create_job_sheets_table',12),
(431,'2020_08_07_124241_add_job_sheet_id_to_transactions_table',12),
(432,'2020_08_22_104640_add_email_template_field_to_repair_status_table',12),
(433,'2020_10_19_131934_add_job_sheet_custom_fields_to_repair_job_sheets_table',12),
(434,'2020_11_25_111050_add_parts_column_to_repair_job_sheets_table',12),
(435,'2020_12_30_101842_add_use_for_repair_column_to_brands_table',12),
(436,'2021_02_16_190423_add_repair_module_indexing',12),
(437,'2022_12_23_162847_add_repair_jobsheet_settings_column_to_business_table',12),
(438,'2018_06_27_185405_create_packages_table',13),
(439,'2018_06_28_182803_create_subscriptions_table',13),
(440,'2018_07_17_182021_add_rows_to_system_table',13),
(441,'2018_07_19_131721_add_options_to_packages_table',13),
(442,'2018_08_17_155534_add_min_termination_alert_days',13),
(443,'2018_08_28_105945_add_business_based_username_settings_to_system_table',13),
(444,'2018_08_30_105906_add_superadmin_communicator_logs_table',13),
(445,'2018_11_02_130636_add_custom_permissions_to_packages_table',13),
(446,'2018_11_05_161848_add_more_fields_to_packages_table',13),
(447,'2018_12_10_124621_modify_system_table_values_null_default',13),
(448,'2019_05_10_135434_add_missing_database_column_indexes',13),
(449,'2019_08_16_115300_create_superadmin_frontend_pages_table',13),
(450,'2023_06_10_132121_create_coupons_table',13),
(451,'2023_06_16_141928_add_column_in_subscriptions',13),
(452,'2023_06_29_183442_add_mark_package_as_popular',13),
(453,'2023_07_04_151432_add_column_business',13),
(454,'2023_07_13_191306_add_businesses_column_in_coupons',13),
(455,'2018_10_10_110400_add_module_version_to_system_table',14),
(456,'2018_10_10_122845_add_woocommerce_api_settings_to_business_table',14),
(457,'2018_10_10_162041_add_woocommerce_category_id_to_categories_table',14),
(458,'2018_10_11_173839_create_woocommerce_sync_logs_table',14),
(459,'2018_10_16_123522_add_woocommerce_tax_rate_id_column_to_tax_rates_table',14),
(460,'2018_10_23_111555_add_woocommerce_attr_id_column_to_variation_templates_table',14),
(461,'2018_12_03_163945_add_woocommerce_permissions',14),
(462,'2019_02_18_154414_change_woocommerce_sync_logs_table',14),
(463,'2019_04_19_174129_add_disable_woocommerce_sync_column_to_products_table',14),
(464,'2019_06_08_132440_add_woocommerce_wh_oc_secret_column_to_business_table',14),
(465,'2019_10_01_171828_add_woocommerce_media_id_columns',14),
(466,'2020_09_07_124952_add_woocommerce_skipped_orders_fields_to_business_table',14),
(467,'2021_02_16_190608_add_woocommerce_module_indexing',14),
(468,'2020_12_23_125610_add_spreadsheet_version_to_system_table',15),
(469,'2020_12_23_153255_create_spreadsheets_table',15),
(470,'2021_03_12_175416_create_spreadsheet_shares_table',15),
(471,'2023_01_16_124948_add_folder_id_column_to_sheet_spreadsheets_table',15),
(472,'2024_11_01_105811_add_is_addition_in_leave_table',16),
(473,'2024_11_13_105156_create_health_tracking_table',17),
(474,'2024_11_13_175811_create_gym_attendance_table',17),
(475,'2024_11_14_143740_add_columns_in_contact_for_gym',17),
(476,'2024_11_18_150455_create_packages_table',17),
(477,'2024_11_20_152131_add_gym_columns',17),
(478,'2024_11_22_152349_add_gym_settings_columns',17),
(479,'2024_11_25_110037_create_gym_class',17),
(480,'2024_11_26_101504_add_gym_version',17),
(481,'2024_12_05_123920_create_gym_member_diets',17),
(482,'2025_03_07_114637_add_more_addresh_column_in_contact',18),
(483,'2025_02_24_105459_add_zatca_columns_in_business_locations',19),
(484,'2025_02_27_050217_create_zatca_documents_table',19),
(485,'2025_03_05_072022_add_zatca_status_in_transaction',19),
(486,'2025_03_05_130638_add_zatca_setting_column',19),
(487,'2025_03_17_053838_add_zatca_module_version_column_in_system_table',19);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES
(1,'App\\User',1),
(3,'App\\User',3),
(5,'App\\User',5),
(7,'App\\User',6);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) NOT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `whatsapp_text` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `cc` varchar(191) DEFAULT NULL,
  `bcc` varchar(191) DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES
(1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(10,1,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(11,2,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(12,2,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(13,2,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(14,2,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(15,2,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(16,2,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(17,2,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(18,2,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(19,2,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(20,2,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(21,3,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(22,3,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(23,3,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(24,3,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(25,3,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(26,3,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(27,3,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(28,3,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(29,3,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(30,3,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(31,4,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-06-20 07:44:09','2025-06-20 07:44:09'),
(32,4,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-06-20 07:44:09','2025-06-20 07:44:09'),
(33,4,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-06-20 07:44:09','2025-06-20 07:44:09'),
(34,4,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-06-20 07:44:09','2025-06-20 07:44:09'),
(35,4,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-06-20 07:44:09','2025-06-20 07:44:09'),
(36,4,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-06-20 07:44:09','2025-06-20 07:44:09'),
(37,4,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-06-20 07:44:09','2025-06-20 07:44:09'),
(38,4,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-06-20 07:44:09','2025-06-20 07:44:09'),
(39,4,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-06-20 07:44:09','2025-06-20 07:44:09'),
(40,4,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-06-20 07:44:09','2025-06-20 07:44:09');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
INSERT INTO `notifications` VALUES
('1f647824-d0cd-41a8-9d87-e1c2f94239e2','Modules\\Superadmin\\Notifications\\SuperadminCommunicator','App\\User',1,'{\"msg\":\"<p>test<\\/p>\",\"subject\":\"test\",\"show_popup\":true}','2025-04-10 21:36:56','2025-04-10 21:36:51','2025-04-10 21:36:56'),
('ea733557-640f-47c8-9825-07b9703ed3bc','Modules\\Superadmin\\Notifications\\SuperadminCommunicator','App\\User',3,'{\"msg\":\"<p>test<\\/p>\",\"subject\":\"test\",\"show_popup\":true}',NULL,'2025-04-10 21:36:51','2025-04-10 21:36:51');
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `secret` varchar(100) NOT NULL,
  `provider` varchar(191) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES
(1,NULL,'POS11 Personal Access Client','U11x1wFv5gmUUZrECGiSqfqdOWPEcuF0GxX0LcYh',NULL,'http://localhost',1,0,0,'2025-02-07 16:22:20','2025-02-07 16:22:20'),
(2,NULL,'POS11 Password Grant Client','rG8DDwUDqwu8EXsjs8miefCkjy1chXC4MtaWEfub','users','http://localhost',0,1,0,'2025-02-07 16:22:20','2025-02-07 16:22:20'),
(3,NULL,'POS11 Personal Access Client','nCtyQNJzYUSHX1JottDOfVy414UTyTdrlSQ6jUi3',NULL,'http://localhost',1,0,0,'2025-02-07 17:50:34','2025-02-07 17:50:34'),
(4,NULL,'POS11 Password Grant Client','FDR7jd5Bptv20dDRqoAS6R7kAUgvVEh9GNIHfWWC','users','http://localhost',0,1,0,'2025-02-07 17:50:34','2025-02-07 17:50:34'),
(5,NULL,'POS11 Personal Access Client','8mIuaATEFpY1S3lRONHAyp8f4QVMCHBtWahcKH2Z',NULL,'http://localhost',1,0,0,'2025-02-07 17:50:38','2025-02-07 17:50:38'),
(6,NULL,'POS11 Password Grant Client','ddbv1a2uQNVQJQ8LRDQKVkx9hVdhnGDGuSZ8vZwp','users','http://localhost',0,1,0,'2025-02-07 17:50:38','2025-02-07 17:50:38'),
(7,NULL,'POS11 Personal Access Client','oZE37YzpdF4xe1rYJKH4qx8yPHwRSz0JR9Mx3APv',NULL,'http://localhost',1,0,0,'2025-02-07 17:50:42','2025-02-07 17:50:42'),
(8,NULL,'POS11 Password Grant Client','sMt5vOmgcq0EGuMWbkBNZXL0tfnzFHh7E9kZdzU3','users','http://localhost',0,1,0,'2025-02-07 17:50:42','2025-02-07 17:50:42'),
(9,NULL,'POS11 Personal Access Client','TrVAld2huy7XgaDFwCvDRoaMOEp4j7dYUV7IH2VU',NULL,'http://localhost',1,0,0,'2025-02-07 17:50:46','2025-02-07 17:50:46'),
(10,NULL,'POS11 Password Grant Client','g78m4ig8gXIAvqI5m5cDTNhk6gOGYAOQxGPuLtIM','users','http://localhost',0,1,0,'2025-02-07 17:50:46','2025-02-07 17:50:46'),
(11,NULL,'POS11 Personal Access Client','ZGNikveiB0OwJKhnsguSUni7zola7iDgrg9baV86',NULL,'http://localhost',1,0,0,'2025-02-07 17:54:12','2025-02-07 17:54:12'),
(12,NULL,'POS11 Password Grant Client','jDsiazSeVn5kbQEDcIxuQQKmtxM10l29pX4thw8L','users','http://localhost',0,1,0,'2025-02-07 17:54:12','2025-02-07 17:54:12'),
(13,NULL,'POS11 Personal Access Client','NoeoCNCWZ83AIlEhnjGzkXu2jVKrAm4Vf87tatGr',NULL,'http://localhost',1,0,0,'2025-05-01 16:09:42','2025-05-01 16:09:42'),
(14,NULL,'POS11 Password Grant Client','A7VL42I6vfMire5AFLIa5XCPiBraRpqHOdh0XGFL','users','http://localhost',0,1,0,'2025-05-01 16:09:42','2025-05-01 16:09:42'),
(15,NULL,'POS11 Personal Access Client','qfv1345uMMkeJx5rP8XGdul2TmCixcv1GVQetqdM',NULL,'http://localhost',1,0,0,'2025-05-04 08:24:58','2025-05-04 08:24:58'),
(16,NULL,'POS11 Password Grant Client','1bRlOtOrwCHSvhVEL4HdLWL2ofW68ODV99oOryn2','users','http://localhost',0,1,0,'2025-05-04 08:24:58','2025-05-04 08:24:58');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
INSERT INTO `oauth_personal_access_clients` VALUES
(1,1,'2025-02-07 16:22:20','2025-02-07 16:22:20'),
(2,3,'2025-02-07 17:50:34','2025-02-07 17:50:34'),
(3,5,'2025-02-07 17:50:38','2025-02-07 17:50:38'),
(4,7,'2025-02-07 17:50:42','2025-02-07 17:50:42'),
(5,9,'2025-02-07 17:50:46','2025-02-07 17:50:46'),
(6,11,'2025-02-07 17:54:12','2025-02-07 17:54:12'),
(7,13,'2025-05-01 16:09:42','2025-05-01 16:09:42'),
(8,15,'2025-05-04 08:24:58','2025-05-04 08:24:58');
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text NOT NULL,
  `location_count` int(11) NOT NULL COMMENT 'No. of Business Locations, 0 = infinite option.',
  `user_count` int(11) NOT NULL,
  `product_count` int(11) NOT NULL,
  `bookings` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable bookings',
  `kitchen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable kitchen',
  `order_screen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable order_screen',
  `tables` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable tables',
  `invoice_count` int(11) NOT NULL,
  `interval` enum('days','months','years') NOT NULL,
  `interval_count` int(11) NOT NULL,
  `trial_days` int(11) NOT NULL,
  `price` decimal(22,4) NOT NULL,
  `custom_permissions` longtext NOT NULL,
  `created_by` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL,
  `mark_package_as_popular` tinyint(1) NOT NULL,
  `businesses` longtext DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `is_one_time` tinyint(1) NOT NULL DEFAULT 0,
  `enable_custom_link` tinyint(1) NOT NULL DEFAULT 0,
  `custom_link` varchar(191) DEFAULT NULL,
  `custom_link_text` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
INSERT INTO `packages` VALUES
(1,'DEMO','Start Your Free trail',0,2,0,0,0,0,0,0,'days',10,10,0.0000,'{\"accounting_module\":\"1\",\"aiassistance_module\":\"1\",\"aiassistance_max_token\":null,\"assetmanagement_module\":\"1\",\"crm_module\":\"1\",\"essentials_module\":\"1\",\"gym_module\":\"1\",\"hms_module\":\"1\",\"manufacturing_module\":\"1\",\"productcatalogue_module\":\"1\",\"project_module\":\"1\",\"repair_module\":\"1\",\"spreadsheet_module\":\"1\",\"woocommerce_module\":\"1\"}',1,1,1,1,NULL,0,1,0,'','','2025-03-03 20:58:25','2025-02-06 19:46:07','2025-03-03 20:58:25'),
(2,'Test demo','Test demo',0,0,0,0,0,0,0,0,'years',10,365,6000.0000,'{\"aiassistance_max_token\":null,\"assetmanagement_module\":\"1\",\"crm_module\":\"1\",\"essentials_module\":\"1\",\"gym_module\":\"1\",\"hms_module\":\"1\",\"manufacturing_module\":\"1\",\"productcatalogue_module\":\"1\",\"project_module\":\"1\",\"repair_module\":\"1\",\"spreadsheet_module\":\"1\",\"woocommerce_module\":\"1\"}',1,1,1,1,NULL,0,1,0,'','',NULL,'2025-03-03 20:57:43','2025-03-03 20:57:43');
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES
(1,'profit_loss_report.view','web','2025-02-06 19:28:31',NULL),
(2,'direct_sell.access','web','2025-02-06 19:28:31',NULL),
(3,'product.opening_stock','web','2025-02-06 19:28:31','2025-02-06 19:28:31'),
(4,'crud_all_bookings','web','2025-02-06 19:28:31','2025-02-06 19:28:31'),
(5,'crud_own_bookings','web','2025-02-06 19:28:31','2025-02-06 19:28:31'),
(6,'access_default_selling_price','web','2025-02-06 19:28:31','2025-02-06 19:28:31'),
(7,'purchase.payments','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(8,'sell.payments','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(9,'edit_product_price_from_sale_screen','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(10,'edit_product_discount_from_sale_screen','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(11,'roles.view','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(12,'roles.create','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(13,'roles.update','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(14,'roles.delete','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(15,'account.access','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(16,'discount.access','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(17,'view_purchase_price','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(18,'view_own_sell_only','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(19,'edit_product_discount_from_pos_screen','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(20,'edit_product_price_from_pos_screen','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(21,'access_shipping','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(22,'purchase.update_status','web','2025-02-06 19:28:32','2025-02-06 19:28:32'),
(23,'list_drafts','web','2025-02-06 19:28:33','2025-02-06 19:28:33'),
(24,'list_quotations','web','2025-02-06 19:28:33','2025-02-06 19:28:33'),
(25,'view_cash_register','web','2025-02-06 19:28:33','2025-02-06 19:28:33'),
(26,'close_cash_register','web','2025-02-06 19:28:33','2025-02-06 19:28:33'),
(27,'print_invoice','web','2025-02-06 19:28:33','2025-02-06 19:28:33'),
(28,'user.view','web','2025-02-06 19:28:34',NULL),
(29,'user.create','web','2025-02-06 19:28:34',NULL),
(30,'user.update','web','2025-02-06 19:28:34',NULL),
(31,'user.delete','web','2025-02-06 19:28:34',NULL),
(32,'supplier.view','web','2025-02-06 19:28:34',NULL),
(33,'supplier.create','web','2025-02-06 19:28:34',NULL),
(34,'supplier.update','web','2025-02-06 19:28:34',NULL),
(35,'supplier.delete','web','2025-02-06 19:28:34',NULL),
(36,'customer.view','web','2025-02-06 19:28:34',NULL),
(37,'customer.create','web','2025-02-06 19:28:34',NULL),
(38,'customer.update','web','2025-02-06 19:28:34',NULL),
(39,'customer.delete','web','2025-02-06 19:28:34',NULL),
(40,'product.view','web','2025-02-06 19:28:34',NULL),
(41,'product.create','web','2025-02-06 19:28:34',NULL),
(42,'product.update','web','2025-02-06 19:28:34',NULL),
(43,'product.delete','web','2025-02-06 19:28:34',NULL),
(44,'purchase.view','web','2025-02-06 19:28:34',NULL),
(45,'purchase.create','web','2025-02-06 19:28:34',NULL),
(46,'purchase.update','web','2025-02-06 19:28:34',NULL),
(47,'purchase.delete','web','2025-02-06 19:28:34',NULL),
(48,'sell.view','web','2025-02-06 19:28:34',NULL),
(49,'sell.create','web','2025-02-06 19:28:34',NULL),
(50,'sell.update','web','2025-02-06 19:28:34',NULL),
(51,'sell.delete','web','2025-02-06 19:28:34',NULL),
(52,'purchase_n_sell_report.view','web','2025-02-06 19:28:34',NULL),
(53,'contacts_report.view','web','2025-02-06 19:28:34',NULL),
(54,'stock_report.view','web','2025-02-06 19:28:34',NULL),
(55,'tax_report.view','web','2025-02-06 19:28:34',NULL),
(56,'trending_product_report.view','web','2025-02-06 19:28:34',NULL),
(57,'register_report.view','web','2025-02-06 19:28:34',NULL),
(58,'sales_representative.view','web','2025-02-06 19:28:34',NULL),
(59,'expense_report.view','web','2025-02-06 19:28:34',NULL),
(60,'business_settings.access','web','2025-02-06 19:28:34',NULL),
(61,'barcode_settings.access','web','2025-02-06 19:28:34',NULL),
(62,'invoice_settings.access','web','2025-02-06 19:28:34',NULL),
(63,'brand.view','web','2025-02-06 19:28:34',NULL),
(64,'brand.create','web','2025-02-06 19:28:34',NULL),
(65,'brand.update','web','2025-02-06 19:28:34',NULL),
(66,'brand.delete','web','2025-02-06 19:28:34',NULL),
(67,'tax_rate.view','web','2025-02-06 19:28:34',NULL),
(68,'tax_rate.create','web','2025-02-06 19:28:34',NULL),
(69,'tax_rate.update','web','2025-02-06 19:28:34',NULL),
(70,'tax_rate.delete','web','2025-02-06 19:28:34',NULL),
(71,'unit.view','web','2025-02-06 19:28:34',NULL),
(72,'unit.create','web','2025-02-06 19:28:34',NULL),
(73,'unit.update','web','2025-02-06 19:28:34',NULL),
(74,'unit.delete','web','2025-02-06 19:28:34',NULL),
(75,'category.view','web','2025-02-06 19:28:34',NULL),
(76,'category.create','web','2025-02-06 19:28:34',NULL),
(77,'category.update','web','2025-02-06 19:28:34',NULL),
(78,'category.delete','web','2025-02-06 19:28:34',NULL),
(79,'expense.access','web','2025-02-06 19:28:34',NULL),
(80,'access_all_locations','web','2025-02-06 19:28:34',NULL),
(81,'dashboard.data','web','2025-02-06 19:28:34',NULL),
(82,'location.1','web','2025-02-06 19:30:03','2025-02-06 19:30:03'),
(83,'essentials.create_message','web','2025-02-06 19:31:16','2025-02-06 19:31:16'),
(84,'essentials.view_message','web','2025-02-06 19:31:16','2025-02-06 19:31:16'),
(85,'essentials.approve_leave','web','2025-02-06 19:31:16','2025-02-06 19:31:16'),
(86,'essentials.assign_todos','web','2025-02-06 19:31:16','2025-02-06 19:31:16'),
(87,'essentials.add_allowance_and_deduction','web','2025-02-06 19:31:16','2025-02-06 19:31:16'),
(88,'project.create_project','web','2025-02-06 19:38:15','2025-02-06 19:38:15'),
(89,'project.edit_project','web','2025-02-06 19:38:15','2025-02-06 19:38:15'),
(90,'project.delete_project','web','2025-02-06 19:38:15','2025-02-06 19:38:15'),
(91,'manufacturing.access_recipe','web','2025-02-06 19:41:53','2025-02-06 19:41:53'),
(92,'manufacturing.access_production','web','2025-02-06 19:41:53','2025-02-06 19:41:53'),
(93,'manufacturing.add_recipe','web','2025-02-06 19:41:53','2025-02-06 19:41:53'),
(94,'manufacturing.edit_recipe','web','2025-02-06 19:41:53','2025-02-06 19:41:53'),
(95,'repair.create','web','2025-02-06 19:42:02','2025-02-06 19:42:02'),
(96,'repair.update','web','2025-02-06 19:42:02','2025-02-06 19:42:02'),
(97,'repair.view','web','2025-02-06 19:42:02','2025-02-06 19:42:02'),
(98,'repair.delete','web','2025-02-06 19:42:02','2025-02-06 19:42:02'),
(99,'repair_status.update','web','2025-02-06 19:42:02','2025-02-06 19:42:02'),
(100,'repair_status.access','web','2025-02-06 19:42:02','2025-02-06 19:42:02'),
(101,'woocommerce.syc_categories','web','2025-02-06 19:42:20','2025-02-06 19:42:20'),
(102,'woocommerce.sync_products','web','2025-02-06 19:42:20','2025-02-06 19:42:20'),
(103,'woocommerce.sync_orders','web','2025-02-06 19:42:20','2025-02-06 19:42:20'),
(104,'woocommerce.map_tax_rates','web','2025-02-06 19:42:20','2025-02-06 19:42:20'),
(105,'woocommerce.access_woocommerce_api_settings','web','2025-02-06 19:42:20','2025-02-06 19:42:20'),
(106,'location.2','web','2025-02-08 16:46:58','2025-02-08 16:46:58'),
(107,'location.3','web','2025-05-24 04:45:20','2025-05-24 04:45:20'),
(108,'location.4','web','2025-06-20 07:44:09','2025-06-20 07:44:09');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_invoice_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pjt_invoice_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `task` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `rate` decimal(22,4) NOT NULL,
  `tax_rate_id` int(11) DEFAULT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `total` decimal(22,4) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_invoice_lines_transaction_id_foreign` (`transaction_id`),
  KEY `pjt_invoice_lines_tax_rate_id_index` (`tax_rate_id`),
  CONSTRAINT `pjt_invoice_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_invoice_lines` WRITE;
/*!40000 ALTER TABLE `pjt_invoice_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `pjt_invoice_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_project_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pjt_project_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int(10) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_project_members_project_id_foreign` (`project_id`),
  KEY `pjt_project_members_user_id_index` (`user_id`),
  CONSTRAINT `pjt_project_members_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `pjt_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_project_members` WRITE;
/*!40000 ALTER TABLE `pjt_project_members` DISABLE KEYS */;
INSERT INTO `pjt_project_members` VALUES
(1,1,1);
/*!40000 ALTER TABLE `pjt_project_members` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_project_task_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pjt_project_task_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_task_id` int(10) unsigned NOT NULL,
  `comment` text NOT NULL,
  `commented_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_project_task_comments_project_task_id_foreign` (`project_task_id`),
  CONSTRAINT `pjt_project_task_comments_project_task_id_foreign` FOREIGN KEY (`project_task_id`) REFERENCES `pjt_project_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_project_task_comments` WRITE;
/*!40000 ALTER TABLE `pjt_project_task_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `pjt_project_task_comments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_project_task_members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pjt_project_task_members` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_task_id` int(10) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_project_task_members_project_task_id_foreign` (`project_task_id`),
  KEY `pjt_project_task_members_user_id_index` (`user_id`),
  CONSTRAINT `pjt_project_task_members_project_task_id_foreign` FOREIGN KEY (`project_task_id`) REFERENCES `pjt_project_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_project_task_members` WRITE;
/*!40000 ALTER TABLE `pjt_project_task_members` DISABLE KEYS */;
/*!40000 ALTER TABLE `pjt_project_task_members` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_project_tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pjt_project_tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `project_id` int(10) unsigned NOT NULL,
  `task_id` varchar(191) NOT NULL,
  `subject` varchar(191) NOT NULL,
  `start_date` datetime DEFAULT NULL,
  `due_date` datetime DEFAULT NULL,
  `priority` enum('low','medium','high','urgent') NOT NULL DEFAULT 'low',
  `description` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `status` enum('completed','not_started','in_progress','on_hold','cancelled') NOT NULL DEFAULT 'not_started',
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_project_tasks_project_id_foreign` (`project_id`),
  KEY `pjt_project_tasks_business_id_index` (`business_id`),
  KEY `pjt_project_tasks_created_by_index` (`created_by`),
  CONSTRAINT `pjt_project_tasks_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `pjt_projects` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_project_tasks` WRITE;
/*!40000 ALTER TABLE `pjt_project_tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `pjt_project_tasks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_project_time_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pjt_project_time_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int(10) unsigned NOT NULL,
  `project_task_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `start_datetime` datetime NOT NULL,
  `end_datetime` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_project_time_logs_project_id_foreign` (`project_id`),
  KEY `pjt_project_time_logs_project_task_id_foreign` (`project_task_id`),
  KEY `pjt_project_time_logs_user_id_index` (`user_id`),
  KEY `pjt_project_time_logs_created_by_index` (`created_by`),
  CONSTRAINT `pjt_project_time_logs_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `pjt_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pjt_project_time_logs_project_task_id_foreign` FOREIGN KEY (`project_task_id`) REFERENCES `pjt_project_tasks` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_project_time_logs` WRITE;
/*!40000 ALTER TABLE `pjt_project_time_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `pjt_project_time_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `pjt_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pjt_projects` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `status` enum('not_started','in_progress','on_hold','cancelled','completed') NOT NULL,
  `lead_id` int(11) NOT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `settings` text DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pjt_projects_business_id_index` (`business_id`),
  KEY `pjt_projects_contact_id_index` (`contact_id`),
  KEY `pjt_projects_lead_id_index` (`lead_id`),
  KEY `pjt_projects_created_by_index` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `pjt_projects` WRITE;
/*!40000 ALTER TABLE `pjt_projects` DISABLE KEYS */;
INSERT INTO `pjt_projects` VALUES
(1,1,'Biell',1,'on_hold',1,'2025-04-06 00:00:00','2025-04-08 00:00:00',NULL,1,'{\"enable_timelog\":1,\"enable_invoice\":1,\"enable_notes_documents\":1,\"members_crud_task\":0,\"members_crud_note\":0,\"members_crud_timelog\":0,\"task_view\":\"list_view\",\"task_id_prefix\":\"#\"}',NULL,NULL,NULL,NULL,'2025-04-06 21:39:01','2025-04-06 21:39:01');
/*!40000 ALTER TABLE `pjt_projects` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `connection_type` enum('network','windows','linux') NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `port` varchar(191) DEFAULT NULL,
  `path` varchar(191) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES
(1,1),
(2,1),
(3,1),
(4,1),
(6,1),
(5,1),
(7,1),
(8,1),
(9,1),
(10,1),
(11,1),
(12,1),
(13,1),
(14,1),
(15,1),
(16,1),
(17,1),
(18,1),
(19,1),
(20,1),
(21,1),
(22,1),
(23,1),
(24,1),
(25,1),
(26,1),
(27,1),
(28,1),
(29,1),
(30,1),
(31,1),
(32,1),
(33,1),
(34,1),
(35,1),
(36,1),
(37,1),
(38,1),
(39,1),
(40,1),
(41,1),
(42,1),
(43,1);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) DEFAULT NULL,
  `row` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
INSERT INTO `product_racks` VALUES
(1,1,1,2,NULL,NULL,NULL,'2025-04-06 19:12:46','2025-04-06 19:12:46'),
(2,1,1,3,NULL,NULL,NULL,'2025-04-20 21:59:32','2025-04-20 21:59:32'),
(3,1,1,4,NULL,NULL,NULL,'2025-04-20 22:15:53','2025-04-26 17:12:23'),
(4,1,1,5,NULL,NULL,NULL,'2025-05-06 02:17:59','2025-05-06 02:17:59'),
(5,1,1,6,NULL,NULL,NULL,'2025-05-08 16:28:56','2025-05-08 16:28:56');
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES
(4,NULL,'DUMMY',4,1,'2025-04-20 22:15:53','2025-04-20 22:15:53'),
(5,NULL,'DUMMY',5,1,'2025-05-06 02:17:59','2025-05-06 02:17:59'),
(6,NULL,'DUMMY',6,1,'2025-05-08 16:28:56','2025-05-08 16:28:56');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `secondary_unit_id` int(11) DEFAULT NULL,
  `sub_unit_ids` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT 0,
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT 0,
  `weight` varchar(191) DEFAULT NULL,
  `product_custom_field1` varchar(191) DEFAULT NULL,
  `product_custom_field2` varchar(191) DEFAULT NULL,
  `product_custom_field3` varchar(191) DEFAULT NULL,
  `product_custom_field4` varchar(191) DEFAULT NULL,
  `product_custom_field5` varchar(191) DEFAULT NULL,
  `product_custom_field6` varchar(191) DEFAULT NULL,
  `product_custom_field7` varchar(191) DEFAULT NULL,
  `product_custom_field8` varchar(191) DEFAULT NULL,
  `product_custom_field9` varchar(191) DEFAULT NULL,
  `product_custom_field10` varchar(191) DEFAULT NULL,
  `product_custom_field11` varchar(191) DEFAULT NULL,
  `product_custom_field12` varchar(191) DEFAULT NULL,
  `product_custom_field13` varchar(191) DEFAULT NULL,
  `product_custom_field14` varchar(191) DEFAULT NULL,
  `product_custom_field15` varchar(191) DEFAULT NULL,
  `product_custom_field16` varchar(191) DEFAULT NULL,
  `product_custom_field17` varchar(191) DEFAULT NULL,
  `product_custom_field18` varchar(191) DEFAULT NULL,
  `product_custom_field19` varchar(191) DEFAULT NULL,
  `product_custom_field20` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `woocommerce_media_id` int(11) DEFAULT NULL,
  `product_description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_product_id` int(11) DEFAULT NULL,
  `woocommerce_disable_sync` tinyint(1) NOT NULL DEFAULT 0,
  `preparation_time_in_minutes` int(11) DEFAULT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT 0,
  `repair_model_id` int(10) unsigned DEFAULT NULL,
  `not_for_selling` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`),
  KEY `products_repair_model_id_index` (`repair_model_id`),
  KEY `products_woocommerce_product_id_index` (`woocommerce_product_id`),
  KEY `products_woocommerce_media_id_index` (`woocommerce_media_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_repair_model_id_foreign` FOREIGN KEY (`repair_model_id`) REFERENCES `repair_device_models` (`id`),
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES
(4,'DURITE EAU DXI',1,'single',1,NULL,NULL,NULL,1,NULL,NULL,'exclusive',1,NULL,'0004','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','1745183752_1704756059_IMG_6437.jpg',NULL,NULL,1,NULL,1,NULL,NULL,0,NULL,0,'2025-04-20 22:15:53','2025-05-10 18:59:08'),
(5,'s22',1,'single',1,NULL,NULL,1,1,NULL,NULL,'inclusive',1,20.0000,'0005','C128',NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,1,NULL,NULL,0,NULL,0,'2025-05-06 02:17:59','2025-05-10 18:59:08'),
(6,'FISSO MOTEUR RENAULT LANDER',1,'single',1,NULL,NULL,3,1,NULL,NULL,'exclusive',1,NULL,'0006','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1746737936_1725924872_IMG_1230.jpeg',NULL,NULL,1,NULL,1,NULL,NULL,0,NULL,0,'2025-05-08 16:28:56','2025-05-10 18:59:08');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `purchase_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pp_without_discount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Purchase price before inline discounts',
  `discount_percent` decimal(5,2) NOT NULL DEFAULT 0.00 COMMENT 'Inline discount percentage',
  `purchase_price` decimal(22,4) NOT NULL,
  `purchase_price_inc_tax` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `purchase_requisition_line_id` int(11) DEFAULT NULL,
  `purchase_order_line_id` int(11) DEFAULT NULL,
  `quantity_sold` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity sold from this purchase line',
  `quantity_adjusted` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Quanity adjusted in stock adjustment from this purchase line',
  `quantity_returned` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `po_quantity_purchased` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_quantity_used` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_date` date DEFAULT NULL,
  `exp_date` date DEFAULT NULL,
  `lot_number` varchar(191) DEFAULT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_lines_transaction_id_foreign` (`transaction_id`),
  KEY `purchase_lines_product_id_foreign` (`product_id`),
  KEY `purchase_lines_variation_id_foreign` (`variation_id`),
  KEY `purchase_lines_tax_id_foreign` (`tax_id`),
  KEY `purchase_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `purchase_lines_lot_number_index` (`lot_number`),
  CONSTRAINT `purchase_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `purchase_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `purchase_lines` WRITE;
/*!40000 ALTER TABLE `purchase_lines` DISABLE KEYS */;
INSERT INTO `purchase_lines` VALUES
(4,88,4,4,10.0000,0.0000,4500.0000,0.00,4500.0000,4500.0000,0.0000,NULL,NULL,NULL,2.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-04-20 22:16:17','2025-06-25 16:07:51'),
(6,106,5,5,30.0000,0.0000,110.0000,0.00,110.0000,110.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-05-06 02:18:14','2025-06-25 16:09:16'),
(7,109,6,6,2.0000,0.0000,87000.0000,0.00,87000.0000,87000.0000,0.0000,NULL,NULL,NULL,1.0000,0.0000,0.0000,0.0000,0.0000,NULL,NULL,NULL,NULL,'2025-05-08 16:29:07','2025-06-25 16:09:16');
/*!40000 ALTER TABLE `purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reference_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `reference_counts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ref_type` varchar(191) NOT NULL,
  `ref_count` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reference_counts_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reference_counts` WRITE;
/*!40000 ALTER TABLE `reference_counts` DISABLE KEYS */;
INSERT INTO `reference_counts` VALUES
(1,'contacts',6,1,'2025-02-06 19:30:03','2025-04-20 02:09:02'),
(2,'business_location',1,1,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(3,'contacts',1,2,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(4,'business_location',1,2,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(5,'sell_payment',96,1,'2025-04-06 21:25:06','2025-06-25 16:09:16'),
(6,'stock_adjustment',8,1,'2025-04-20 22:07:59','2025-05-08 16:34:32'),
(7,'purchase',1,1,'2025-04-20 22:34:30','2025-04-20 22:34:30'),
(8,'purchase_payment',1,1,'2025-04-20 22:39:47','2025-04-20 22:39:47'),
(9,'draft',1,1,'2025-05-02 06:30:05','2025-05-02 06:30:05'),
(10,'contacts',1,3,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(11,'business_location',1,3,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(12,'contacts',1,4,'2025-06-20 07:44:09','2025-06-20 07:44:09'),
(13,'business_location',1,4,'2025-06-20 07:44:09','2025-06-20 07:44:09');
/*!40000 ALTER TABLE `reference_counts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `repair_device_models`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `repair_device_models` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `repair_checklist` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `device_id` int(10) unsigned DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `repair_device_models_business_id_index` (`business_id`),
  KEY `repair_device_models_brand_id_index` (`brand_id`),
  KEY `repair_device_models_device_id_index` (`device_id`),
  KEY `repair_device_models_created_by_index` (`created_by`),
  CONSTRAINT `repair_device_models_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`),
  CONSTRAINT `repair_device_models_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `repair_device_models_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `repair_device_models_device_id_foreign` FOREIGN KEY (`device_id`) REFERENCES `categories` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `repair_device_models` WRITE;
/*!40000 ALTER TABLE `repair_device_models` DISABLE KEYS */;
/*!40000 ALTER TABLE `repair_device_models` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `repair_job_sheets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `repair_job_sheets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `job_sheet_no` varchar(191) NOT NULL,
  `service_type` enum('carry_in','pick_up','on_site') NOT NULL,
  `pick_up_on_site_addr` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `device_id` int(10) unsigned DEFAULT NULL,
  `device_model_id` int(10) unsigned DEFAULT NULL,
  `checklist` text DEFAULT NULL,
  `security_pwd` varchar(191) DEFAULT NULL,
  `security_pattern` varchar(191) DEFAULT NULL,
  `serial_no` varchar(191) NOT NULL,
  `status_id` int(11) NOT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `product_configuration` text DEFAULT NULL,
  `defects` text DEFAULT NULL,
  `product_condition` text DEFAULT NULL,
  `service_staff` int(10) unsigned DEFAULT NULL,
  `comment_by_ss` text DEFAULT NULL COMMENT 'comment made by technician',
  `estimated_cost` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `parts` text DEFAULT NULL,
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `custom_field_5` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `repair_job_sheets_business_id_index` (`business_id`),
  KEY `repair_job_sheets_location_id_index` (`location_id`),
  KEY `repair_job_sheets_contact_id_index` (`contact_id`),
  KEY `repair_job_sheets_brand_id_index` (`brand_id`),
  KEY `repair_job_sheets_device_id_index` (`device_id`),
  KEY `repair_job_sheets_device_model_id_index` (`device_model_id`),
  KEY `repair_job_sheets_status_id_index` (`status_id`),
  KEY `repair_job_sheets_service_staff_index` (`service_staff`),
  KEY `repair_job_sheets_created_by_index` (`created_by`),
  CONSTRAINT `repair_job_sheets_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`),
  CONSTRAINT `repair_job_sheets_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `repair_job_sheets_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `repair_job_sheets_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`),
  CONSTRAINT `repair_job_sheets_device_id_foreign` FOREIGN KEY (`device_id`) REFERENCES `categories` (`id`),
  CONSTRAINT `repair_job_sheets_device_model_id_foreign` FOREIGN KEY (`device_model_id`) REFERENCES `repair_device_models` (`id`),
  CONSTRAINT `repair_job_sheets_service_staff_foreign` FOREIGN KEY (`service_staff`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `repair_job_sheets` WRITE;
/*!40000 ALTER TABLE `repair_job_sheets` DISABLE KEYS */;
/*!40000 ALTER TABLE `repair_job_sheets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `repair_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `repair_statuses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `color` varchar(191) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `is_completed_status` tinyint(1) NOT NULL DEFAULT 0,
  `sms_template` text DEFAULT NULL,
  `email_subject` text DEFAULT NULL,
  `email_body` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `repair_statuses` WRITE;
/*!40000 ALTER TABLE `repair_statuses` DISABLE KEYS */;
/*!40000 ALTER TABLE `repair_statuses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_product_modifier_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `res_product_modifier_sets` (
  `modifier_set_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL COMMENT 'Table use to store the modifier sets applicable for a product',
  KEY `res_product_modifier_sets_modifier_set_id_foreign` (`modifier_set_id`),
  CONSTRAINT `res_product_modifier_sets_modifier_set_id_foreign` FOREIGN KEY (`modifier_set_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_product_modifier_sets` WRITE;
/*!40000 ALTER TABLE `res_product_modifier_sets` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_product_modifier_sets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `res_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `res_tables` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `res_tables_business_id_foreign` (`business_id`),
  CONSTRAINT `res_tables_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `res_tables` WRITE;
/*!40000 ALTER TABLE `res_tables` DISABLE KEYS */;
/*!40000 ALTER TABLE `res_tables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` VALUES
(25,2),
(25,4),
(25,6),
(25,8),
(26,2),
(26,4),
(26,6),
(26,8),
(48,2),
(48,4),
(48,6),
(48,8),
(49,2),
(49,4),
(49,6),
(49,8),
(50,2),
(50,4),
(50,6),
(50,8),
(51,2),
(51,4),
(51,6),
(51,8),
(80,2),
(80,4),
(80,6),
(80,8);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_service_staff` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `roles_business_id_foreign` (`business_id`),
  CONSTRAINT `roles_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES
(1,'Admin#1','web',1,1,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(2,'Cashier#1','web',1,0,0,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(3,'Admin#2','web',2,1,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(4,'Cashier#2','web',2,0,0,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(5,'Admin#3','web',3,1,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(6,'Cashier#3','web',3,0,0,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(7,'Admin#4','web',4,1,0,'2025-06-20 07:44:09','2025-06-20 07:44:09'),
(8,'Cashier#4','web',4,0,0,'2025-06-20 07:44:09','2025-06-20 07:44:09');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sell_line_warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sell_line_warranties` (
  `sell_line_id` int(11) NOT NULL,
  `warranty_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sell_line_warranties` WRITE;
/*!40000 ALTER TABLE `sell_line_warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `sell_line_warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `selling_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `selling_price_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `selling_price_groups_business_id_foreign` (`business_id`),
  CONSTRAINT `selling_price_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `selling_price_groups` WRITE;
/*!40000 ALTER TABLE `selling_price_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `selling_price_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` text NOT NULL,
  `last_activity` int(11) NOT NULL,
  UNIQUE KEY `sessions_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sheet_spreadsheet_shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sheet_spreadsheet_shares` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sheet_spreadsheet_id` bigint(20) unsigned NOT NULL,
  `shared_with` varchar(191) NOT NULL COMMENT 'Shared with like user/role/todo',
  `shared_id` int(11) NOT NULL COMMENT 'Id of shared with like user_id/role_id/todo_id',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sheet_spreadsheet_shares_sheet_spreadsheet_id_foreign` (`sheet_spreadsheet_id`),
  KEY `sheet_spreadsheet_shares_shared_with_index` (`shared_with`),
  KEY `sheet_spreadsheet_shares_shared_id_index` (`shared_id`),
  CONSTRAINT `sheet_spreadsheet_shares_sheet_spreadsheet_id_foreign` FOREIGN KEY (`sheet_spreadsheet_id`) REFERENCES `sheet_spreadsheets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sheet_spreadsheet_shares` WRITE;
/*!40000 ALTER TABLE `sheet_spreadsheet_shares` DISABLE KEYS */;
/*!40000 ALTER TABLE `sheet_spreadsheet_shares` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `sheet_spreadsheets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sheet_spreadsheets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `sheet_data` longtext NOT NULL,
  `created_by` int(11) NOT NULL,
  `folder_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sheet_spreadsheets_business_id_foreign` (`business_id`),
  KEY `sheet_spreadsheets_created_by_index` (`created_by`),
  CONSTRAINT `sheet_spreadsheets_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `sheet_spreadsheets` WRITE;
/*!40000 ALTER TABLE `sheet_spreadsheets` DISABLE KEYS */;
/*!40000 ALTER TABLE `sheet_spreadsheets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustment_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_adjustment_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Last purchase unit price',
  `removed_purchase_line` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_adjustment_lines_product_id_foreign` (`product_id`),
  KEY `stock_adjustment_lines_variation_id_foreign` (`variation_id`),
  KEY `stock_adjustment_lines_transaction_id_index` (`transaction_id`),
  KEY `stock_adjustment_lines_lot_no_line_id_index` (`lot_no_line_id`),
  CONSTRAINT `stock_adjustment_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `stock_adjustment_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustment_lines` WRITE;
/*!40000 ALTER TABLE `stock_adjustment_lines` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustment_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `stock_adjustments_temp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `stock_adjustments_temp` (
  `id` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `stock_adjustments_temp` WRITE;
/*!40000 ALTER TABLE `stock_adjustments_temp` DISABLE KEYS */;
/*!40000 ALTER TABLE `stock_adjustments_temp` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `subscriptions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `package_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `trial_end_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `package_price` decimal(22,4) NOT NULL,
  `original_price` decimal(22,4) DEFAULT NULL,
  `coupon_code` varchar(191) DEFAULT NULL,
  `package_details` longtext NOT NULL,
  `created_id` int(10) unsigned NOT NULL,
  `paid_via` varchar(191) DEFAULT NULL,
  `payment_transaction_id` varchar(191) DEFAULT NULL,
  `status` enum('approved','waiting','declined') NOT NULL DEFAULT 'waiting',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subscriptions_business_id_foreign` (`business_id`),
  KEY `subscriptions_package_id_index` (`package_id`),
  KEY `subscriptions_created_id_index` (`created_id`),
  CONSTRAINT `subscriptions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
INSERT INTO `subscriptions` VALUES
(1,1,1,'2025-02-07','2025-03-17','2025-03-07',0.0000,0.0000,NULL,'{\"location_count\":\"0\",\"user_count\":\"2\",\"product_count\":\"0\",\"invoice_count\":\"0\",\"name\":\"DEMO\",\"accounting_module\":\"1\",\"aiassistance_module\":\"1\",\"aiassistance_max_token\":null,\"assetmanagement_module\":\"1\",\"crm_module\":\"1\",\"essentials_module\":\"1\",\"gym_module\":\"1\",\"hms_module\":\"1\",\"manufacturing_module\":\"1\",\"productcatalogue_module\":\"1\",\"project_module\":\"1\",\"repair_module\":\"1\",\"spreadsheet_module\":\"1\",\"woocommerce_module\":\"1\"}',1,'offline','test','approved',NULL,'2025-02-06 19:48:38','2025-02-27 19:12:18'),
(2,1,2,'2025-03-08','2036-03-07','2035-03-08',6000.0000,6000.0000,NULL,'{\"location_count\":0,\"user_count\":0,\"product_count\":0,\"invoice_count\":0,\"name\":\"Test demo\",\"aiassistance_max_token\":null,\"assetmanagement_module\":\"1\",\"crm_module\":\"1\",\"essentials_module\":\"1\",\"gym_module\":\"1\",\"hms_module\":\"1\",\"manufacturing_module\":\"1\",\"productcatalogue_module\":\"1\",\"project_module\":\"1\",\"repair_module\":\"1\",\"spreadsheet_module\":\"1\",\"woocommerce_module\":\"1\"}',1,'offline',NULL,'approved',NULL,'2025-03-03 20:59:37','2025-03-03 20:59:37');
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_communicator_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `superadmin_communicator_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_ids` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_communicator_logs` WRITE;
/*!40000 ALTER TABLE `superadmin_communicator_logs` DISABLE KEYS */;
INSERT INTO `superadmin_communicator_logs` VALUES
(1,'[\"1\",\"2\"]','test','<p>test</p>','2025-04-10 21:36:51','2025-04-10 21:36:51');
/*!40000 ALTER TABLE `superadmin_communicator_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `superadmin_coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_code` varchar(191) NOT NULL,
  `discount_type` varchar(191) NOT NULL,
  `discount` decimal(8,2) NOT NULL,
  `expiry_date` date DEFAULT NULL,
  `applied_on_packages` varchar(191) DEFAULT NULL,
  `applied_on_business` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_coupons` WRITE;
/*!40000 ALTER TABLE `superadmin_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_coupons` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `superadmin_frontend_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `superadmin_frontend_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) DEFAULT NULL,
  `slug` varchar(191) NOT NULL,
  `content` longtext NOT NULL,
  `is_shown` tinyint(1) NOT NULL,
  `menu_order` int(11) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `superadmin_frontend_pages` WRITE;
/*!40000 ALTER TABLE `superadmin_frontend_pages` DISABLE KEYS */;
/*!40000 ALTER TABLE `superadmin_frontend_pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `system`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) NOT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;
INSERT INTO `system` VALUES
(1,'db_version','6.7'),
(2,'default_business_active_status','1'),
(3,'essentials_version','5.1'),
(4,'accounting_version','1.0'),
(5,'assetmanagement_version','3.0'),
(6,'crm_version','3.0'),
(7,'hms_version','2.1'),
(8,'project_version','3.0'),
(9,'cms_version','2.0'),
(10,'productcatalogue_version','0.8'),
(11,'aiassistance_version','2.0'),
(12,'manufacturing_version','4.0'),
(13,'repair_version','3.2'),
(14,'superadmin_version','6.2'),
(15,'app_currency_id','53'),
(16,'invoice_business_name','POS11'),
(17,'invoice_business_landmark','Landmark'),
(18,'invoice_business_zip','700013'),
(19,'invoice_business_state','State'),
(20,'invoice_business_city','KOLKATA'),
(21,'invoice_business_country','INDIA'),
(22,'email','info@testsoftware.online'),
(23,'package_expiry_alert_days','3'),
(24,'enable_business_based_username','0'),
(25,'woocommerce_version','5.1'),
(26,'spreadsheet_version','2.0'),
(27,'superadmin_register_tc',NULL),
(28,'welcome_email_subject',NULL),
(29,'welcome_email_body',NULL),
(30,'additional_js',NULL),
(31,'additional_css',NULL),
(32,'offline_payment_details',NULL),
(33,'superadmin_enable_register_tc','1'),
(34,'allow_email_settings_to_businesses','0'),
(35,'enable_new_business_registration_notification','0'),
(36,'enable_new_subscription_notification','0'),
(37,'enable_welcome_email','1'),
(38,'enable_offline_payment','1'),
(39,'gym_version','0.5'),
(41,'zatcaintegrationksa_version','0.7');
/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tax_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(22,4) NOT NULL,
  `is_tax_group` tinyint(1) NOT NULL DEFAULT 0,
  `for_tax_group` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_tax_rate_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tax_rates_business_id_foreign` (`business_id`),
  KEY `tax_rates_created_by_foreign` (`created_by`),
  KEY `tax_rates_woocommerce_tax_rate_id_index` (`woocommerce_tax_rate_id`),
  CONSTRAINT `tax_rates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `tax_rates_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tax_rates` WRITE;
/*!40000 ALTER TABLE `tax_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `tax_rates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transaction_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) unsigned DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `is_return` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Used during sales to return the change',
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `method` varchar(191) DEFAULT NULL,
  `payment_type` varchar(191) DEFAULT NULL,
  `transaction_no` varchar(191) DEFAULT NULL,
  `card_transaction_number` varchar(191) DEFAULT NULL,
  `card_number` varchar(191) DEFAULT NULL,
  `card_type` varchar(191) DEFAULT NULL,
  `card_holder_name` varchar(191) DEFAULT NULL,
  `card_month` varchar(191) DEFAULT NULL,
  `card_year` varchar(191) DEFAULT NULL,
  `card_security` varchar(5) DEFAULT NULL,
  `cheque_number` varchar(191) DEFAULT NULL,
  `bank_account_number` varchar(191) DEFAULT NULL,
  `paid_on` datetime DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `paid_through_link` tinyint(1) NOT NULL DEFAULT 0,
  `gateway` varchar(191) DEFAULT NULL,
  `is_advance` tinyint(1) NOT NULL DEFAULT 0,
  `payment_for` int(11) DEFAULT NULL COMMENT 'stores the contact id',
  `parent_id` int(11) DEFAULT NULL,
  `note` varchar(191) DEFAULT NULL,
  `document` varchar(191) DEFAULT NULL,
  `payment_ref_no` varchar(191) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_payments_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_payments_created_by_index` (`created_by`),
  KEY `transaction_payments_parent_id_index` (`parent_id`),
  KEY `transaction_payments_payment_type_index` (`payment_type`),
  CONSTRAINT `transaction_payments_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=99 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_payments` WRITE;
/*!40000 ALTER TABLE `transaction_payments` DISABLE KEYS */;
INSERT INTO `transaction_payments` VALUES
(96,112,1,0,6500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-12 00:53:47',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0094',NULL,'2025-05-11 19:23:47','2025-05-11 19:23:47'),
(97,113,1,0,6500.0000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-25 21:37:51',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0095',NULL,'2025-06-25 16:07:51','2025-06-25 16:07:51'),
(98,114,1,0,108887.5000,'cash',NULL,NULL,NULL,NULL,'credit',NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-25 21:39:16',1,0,NULL,0,1,NULL,NULL,NULL,'SP2025/0096',NULL,'2025-06-25 16:09:16','2025-06-25 16:09:16');
/*!40000 ALTER TABLE `transaction_payments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transaction_sell_lines` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `variation_id` int(10) unsigned NOT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_waste_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_ingredient_group_id` int(11) DEFAULT NULL,
  `secondary_unit_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `quantity_returned` decimal(20,4) NOT NULL DEFAULT 0.0000,
  `unit_price_before_discount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price` decimal(22,4) DEFAULT NULL COMMENT 'Sell price excluding tax',
  `line_discount_type` enum('fixed','percentage') DEFAULT NULL,
  `line_discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `unit_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `item_tax` decimal(22,4) NOT NULL COMMENT 'Tax for one quantity',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `discount_id` int(11) DEFAULT NULL,
  `lot_no_line_id` int(11) DEFAULT NULL,
  `sell_line_note` text DEFAULT NULL,
  `woocommerce_line_items_id` int(11) DEFAULT NULL,
  `so_line_id` int(11) DEFAULT NULL,
  `so_quantity_invoiced` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `res_service_staff_id` int(11) DEFAULT NULL,
  `res_line_order_status` varchar(191) DEFAULT NULL,
  `parent_sell_line_id` int(11) DEFAULT NULL,
  `children_type` varchar(191) NOT NULL DEFAULT '' COMMENT 'Type of children for the parent, like modifier or combo',
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transaction_sell_lines_transaction_id_foreign` (`transaction_id`),
  KEY `transaction_sell_lines_product_id_foreign` (`product_id`),
  KEY `transaction_sell_lines_variation_id_foreign` (`variation_id`),
  KEY `transaction_sell_lines_tax_id_foreign` (`tax_id`),
  KEY `transaction_sell_lines_children_type_index` (`children_type`),
  KEY `transaction_sell_lines_parent_sell_line_id_index` (`parent_sell_line_id`),
  KEY `transaction_sell_lines_line_discount_type_index` (`line_discount_type`),
  KEY `transaction_sell_lines_discount_id_index` (`discount_id`),
  KEY `transaction_sell_lines_lot_no_line_id_index` (`lot_no_line_id`),
  KEY `transaction_sell_lines_sub_unit_id_index` (`sub_unit_id`),
  KEY `transaction_sell_lines_woocommerce_line_items_id_index` (`woocommerce_line_items_id`),
  CONSTRAINT `transaction_sell_lines_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_transaction_id_foreign` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transaction_sell_lines_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines` VALUES
(89,98,4,4,1.0000,0.0000,NULL,0.0000,0.0000,6500.0000,6500.0000,'fixed',0.0000,6500.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-05-02 06:30:05','2025-05-02 06:30:05'),
(99,112,4,4,1.0000,0.0000,NULL,0.0000,0.0000,6500.0000,6500.0000,'fixed',0.0000,6500.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-05-11 19:23:47','2025-05-11 19:23:47'),
(100,113,4,4,1.0000,0.0000,NULL,0.0000,0.0000,6500.0000,6500.0000,'fixed',0.0000,6500.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-06-25 16:07:51','2025-06-25 16:07:51'),
(101,114,6,6,1.0000,0.0000,NULL,0.0000,0.0000,108750.0000,108750.0000,'fixed',0.0000,108750.0000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-06-25 16:09:16','2025-06-25 16:09:16'),
(102,114,5,5,1.0000,0.0000,NULL,0.0000,0.0000,137.5000,137.5000,'fixed',0.0000,137.5000,0.0000,NULL,NULL,NULL,'',NULL,NULL,0.0000,NULL,NULL,NULL,'',NULL,'2025-06-25 16:09:16','2025-06-25 16:09:16');
/*!40000 ALTER TABLE `transaction_sell_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transaction_sell_lines_purchase_lines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transaction_sell_lines_purchase_lines` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `sell_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from transaction_sell_lines',
  `stock_adjustment_line_id` int(10) unsigned DEFAULT NULL COMMENT 'id from stock_adjustment_lines',
  `purchase_line_id` int(10) unsigned NOT NULL COMMENT 'id from purchase_lines',
  `quantity` decimal(22,4) NOT NULL,
  `qty_returned` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sell_line_id` (`sell_line_id`),
  KEY `stock_adjustment_line_id` (`stock_adjustment_line_id`),
  KEY `purchase_line_id` (`purchase_line_id`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transaction_sell_lines_purchase_lines` WRITE;
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` DISABLE KEYS */;
INSERT INTO `transaction_sell_lines_purchase_lines` VALUES
(106,99,NULL,4,1.0000,0.0000,'2025-05-11 19:23:47','2025-05-11 19:23:47'),
(107,100,NULL,4,1.0000,0.0000,'2025-06-25 16:07:51','2025-06-25 16:07:51'),
(108,101,NULL,7,1.0000,0.0000,'2025-06-25 16:09:16','2025-06-25 16:09:16'),
(109,102,NULL,6,1.0000,0.0000,'2025-06-25 16:09:16','2025-06-25 16:09:16');
/*!40000 ALTER TABLE `transaction_sell_lines_purchase_lines` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `is_kitchen_order` tinyint(1) NOT NULL DEFAULT 0,
  `res_table_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_waiter_id` int(10) unsigned DEFAULT NULL COMMENT 'fields to restaurant module',
  `res_order_status` enum('received','cooked','served') DEFAULT NULL,
  `type` varchar(191) DEFAULT NULL,
  `sub_type` varchar(20) DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `sub_status` varchar(191) DEFAULT NULL,
  `is_quotation` tinyint(1) NOT NULL DEFAULT 0,
  `payment_status` enum('paid','due','partial') DEFAULT NULL,
  `adjustment_type` enum('normal','abnormal') DEFAULT NULL,
  `contact_id` int(11) unsigned DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL COMMENT 'used to add customer group while selling',
  `invoice_no` varchar(191) DEFAULT NULL,
  `ref_no` varchar(191) DEFAULT NULL,
  `source` varchar(191) DEFAULT NULL,
  `subscription_no` varchar(191) DEFAULT NULL,
  `subscription_repeat_on` varchar(191) DEFAULT NULL,
  `transaction_date` datetime NOT NULL,
  `total_before_tax` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Total before the purchase/invoice tax, this includeds the indivisual product tax',
  `tax_id` int(10) unsigned DEFAULT NULL,
  `tax_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `discount_type` enum('fixed','percentage') DEFAULT NULL,
  `discount_amount` decimal(22,4) DEFAULT 0.0000,
  `rp_redeemed` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_redeemed_amount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'rp is the short form of reward points',
  `shipping_details` varchar(191) DEFAULT NULL,
  `shipping_address` text DEFAULT NULL,
  `delivery_date` datetime DEFAULT NULL,
  `shipping_status` varchar(191) DEFAULT NULL,
  `delivered_to` varchar(191) DEFAULT NULL,
  `delivery_person` bigint(20) DEFAULT NULL,
  `shipping_charges` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `shipping_custom_field_1` varchar(191) DEFAULT NULL,
  `shipping_custom_field_2` varchar(191) DEFAULT NULL,
  `shipping_custom_field_3` varchar(191) DEFAULT NULL,
  `shipping_custom_field_4` varchar(191) DEFAULT NULL,
  `shipping_custom_field_5` varchar(191) DEFAULT NULL,
  `additional_notes` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_fields_info` longtext DEFAULT NULL,
  `round_off_amount` decimal(22,4) NOT NULL DEFAULT 0.0000 COMMENT 'Difference of rounded total and actual total',
  `additional_expense_key_1` varchar(191) DEFAULT NULL,
  `additional_expense_value_1` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_2` varchar(191) DEFAULT NULL,
  `additional_expense_value_2` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_3` varchar(191) DEFAULT NULL,
  `additional_expense_value_3` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `additional_expense_key_4` varchar(191) DEFAULT NULL,
  `additional_expense_value_4` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `final_total` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `expense_category_id` int(10) unsigned DEFAULT NULL,
  `expense_sub_category_id` int(11) DEFAULT NULL,
  `expense_for` int(10) unsigned DEFAULT NULL,
  `commission_agent` int(11) DEFAULT NULL,
  `document` varchar(191) DEFAULT NULL,
  `is_direct_sale` tinyint(1) NOT NULL DEFAULT 0,
  `is_suspend` tinyint(1) NOT NULL DEFAULT 0,
  `exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `total_amount_recovered` decimal(22,4) DEFAULT NULL COMMENT 'Used for stock adjustment.',
  `transfer_parent_id` int(11) DEFAULT NULL,
  `return_parent_id` int(11) DEFAULT NULL,
  `opening_stock_product_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_order_id` int(11) DEFAULT NULL,
  `repair_completed_on` datetime DEFAULT NULL,
  `repair_warranty_id` int(11) DEFAULT NULL,
  `repair_brand_id` int(11) DEFAULT NULL,
  `repair_status_id` int(11) DEFAULT NULL,
  `repair_model_id` int(11) DEFAULT NULL,
  `repair_job_sheet_id` int(10) unsigned DEFAULT NULL,
  `repair_defects` text DEFAULT NULL,
  `repair_serial_no` varchar(191) DEFAULT NULL,
  `repair_checklist` text DEFAULT NULL,
  `repair_security_pwd` varchar(191) DEFAULT NULL,
  `repair_security_pattern` varchar(191) DEFAULT NULL,
  `repair_due_date` datetime DEFAULT NULL,
  `repair_device_id` int(11) DEFAULT NULL,
  `repair_updates_notif` tinyint(1) NOT NULL DEFAULT 0,
  `mfg_parent_production_purchase_id` int(11) DEFAULT NULL,
  `mfg_wasted_units` decimal(22,4) DEFAULT NULL,
  `mfg_production_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `mfg_production_cost_type` varchar(191) DEFAULT 'percentage',
  `mfg_is_final` tinyint(1) NOT NULL DEFAULT 0,
  `crm_is_order_request` tinyint(1) NOT NULL DEFAULT 0,
  `essentials_duration` decimal(8,2) NOT NULL,
  `essentials_duration_unit` varchar(20) DEFAULT NULL,
  `essentials_amount_per_unit_duration` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `essentials_allowances` text DEFAULT NULL,
  `essentials_deductions` text DEFAULT NULL,
  `purchase_requisition_ids` text DEFAULT NULL,
  `prefer_payment_method` varchar(191) DEFAULT NULL,
  `prefer_payment_account` int(11) DEFAULT NULL,
  `sales_order_ids` text DEFAULT NULL,
  `purchase_order_ids` text DEFAULT NULL,
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `import_batch` int(11) DEFAULT NULL,
  `import_time` datetime DEFAULT NULL,
  `types_of_service_id` int(11) DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') DEFAULT NULL,
  `service_custom_field_1` text DEFAULT NULL,
  `service_custom_field_2` text DEFAULT NULL,
  `service_custom_field_3` text DEFAULT NULL,
  `service_custom_field_4` text DEFAULT NULL,
  `service_custom_field_5` text DEFAULT NULL,
  `service_custom_field_6` text DEFAULT NULL,
  `is_created_from_api` tinyint(1) NOT NULL DEFAULT 0,
  `rp_earned` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `order_addresses` text DEFAULT NULL,
  `is_recurring` tinyint(1) NOT NULL DEFAULT 0,
  `recur_interval` double(22,4) DEFAULT NULL,
  `recur_interval_type` enum('days','months','years') DEFAULT NULL,
  `recur_repetitions` int(11) DEFAULT NULL,
  `recur_stopped_on` datetime DEFAULT NULL,
  `recur_parent_id` int(11) DEFAULT NULL,
  `invoice_token` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `pjt_project_id` int(10) unsigned DEFAULT NULL,
  `pjt_title` varchar(191) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `zatca_status` varchar(191) DEFAULT NULL,
  `gym_package_start_date` date DEFAULT NULL,
  `gym_package_end_date` date DEFAULT NULL,
  `gym_package_id` bigint(20) unsigned DEFAULT NULL,
  `hms_booking_arrival_date_time` datetime DEFAULT NULL,
  `hms_booking_departure_date_time` datetime DEFAULT NULL,
  `hms_coupon_id` int(11) DEFAULT NULL,
  `check_in` datetime DEFAULT NULL,
  `check_out` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transactions_tax_id_foreign` (`tax_id`),
  KEY `transactions_business_id_index` (`business_id`),
  KEY `transactions_type_index` (`type`),
  KEY `transactions_contact_id_index` (`contact_id`),
  KEY `transactions_transaction_date_index` (`transaction_date`),
  KEY `transactions_created_by_index` (`created_by`),
  KEY `transactions_location_id_index` (`location_id`),
  KEY `transactions_expense_for_foreign` (`expense_for`),
  KEY `transactions_expense_category_id_index` (`expense_category_id`),
  KEY `transactions_sub_type_index` (`sub_type`),
  KEY `transactions_return_parent_id_index` (`return_parent_id`),
  KEY `type` (`type`),
  KEY `transactions_status_index` (`status`),
  KEY `transactions_sub_status_index` (`sub_status`),
  KEY `transactions_res_table_id_index` (`res_table_id`),
  KEY `transactions_res_waiter_id_index` (`res_waiter_id`),
  KEY `transactions_res_order_status_index` (`res_order_status`),
  KEY `transactions_payment_status_index` (`payment_status`),
  KEY `transactions_discount_type_index` (`discount_type`),
  KEY `transactions_commission_agent_index` (`commission_agent`),
  KEY `transactions_transfer_parent_id_index` (`transfer_parent_id`),
  KEY `transactions_types_of_service_id_index` (`types_of_service_id`),
  KEY `transactions_packing_charge_type_index` (`packing_charge_type`),
  KEY `transactions_recur_parent_id_index` (`recur_parent_id`),
  KEY `transactions_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `transactions_delivery_date_index` (`delivery_date`),
  KEY `transactions_delivery_person_index` (`delivery_person`),
  KEY `transactions_pjt_project_id_foreign` (`pjt_project_id`),
  KEY `transactions_mfg_parent_production_purchase_id_index` (`mfg_parent_production_purchase_id`),
  KEY `transactions_repair_model_id_index` (`repair_model_id`),
  KEY `transactions_repair_warranty_id_index` (`repair_warranty_id`),
  KEY `transactions_repair_brand_id_index` (`repair_brand_id`),
  KEY `transactions_repair_status_id_index` (`repair_status_id`),
  KEY `transactions_repair_device_id_index` (`repair_device_id`),
  KEY `transactions_repair_job_sheet_id_index` (`repair_job_sheet_id`),
  KEY `transactions_woocommerce_order_id_index` (`woocommerce_order_id`),
  CONSTRAINT `transactions_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_category_id_foreign` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_expense_for_foreign` FOREIGN KEY (`expense_for`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `transactions_pjt_project_id_foreign` FOREIGN KEY (`pjt_project_id`) REFERENCES `pjt_projects` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_repair_job_sheet_id_foreign` FOREIGN KEY (`repair_job_sheet_id`) REFERENCES `repair_job_sheets` (`id`) ON DELETE CASCADE,
  CONSTRAINT `transactions_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
INSERT INTO `transactions` VALUES
(1,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-01 00:43:00',8844.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,8844.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,2,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0.0000,'percentage',0,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-06 19:13:00','2025-04-06 22:59:26'),
(3,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-01 04:29:39',24.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,4848.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,1,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0.0000,'percentage',0,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-06 22:59:39','2025-04-06 22:59:39'),
(84,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 21:59:00',10000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,2500000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,3,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0.0000,'percentage',0,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 21:59:42','2025-04-20 21:59:42'),
(88,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-01 22:16:17',4500.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,45000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,4,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0.0000,'percentage',0,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-20 22:16:17','2025-04-20 22:16:17'),
(98,1,1,0,NULL,NULL,NULL,'sell',NULL,'draft',NULL,0,NULL,NULL,1,NULL,'2025/0001','',NULL,NULL,NULL,'2025-05-02 11:47:00',6500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0.0000,'percentage',0,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-02 06:30:05','2025-05-02 06:30:05'),
(106,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-06 07:48:00',110.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,3300.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,5,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0.0000,'percentage',0,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-06 02:18:14','2025-05-06 02:18:14'),
(109,1,1,0,NULL,NULL,NULL,'opening_stock',NULL,'received',NULL,0,'paid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-08 21:59:00',87000.0000,NULL,0.0000,NULL,0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,174000.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,6,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0.0000,'percentage',0,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-08 16:29:07','2025-05-08 16:29:07'),
(112,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0095','',NULL,NULL,NULL,'2025-05-12 00:53:00',6500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0.0000,'percentage',0,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,325,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'success',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-11 19:23:47','2025-06-25 05:45:42'),
(113,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0096','',NULL,NULL,NULL,'2025-06-25 21:37:00',6500.0000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,6500.0000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0.0000,'percentage',0,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,325,NULL,0,1.0000,'days',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-25 16:07:51','2025-06-25 16:07:51'),
(114,1,1,0,NULL,NULL,NULL,'sell',NULL,'final',NULL,0,'paid',NULL,1,NULL,'0097','',NULL,NULL,NULL,'2025-06-25 21:37:00',108887.5000,NULL,0.0000,'percentage',0.0000,0,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,NULL,0.0000,108887.5000,NULL,NULL,NULL,NULL,NULL,0,0,1.000,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0.0000,'percentage',0,0,0.00,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,5444,NULL,0,7.0000,'days',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-25 16:09:16','2025-06-25 16:09:16');
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `types_of_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `types_of_services` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `location_price_group` text DEFAULT NULL,
  `packing_charge` decimal(22,4) DEFAULT NULL,
  `packing_charge_type` enum('fixed','percent') DEFAULT NULL,
  `enable_custom_fields` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `types_of_services_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `types_of_services` WRITE;
/*!40000 ALTER TABLE `types_of_services` DISABLE KEYS */;
/*!40000 ALTER TABLE `types_of_services` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `units` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `actual_name` varchar(191) NOT NULL,
  `short_name` varchar(191) NOT NULL,
  `allow_decimal` tinyint(1) NOT NULL,
  `base_unit_id` int(11) DEFAULT NULL,
  `base_unit_multiplier` decimal(20,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `units_business_id_foreign` (`business_id`),
  KEY `units_created_by_foreign` (`created_by`),
  KEY `units_base_unit_id_index` (`base_unit_id`),
  CONSTRAINT `units_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `units_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `units` WRITE;
/*!40000 ALTER TABLE `units` DISABLE KEYS */;
INSERT INTO `units` VALUES
(1,1,'Pieces','Pc(s)',0,NULL,NULL,1,NULL,'2025-02-06 19:30:03','2025-02-06 19:30:03'),
(2,2,'Pieces','Pc(s)',0,NULL,NULL,3,NULL,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(3,1,'Unité','U.',1,NULL,NULL,1,NULL,'2025-05-10 18:55:24','2025-05-10 18:55:24'),
(4,3,'Pieces','Pc(s)',0,NULL,NULL,5,NULL,'2025-05-24 04:45:20','2025-05-24 04:45:20'),
(5,4,'Pieces','Pc(s)',0,NULL,NULL,6,NULL,'2025-06-20 07:44:09','2025-06-20 07:44:09');
/*!40000 ALTER TABLE `units` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_contact_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_contact_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `contact_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_contact_access_user_id_index` (`user_id`),
  KEY `user_contact_access_contact_id_index` (`contact_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_contact_access` WRITE;
/*!40000 ALTER TABLE `user_contact_access` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_contact_access` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) NOT NULL DEFAULT 'user',
  `surname` char(10) DEFAULT NULL,
  `first_name` varchar(191) NOT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `username` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `password` varchar(191) DEFAULT NULL,
  `language` char(7) NOT NULL DEFAULT 'en',
  `contact_no` char(15) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `essentials_department_id` int(11) DEFAULT NULL,
  `essentials_designation_id` int(11) DEFAULT NULL,
  `essentials_salary` decimal(22,4) DEFAULT NULL,
  `essentials_pay_period` varchar(191) DEFAULT NULL,
  `essentials_pay_cycle` varchar(191) DEFAULT NULL,
  `available_at` datetime DEFAULT NULL COMMENT 'Service staff avilable at. Calculated from product preparation_time_in_minutes',
  `paused_at` datetime DEFAULT NULL COMMENT 'Service staff available time paused at, Will be nulled on resume.',
  `max_sales_discount_percent` decimal(5,2) DEFAULT NULL,
  `allow_login` tinyint(1) NOT NULL DEFAULT 1,
  `status` enum('active','inactive','terminated') NOT NULL DEFAULT 'active',
  `is_enable_service_staff_pin` tinyint(1) NOT NULL DEFAULT 0,
  `service_staff_pin` text DEFAULT NULL,
  `crm_contact_id` int(10) unsigned DEFAULT NULL,
  `is_cmmsn_agnt` tinyint(1) NOT NULL DEFAULT 0,
  `cmmsn_percent` decimal(4,2) NOT NULL DEFAULT 0.00,
  `selected_contacts` tinyint(1) NOT NULL DEFAULT 0,
  `dob` date DEFAULT NULL,
  `gender` varchar(191) DEFAULT NULL,
  `marital_status` enum('married','unmarried','divorced') DEFAULT NULL,
  `blood_group` char(10) DEFAULT NULL,
  `contact_number` char(20) DEFAULT NULL,
  `alt_number` varchar(191) DEFAULT NULL,
  `family_number` varchar(191) DEFAULT NULL,
  `fb_link` varchar(191) DEFAULT NULL,
  `twitter_link` varchar(191) DEFAULT NULL,
  `social_media_1` varchar(191) DEFAULT NULL,
  `social_media_2` varchar(191) DEFAULT NULL,
  `permanent_address` text DEFAULT NULL,
  `current_address` text DEFAULT NULL,
  `guardian_name` varchar(191) DEFAULT NULL,
  `custom_field_1` varchar(191) DEFAULT NULL,
  `custom_field_2` varchar(191) DEFAULT NULL,
  `custom_field_3` varchar(191) DEFAULT NULL,
  `custom_field_4` varchar(191) DEFAULT NULL,
  `bank_details` longtext DEFAULT NULL,
  `id_proof_name` varchar(191) DEFAULT NULL,
  `id_proof_number` varchar(191) DEFAULT NULL,
  `crm_department` varchar(191) DEFAULT NULL COMMENT 'Contact person''s department',
  `crm_designation` varchar(191) DEFAULT NULL COMMENT 'Contact person''s designation',
  `location_id` int(11) DEFAULT NULL COMMENT 'user primary work location',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_business_id_foreign` (`business_id`),
  KEY `users_user_type_index` (`user_type`),
  KEY `users_essentials_department_id_index` (`essentials_department_id`),
  KEY `users_essentials_designation_id_index` (`essentials_designation_id`),
  KEY `users_crm_contact_id_index` (`crm_contact_id`),
  CONSTRAINT `users_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `users_crm_contact_id_foreign` FOREIGN KEY (`crm_contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES
(1,'user','Mr','Test','Software','admin','support@eurosolutions.in','$2y$10$X/iAFFndOxpFs/90qsvGVemnoB7Yrp4QmcO8.haWX1LlZ23EzUzbi','en',NULL,NULL,'nTM49rQR6Y7HbDJ39ZWV7onmtaBckv5Plt1VUw44lDpjPu1ZYAhtbof4KpaJ',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,'1980-09-22','male','unmarried','AB+','9681776928','033 4003 4504',NULL,NULL,NULL,NULL,NULL,'9, Ganesh Chandra Avenue, Kolkata 700013','9, Ganesh Chandra Avenue, Kolkata 700013',NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":\"EURO INFOTECH\",\"account_number\":\"777705267786\",\"bank_name\":\"iCICI BANK LTD\",\"bank_code\":\"ICIC0000006\",\"branch\":\"R N MUKHERJEE\",\"tax_payer_id\":\"EURO INFOTECH\"}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-06 19:30:02','2025-06-28 07:55:11'),
(2,'user',NULL,'ganesh','bhosale',NULL,'kaij@ssmobile.com',NULL,'en','7020106607','Kaij',NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'active',0,NULL,NULL,1,10.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-07 16:42:32','2025-02-07 16:42:32'),
(3,'user','MR','ganesh','bhosale','ganesh','bp660104494@gmail.com','$2y$10$fwtJ.z39kvg0teUjD9VQ0eXTnWKm8XsQYKD8BTbSzRz/xEETRsnd2','en',NULL,NULL,NULL,2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-08 16:46:58','2025-02-08 16:46:58'),
(4,'user_customer','M','Samy','Hadj','admin2','sa@gmail.com','$2y$10$05k/.GA4/vHMC0tPDhihYeMRya59vYM.Jn8Yc1W4wtzPBPI/8wE0q','en',NULL,NULL,'NBz9TmAxdp8L7jseunyN3vRZPesTDOwMM2SqKH5aOsojWgHQfnBZhfUK4Z8E',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,2,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-06 21:43:29','2025-04-06 21:43:29'),
(5,'user',NULL,'Aaa','Hshs','Denngans','dennysyahputra2900@gmail.com','$2y$10$YBDTruLw.msq3FveucvvgeRN4pEO4Gr.hhKSDf7KmpY8rHoDwcqmG','en',NULL,NULL,NULL,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"account_holder_name\":null,\"account_number\":null,\"bank_name\":null,\"bank_code\":null,\"branch\":null,\"tax_payer_id\":null}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-24 04:45:20','2025-05-24 05:21:05'),
(6,'user',NULL,'test','test','test','test@test.com','$2y$10$n8pQbZEEI7I.cb572FHd6eBUgqGUpMbbtsXfSw8KsJamRveulaUDe','en',NULL,NULL,NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'active',0,NULL,NULL,0,0.00,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-06-20 07:44:09','2025-06-20 07:44:09');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_group_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `variation_group_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_id` int(10) unsigned NOT NULL,
  `price_group_id` int(10) unsigned NOT NULL,
  `price_inc_tax` decimal(22,4) NOT NULL,
  `price_type` varchar(191) NOT NULL DEFAULT 'fixed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_group_prices_variation_id_foreign` (`variation_id`),
  KEY `variation_group_prices_price_group_id_foreign` (`price_group_id`),
  CONSTRAINT `variation_group_prices_price_group_id_foreign` FOREIGN KEY (`price_group_id`) REFERENCES `selling_price_groups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variation_group_prices_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_group_prices` WRITE;
/*!40000 ALTER TABLE `variation_group_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_group_prices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_location_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `variation_location_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(10) unsigned NOT NULL,
  `product_variation_id` int(10) unsigned NOT NULL COMMENT 'id from product_variations table',
  `variation_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `qty_available` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_location_details_location_id_foreign` (`location_id`),
  KEY `variation_location_details_product_id_index` (`product_id`),
  KEY `variation_location_details_product_variation_id_index` (`product_variation_id`),
  KEY `variation_location_details_variation_id_index` (`variation_id`),
  CONSTRAINT `variation_location_details_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `business_locations` (`id`),
  CONSTRAINT `variation_location_details_variation_id_foreign` FOREIGN KEY (`variation_id`) REFERENCES `variations` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_location_details` WRITE;
/*!40000 ALTER TABLE `variation_location_details` DISABLE KEYS */;
INSERT INTO `variation_location_details` VALUES
(4,4,4,4,1,8.0000,'2025-04-20 22:16:17','2025-06-25 16:07:51'),
(5,5,5,5,1,29.0000,'2025-05-06 02:18:14','2025-06-25 16:09:16'),
(6,6,6,6,1,1.0000,'2025-05-08 16:29:07','2025-06-25 16:09:16');
/*!40000 ALTER TABLE `variation_location_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `variation_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `woocommerce_attr_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_templates_business_id_foreign` (`business_id`),
  KEY `variation_templates_woocommerce_attr_id_index` (`woocommerce_attr_id`),
  CONSTRAINT `variation_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_templates` WRITE;
/*!40000 ALTER TABLE `variation_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variation_value_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `variation_value_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `variation_template_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `variation_value_templates_name_index` (`name`),
  KEY `variation_value_templates_variation_template_id_index` (`variation_template_id`),
  CONSTRAINT `variation_value_templates_variation_template_id_foreign` FOREIGN KEY (`variation_template_id`) REFERENCES `variation_templates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variation_value_templates` WRITE;
/*!40000 ALTER TABLE `variation_value_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `variation_value_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `sub_sku` varchar(191) DEFAULT NULL,
  `product_variation_id` int(10) unsigned NOT NULL,
  `woocommerce_variation_id` int(11) DEFAULT NULL,
  `variation_value_id` int(11) DEFAULT NULL,
  `default_purchase_price` decimal(22,4) DEFAULT NULL,
  `dpp_inc_tax` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `profit_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `default_sell_price` decimal(22,4) DEFAULT NULL,
  `sell_price_inc_tax` decimal(22,4) DEFAULT NULL COMMENT 'Sell price including tax',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `combo_variations` text DEFAULT NULL COMMENT 'Contains the combo variation details',
  PRIMARY KEY (`id`),
  KEY `variations_product_id_foreign` (`product_id`),
  KEY `variations_product_variation_id_foreign` (`product_variation_id`),
  KEY `variations_name_index` (`name`),
  KEY `variations_sub_sku_index` (`sub_sku`),
  KEY `variations_variation_value_id_index` (`variation_value_id`),
  KEY `variations_woocommerce_variation_id_index` (`woocommerce_variation_id`),
  CONSTRAINT `variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `variations_product_variation_id_foreign` FOREIGN KEY (`product_variation_id`) REFERENCES `product_variations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `variations` WRITE;
/*!40000 ALTER TABLE `variations` DISABLE KEYS */;
INSERT INTO `variations` VALUES
(4,'DUMMY',4,'0004',4,NULL,NULL,4500.0000,4500.0000,44.4400,6500.0000,6500.0000,'2025-04-20 22:15:53','2025-04-26 17:12:23',NULL,'[]'),
(5,'DUMMY',5,'0005',5,NULL,NULL,110.0000,110.0000,25.0000,137.5000,137.5000,'2025-05-06 02:17:59','2025-05-06 02:17:59',NULL,'[]'),
(6,'DUMMY',6,'0006',6,NULL,NULL,87000.0000,87000.0000,25.0000,108750.0000,108750.0000,'2025-05-08 16:28:56','2025-05-08 16:28:56',NULL,'[]');
/*!40000 ALTER TABLE `variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `warranties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `warranties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `duration` int(11) NOT NULL,
  `duration_type` enum('days','months','years') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warranties_business_id_index` (`business_id`),
  KEY `warranties_duration_type_index` (`duration_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `warranties` WRITE;
/*!40000 ALTER TABLE `warranties` DISABLE KEYS */;
/*!40000 ALTER TABLE `warranties` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `woocommerce_sync_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `woocommerce_sync_logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `sync_type` varchar(191) NOT NULL,
  `operation_type` varchar(191) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  `details` longtext DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `woocommerce_sync_logs` WRITE;
/*!40000 ALTER TABLE `woocommerce_sync_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `woocommerce_sync_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `zatca_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `zatca_documents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `icv` varchar(191) NOT NULL,
  `uuid` char(36) NOT NULL,
  `hash` varchar(191) DEFAULT NULL,
  `xml` longtext DEFAULT NULL,
  `sent_to_zatca` tinyint(1) DEFAULT NULL,
  `sent_to_zatca_status` varchar(191) DEFAULT NULL,
  `signing_time` datetime DEFAULT NULL,
  `response` longtext DEFAULT NULL,
  `type` varchar(191) DEFAULT NULL,
  `portal_mode` varchar(191) DEFAULT NULL,
  `transaction_id` bigint(20) unsigned NOT NULL,
  `location_id` bigint(20) unsigned NOT NULL,
  `business_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `zatca_documents_uuid_unique` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `zatca_documents` WRITE;
/*!40000 ALTER TABLE `zatca_documents` DISABLE KEYS */;
INSERT INTO `zatca_documents` VALUES
(1,'1','9f3cb20f-0cd0-4706-9fce-439be1fa1ab7','85hR2KTTA8KDcy7Nj69Kc7aJ+c3fR/L3CI4PjJNA0ns=','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',1,'success','2025-06-25 11:15:41','{\"success\":true,\"response\":{\"validationResults\":{\"infoMessages\":[{\"type\":\"INFO\",\"code\":\"XSD_ZATCA_VALID\",\"category\":\"XSD validation\",\"message\":\"Complied with UBL 2.1 standards in line with ZATCA specifications\",\"status\":\"PASS\"}],\"warningMessages\":[{\"type\":\"WARNING\",\"code\":\"BR-CL-14\",\"category\":\"EN_16931\",\"message\":\"Country codes in an invoice MUST be coded using ISO code list 3166-1\",\"status\":\"WARNING\"},{\"type\":\"WARNING\",\"code\":\"BR-KSA-98\",\"category\":\"KSA\",\"message\":\"[BR-KSA-98] - The simplified invoice should be submitted within 24 hours of issuing the invoice.\",\"status\":\"WARNING\"},{\"type\":\"WARNING\",\"code\":\"BR-KSA-37\",\"category\":\"KSA\",\"message\":\"The seller address building number must contain 4 digits.\",\"status\":\"WARNING\"},{\"type\":\"WARNING\",\"code\":\"BR-KSA-69\",\"category\":\"KSA\",\"message\":\"[BR-KSA-69]-A VAT breakdown (BG-23) with VAT Category code (BT-118) \'Zero rated\' shall have a VAT exception reason code (BT-121).\",\"status\":\"WARNING\"}],\"errorMessages\":[],\"status\":\"WARNING\"},\"reportingStatus\":\"REPORTED\",\"clearanceStatus\":null,\"qrSellertStatus\":null,\"qrBuyertStatus\":null},\"hash\":\"85hR2KTTA8KDcy7Nj69Kc7aJ+c3fR\\/L3CI4PjJNA0ns=\",\"xml\":\"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\",\"signing_time\":\"2025-06-25T11:15:41Z\",\"qr_value\":\"AQlUU1RDTyBWQVQCDzMwMDAwMDAwMDAwMDAwMwMTMjAyNS0wNS0xMlQwMDo1MzowMAQHNjUwMC4wMAUEMC4wMAYsODVoUjJLVFRBOEtEY3k3Tmo2OUtjN2FKK2MzZlIvTDNDSTRQakpOQTBucz0HYE1FVUNJUUNiREVhWHhmQ2I5Z0FlMW5uOE1BeVFoU3NXTW15SGU3TDZNZk1KNysyVm1BSWdYVWtKVTlaNmFsS2FtdkxLU21oMU5Ycm03ckRmYm9IOS9sOXNRMFBBdjR3PQhYMFYwEAYHKoZIzj0CAQYFK4EEAAoDQgAEg1LNDyZJDbA\\/XA0RVYX2q9VhIiOxeKz2tTtVUttaTfA0HMOeRh4m+SqJ6ja4\\/sQ+WQCo6aZ9OpGp9Cw\\/d7iSZQlIMEYCIQCNGLwQ7NCcWQWml88uXB8erPfsqZ4H+ga4N1EvNofErwIhAPtRn84hb8u+PRoic8JChv0NhwNwW4BL20POVXT59UdF\"}','sale','developer-portal',112,1,1,'2025-06-25 05:45:42','2025-06-25 05:45:42');
/*!40000 ALTER TABLE `zatca_documents` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

