<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="UTF-8">
    <title> <?php echo $receipt_details->invoice_no; ?></title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 10pt;
        }

        .invoice-box {
            width: 100%;
            margin: auto;
            border-collapse: collapse;
        }

        .rtl {
            direction: rtl;
            text-align: right;
        }

        .ltr {
            direction: ltr;
            text-align: left;
        }

        .center {
            text-align: center;
        }

        table {
            width: 100%;
            margin-bottom: 10px;
        }

        td,
        th {
            padding: 6px;
            vertical-align: top;
        }

        .header td {
            font-weight: bold;
        }

        .gray-bg {
            background-color: #f2f2f2;
        }

        .border {
            border: 1px solid #ccc;
        }

        .border th {
            border: 1px solid #ccc;
        }

        /* Custom CSS for MPDF */
        .table {
            width: 100%;
            margin-bottom: 10px;
            border-collapse: collapse;
        }

        .table-bordered {
            border: 1px solid #ccc;
        }

        .table-bordered th,
        .table-bordered td {
            border: 1px solid #ccc;
        }

    
    </style>

</head>

<body>
    <htmlpagefooter name="page-footer">
        <div style="text-align: center; font-size: 9pt;">
            Page {PAGENO} of {nbpg}
        </div>
    </htmlpagefooter>
    <sethtmlpagefooter name="page-footer" value="on" />
    <table class="table">
        <tr>
            <td class="ltr" width="33.3%">
                <div class="width-50 f-left" align="center" style="color: #22489B;padding-top: 5px;">
                    <strong style="font-size: 20px;">
                        <?php echo $receipt_details->display_name; ?>

                    </strong>
                    <div style="font-size: 14px;" align="center">
                        <?php echo $receipt_details->address; ?>

                        <?php if(!empty($location_details->mobile) || !empty($location_details->alternate_number)): ?>
                            <br>
                            <?php echo app('translator')->get('lang_v1.contact_no'); ?> :
                            <?php echo e(!empty($location_details->mobile) ? $location_details->mobile . ', ' : '', false); ?>

                            <?php echo e($location_details->alternate_number, false); ?>

                        <?php endif; ?>
                        <?php if(!empty($location_details->website)): ?>
                            <br>
                            <?php echo app('translator')->get('lang_v1.website'); ?>:
                            <a href="<?php echo $location_details->website; ?>" target="_blank" style="text-decoration: none;">
                                <?php echo $location_details->website; ?>

                            </a>
                        <?php endif; ?>
                        <?php if(!empty($location_details->email)): ?>
                            <?php echo app('translator')->get('business.email'); ?>: <?php echo $location_details->email; ?>

                        <?php endif; ?>
                        

                        <?php if(!empty($receipt_details->location_custom_field_2_label) && !empty($receipt_details->location_custom_field_2_value)): ?>
                            <br>
                            <?php echo e($receipt_details->location_custom_field_2_label, false); ?> : <?php echo $receipt_details->location_custom_field_2_value; ?>

                        <?php endif; ?>

                        <?php if(!empty($receipt_details->location_custom_field_3_label) && !empty($receipt_details->location_custom_field_3_value)): ?>
                            <br>
                            <?php echo e($receipt_details->location_custom_field_3_label, false); ?> : <?php echo $receipt_details->location_custom_field_3_value; ?>

                        <?php endif; ?>

                        <?php if(!empty($receipt_details->location_custom_field_4_label) && !empty($receipt_details->location_custom_field_4_value)): ?>
                            <br>
                            <?php echo e($receipt_details->location_custom_field_4_label, false); ?> : <?php echo $receipt_details->location_custom_field_4_value; ?>

                        <?php endif; ?>
                    </div>
                </div>
            </td>
            <td class="center" width="33.3%">
                <?php if(!empty($receipt_details->logo)): ?>
                    <div style="display: flex; justify-content: center;">
                        <img src="<?php echo e($receipt_details->logo, false); ?>" alt="Logo" style="width: 100px; height: 100px;">
                    </div>
                <?php endif; ?>
            </td>
            <td class="center" width="33.3%">
                <?php if(!empty($zatca_qr_code)): ?>
                    <img
                        src="data:image/png;base64,<?php echo e(DNS2D::getBarcodePNG($zatca_qr_code, 'QRCODE',2.0,2.0, [0,0,0]), false); ?>">
                <?php endif; ?>
            </td>
        </tr>
    </table>

    <h3 class="center">Tax Invoice / فاتورة ضريبية</h3>

    <table class="table table-bordered">
        <tr class="gray-bg">
            <td><strong>Invoice Number<br>رقم الفاتورة</strong></td>
            <td>
                <?php if(!empty($receipt_details->invoice_no)): ?>
                    <?php echo $receipt_details->invoice_no; ?>

                <?php endif; ?>
            </td>
            <td><strong>Invoice Date<br>تاريخ الفاتورة</strong></td>
            <td><?php echo $receipt_details->invoice_date; ?></td>
            <td><strong>Invoice Due Date<br>تاريخ استحقاق الفاتورة</strong></td>
        <td> <?php echo e(\Carbon::createFromTimestamp(strtotime($transaction->due_date))->format(session('business.date_format')), false); ?></td>
        <td><strong>Payment Terms<br>شروط الدفع</strong></td>
        <td>
            <?php if(!empty($transaction->pay_term_number) && !empty($transaction->pay_term_type)): ?>
                <?php echo e(ucfirst($transaction->pay_term_number), false); ?> <?php echo e(ucfirst($transaction->pay_term_type), false); ?>

            <?php else: ?>
                N/A
            <?php endif; ?>
        </td> 
        </tr>
    </table>

    <table class="table table-bordered">
        <tr class="gray-bg">
            <td width="50%"><strong>Seller / البائع</strong></td>
            <td width="50%"><strong>Buyer / المشتري</strong></td>
        </tr>
        <tr>

            <?php
                $zatca = json_decode($location_details->zatca_details);
            ?>

            <td class="border">
                <address>
                    <?php echo e($zatca->organization_name ?? '', false); ?><br>
                    <?php echo e($zatca->street_name ?? '', false); ?>, <?php echo e($zatca->building_number ?? '', false); ?>,
                    <?php echo e($zatca->plot_identification ?? '', false); ?><br>
                    <?php echo e($zatca->sub_division_name ?? '', false); ?>, <?php echo e($zatca->city_name ?? '', false); ?>,
                    <?php echo e($zatca->postal_number ?? '', false); ?><br>
                    <?php echo e($zatca->country_name ?? '', false); ?> <br>
                    <?php echo e(json_decode($location_details->zatca_details)->vat_number ?? '', false); ?>

                </address>
            </td>
            <td class="border">
                
                <?php echo ltrim($receipt_details->customer_info_address, '<br>'); ?>

                <?php if(!empty($receipt_details->customer_custom_fields)): ?>
                    <?php echo $receipt_details->customer_custom_fields; ?>

                <?php endif; ?>
            </td>
        </tr>
    </table>

    <table class="table table-bordered">
        <tr class="gray-bg">
            <th>Seq<br>ترتيب</th>
            <th>Description<br>البيان</th>
            <th>Quantity<br>الكمية</th>
            <th>Unit Price<br>سعر الوحدة</th>
            <th>Disc<br>نسبة الخصم</th>
            <th>Taxes<br>الضريبة</th>
            <th>Tax Amount<br>مقدار الضريبة</th>
            
            <th>Total Price<br>السعر الكلي</th>
        </tr>
        <?php
            $subtotal = 0;
            $is_empty_row_looped = true;
            $total_discount = 0;
            $total_tax = 0;
        ?>
        <?php $__currentLoopData = $receipt_details->lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <?php echo e($loop->iteration, false); ?>

                </td>
                <td>
                    <?php echo $line['name']; ?>

                    <br>
                    <?php echo $line['sub_sku'] ?? ''; ?>

                </td>
                <td>
                    <?php echo $line['quantity'] ?? ''; ?> (<?php echo e($line['units'] ?? '', false); ?>)
                </td>

                <td>
                    <?php
                        $subtotal += ($line['unit_price_before_discount_uf'] ?? 0) * ($line['quantity_uf'] ?? 0);
                    ?>
                    <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $line['unit_price_before_discount_uf'] ?? 0, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?>
                </td>
                 <td>
                    <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $transactionUtil->get_sell_line_discount_amount($line['line_discount_type_uf'], $line['line_discount_amount_uf'], $line['unit_price_before_discount_uf']) * $line['quantity_uf'] ?? 0, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?>
                </td>
                <td>
                    <?php echo e($line['tax_percent'] ?? '', false); ?>%
                </td>
                <td>
                    <?php
                        $discountAmount = $transactionUtil->get_sell_line_discount_amount($line['line_discount_type_uf'], $line['line_discount_amount_uf'], $line['unit_price_before_discount_uf']);
                        $total_discount += round($discountAmount * ($line['quantity_uf'] ?? 0), 2);
                        $total_tax += (float) ($line['tax'] ?? 0) * (float) ($line['quantity_uf'] ?? 0);
                    ?>
                    <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $line['tax'] ?? 0, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?>
                </td>
                <td>
                    <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $line['line_total_uf'] ?? 0, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tr>
    </table>
    <div style="width: 50%; float: right;">
        <table class="table table-bordered">
            <tr>
                <td>Subtotal / المجموع الفرعي</td>
                <td><?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $subtotal, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?></td>
            </tr>
            <tr>
                <td>Total Discount / إجمالي الخصم</td>
                <td><?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $total_discount, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?></td>
            </tr>
            <tr>
                <td>Net Amount / المبلغ الصافي</td>
                <td><?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $receipt_details->total_unformatted - $total_tax, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?></td>
            </tr>
            <tr>
                <td>Total Tax / إجمالي الضريبة</td>
                <td><?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $total_tax, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?></td>
            </tr>
            <tr>
                <td>Total Amount / المبلغ الإجمالي</td>
                <td><?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $receipt_details->total_unformatted, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?></td>
            </tr>
        <tr>
            <td>Due Amount / المبلغ المستحق</td>
            <td><?php echo $receipt_details->total_due; ?></td>
        </tr>
        </table>
        <p><strong>Invoiced Amount:</strong> <?php echo $transactionUtil->numToWord($receipt_details->total_unformatted, 'en'); ?></p>
        <p><strong>مبلغ الفاتورة:</strong><?php echo $transactionUtil->numToWord($receipt_details->total_unformatted, 'ar'); ?></p>
    </div>
</body>

</html>
<?php /**PATH /home/gyannewsoftware/public_html/pos11_UltimatePOS65/Modules/ZatcaIntegrationKsa/Resources/views/sale/pdf.blade.php ENDPATH**/ ?>