
<?php $__env->startSection('title', __('gym::lang.gym')); ?>
<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('gym::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section class="content no-print">
        <div class="row">
            <div class="col-md-4">
                <?php $__env->startComponent('components.widget'); ?>
                    <table class="table no-margin">
                        <tr>
                            <th><?php echo app('translator')->get('gym::lang.total_member'); ?></th>
                            <td><?php echo e($total_members ?? 0, false); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->get('gym::lang.active_member'); ?></th>
                            <td><?php echo e($active_members ?? 0, false); ?></td>
                        </tr>
                        <tr>
                            <th><?php echo app('translator')->get('gym::lang.new_member_this_month'); ?></th>
                            <td><?php echo e($registered_this_month ?? 0, false); ?></td>
                        </tr>
                    </table>
                <?php echo $__env->renderComponent(); ?>
            </div>
            <div class="col-md-4">
                <?php $__env->startComponent('components.widget'); ?>
                    <div class="nav-tabs-custom">
                        <h3 class="box-title"><?php echo app('translator')->get('gym::lang.today_attendance_summary'); ?></h3>
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#cn_1" data-toggle="tab" aria-expanded="true">
                                    <?php echo app('translator')->get('gym::lang.inside_gym'); ?>
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="cn_1">
                                <?php $__empty_1 = true; $__currentLoopData = $today_attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="attendance-item">
                                        <strong><?php echo app('translator')->get('contact.name'); ?>:</strong> <?php echo e($attendance->contact_name, false); ?> <br>
                                        <strong><?php echo app('translator')->get('contact.mobile'); ?>:</strong> <?php echo e($attendance->contact_mobile, false); ?> <br>
                                        <strong><?php echo app('translator')->get('gym::lang.in_time'); ?>:</strong>
                                        <?php echo e(\Carbon::createFromTimestamp(strtotime($attendance->in_time))->format('H:i'), false); ?>

                                        <?php
                                            $inTime = \Carbon\Carbon::parse($attendance->date . ' ' . $attendance->in_time);
                                            $diff = $inTime->diff(\Carbon\Carbon::now());
                                            $value = $diff->h > 0 ? $diff->h : $diff->i;
                                            $unit = $diff->h > 0 ? __('gym::lang.hours_ago') : __('gym::lang.minutes_ago');
                                        ?>
                                        <span class="label bg-info"> <?php echo e($value, false); ?>  <?php echo e($unit, false); ?></span>
                                        <hr>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <?php echo app('translator')->get('gym::lang.no_one_in_side'); ?>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>
                <?php echo $__env->renderComponent(); ?>
            </div>
            <div class="col-md-4">
                <?php $__env->startComponent('components.widget'); ?>
                    <div class="nav-tabs-custom">
                        <h3 class="box-title"><?php echo app('translator')->get('gym::lang.subscription_summary'); ?></h3>
                        <ul class="nav nav-tabs">
                            <li class="active">
                                <a href="#cn_1" data-toggle="tab" aria-expanded="true">
                                    <?php echo app('translator')->get('gym::lang.expiring_soon'); ?>
                                </a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="cn_1">
                                <?php $__empty_1 = true; $__currentLoopData = $expiring_soon; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="attendance-item">
                                        <strong><?php echo app('translator')->get('contact.name'); ?>:</strong> <?php echo e($value->contact_name, false); ?> <br>
                                        <strong><?php echo app('translator')->get('contact.mobile'); ?>:</strong> <?php echo e($value->contact_mobile, false); ?> <br>
                                        <strong><?php echo app('translator')->get('gym::lang.end_date'); ?>:</strong>
                                        <?php echo e(\Carbon::createFromTimestamp(strtotime($value->gym_package_end_date))->format(session('business.date_format')), false); ?>

                                        <?php
                                            $daysLeft = \Carbon\Carbon::parse($value->gym_package_end_date)->diffInDays(\Carbon\Carbon::now());
                                        ?>
                                        <span class="label bg-info"> <?php echo app('translator')->get('gym::lang.in'); ?> <?php echo e($daysLeft, false); ?> <?php echo app('translator')->get('gym::lang.days'); ?></span>
                                        <br>
                                        <strong><?php echo app('translator')->get('gym::lang.package'); ?>:</strong> <?php echo e($value->package_name, false); ?> <br>
                                        <hr>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <?php echo app('translator')->get('gym::lang.no_records_found'); ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php echo $__env->renderComponent(); ?>
            </div>
        </div>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gyannewsoftware/public_html/pos11_UltimatePOS65/Modules/Gym/Resources/views/dashboard/index.blade.php ENDPATH**/ ?>