
<?php $__env->startSection('title', __('superadmin::lang.superadmin') . ' | Coupons'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('superadmin::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"> <?php echo app('translator')->get('superadmin::lang.all_coupon'); ?>
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
    <div
        class="tw-transition-all lg:tw-col-span-1 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md hover:tw-translate-y-0.5 tw-ring-gray-200">
        <div class="tw-p-4 sm:tw-p-5">
            <div class="tw-flex tw-justify-end tw-gap-2.5">
                <a class="tw-dw-btn tw-bg-gradient-to-r tw-from-indigo-600 tw-to-blue-500 tw-font-bold tw-text-white tw-border-none tw-rounded-full pull-right"
                    href="<?php echo e(action([\Modules\Superadmin\Http\Controllers\CouponController::class, 'create']), false); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                        stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                        class="icon icon-tabler icons-tabler-outline icon-tabler-plus">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <path d="M12 5l0 14" />
                        <path d="M5 12l14 0" />
                    </svg> <?php echo app('translator')->get('messages.add'); ?>
                </a>
                
            </div>
            <div class="tw-flow-root tw-mt-5 tw-border-b tw-border-gray-200">
                <div class="tw-mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                    <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('superadmin')): ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="superadmin_Coupons_table">
                                    <thead>
                                        <tr>
                                            <th>
                                                <?php echo app('translator')->get('superadmin::lang.coupon_code'); ?>
                                            </th>
                                            <th>
                                                <?php echo app('translator')->get('superadmin::lang.discount_type'); ?>
                                            </th>
                                            <th>
                                                <?php echo app('translator')->get('superadmin::lang.discount'); ?>
                                            </th>
                                            <th>
                                                <?php echo app('translator')->get('superadmin::lang.expiry_date'); ?>
                                            </th>
                                            <th>
                                                <?php echo app('translator')->get('superadmin::lang.applied_on_packages'); ?>
                                            </th>
                                            <th>
                                                <?php echo app('translator')->get('superadmin::lang.applied_on_business'); ?>
                                            </th>
                                            <th>
                                                <?php echo app('translator')->get('superadmin::lang.status'); ?>
                                            </th>
                                            <th>
                                                <?php echo app('translator')->get('superadmin::lang.created_at'); ?>
                                            </th>
                                            <th>
                                                <?php echo app('translator')->get('superadmin::lang.action'); ?>
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </section>

    <!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>

    <script type="text/javascript">
        $(document).ready(function() {
            superadmin_business_table = $('#superadmin_Coupons_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "<?php echo e(action([\Modules\Superadmin\Http\Controllers\CouponController::class, 'index']), false); ?>",
                },
                aaSorting: [
                    [6, 'desc']
                ],
                columns: [{
                        data: 'coupon_code',
                        name: 'coupons.coupon_code'
                    },
                    {
                        data: 'discount_type',
                        name: 'coupons.discount_type'
                    },
                    {
                        data: 'discount',
                        name: 'coupons.discount'
                    },
                    {
                        data: 'expiry_date',
                        name: 'coupons.expiry_date'
                    },
                    {
                        data: 'applied_on_packages',
                        name: 'coupons.applied_on_packages'
                    },
                    {
                        data: 'applied_on_business',
                        name: 'coupons.applied_on_business'
                    },
                    {
                        data: 'is_active',
                        name: 'coupons.is_active'
                    },
                    {
                        data: 'created_at',
                        name: 'coupons.created_at'
                    },
                    {
                        data: 'action',
                        name: 'coupons.action'
                    },
                ]
            });

            $(document).on('click', 'a.delete_coupon_confirmation', function(e) {
                e.preventDefault();
                swal({
                    title: LANG.sure,
                    text: "Once deleted, you will not be able to recover this Coupon !",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                }).then((confirmed) => {
                    if (confirmed) {
                        window.location.href = $(this).attr('href');
                    }
                });
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gyannewsoftware/public_html/pos11_UltimatePOS65/Modules/Superadmin/Providers/../Resources/views/coupons/index.blade.php ENDPATH**/ ?>