
<?php $__env->startSection('title', __('superadmin::lang.superadmin') . ' | Business'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('superadmin::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo app('translator')->get('superadmin::lang.view_business'); ?>
            <small class="tw-text-sm md:tw-text-base tw-text-gray-700 tw-font-semibold"> <?php echo e($business->name, false); ?> </small>
        </h1>
        <!-- <ol class="breadcrumb">
                                    <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
                                    <li class="active">Here</li>
                                </ol> -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div
            class=" tw-transition-all lg:tw-col-span-1 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md  tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-gap-2.5">
                    <strong><i class="fa fa-briefcase margin-r-5"></i>
                        <?php echo e($business->name, false); ?></strong>
                </div>
                <div class="tw-flow-root tw-mt-5 tw-border-b tw-border-gray-200">
                    <div class="tw-mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <div class="col-sm-3">
                                <div class="well well-sm">
                                    <strong><i class="fa fa-briefcase margin-r-5"></i>
                                        <?php echo app('translator')->get('business.business_name'); ?></strong>
                                    <p class="text-muted">
                                        <?php echo e($business->name, false); ?>

                                    </p>

                                    <strong><i class="fa fa-money margin-r-5"></i>
                                        <?php echo app('translator')->get('business.currency'); ?></strong>
                                    <p class="text-muted">
                                        <?php echo e($business->currency->currency, false); ?>

                                    </p>

                                    <strong><i class="fa fa-file-text-o margin-r-5"></i>
                                        <?php echo app('translator')->get('business.tax_number1'); ?></strong>
                                    <p class="text-muted">
                                        <?php if(!empty($business->tax_number_1)): ?>
                                            <?php echo e($business->tax_label_1, false); ?>: <?php echo e($business->tax_number_1, false); ?>

                                        <?php endif; ?>
                                    </p>

                                    <strong><i class="fa fa-file-text-o margin-r-5"></i>
                                        <?php echo app('translator')->get('business.tax_number2'); ?></strong>
                                    <p class="text-muted">
                                        <?php if(!empty($business->tax_number_2)): ?>
                                            <?php echo e($business->tax_label_2, false); ?>: <?php echo e($business->tax_number_2, false); ?>

                                        <?php endif; ?>
                                    </p>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="well well-sm">
                                    <strong><i class="fa fa-location-arrow margin-r-5"></i>
                                        <?php echo app('translator')->get('business.time_zone'); ?></strong>
                                    <p class="text-muted">
                                        <?php echo e($business->time_zone, false); ?>

                                    </p>

                                    <strong><i class="fa fa-toggle-on margin-r-5"></i>
                                        <?php echo app('translator')->get('business.is_active'); ?></strong>
                                    <?php if($business->is_active == 0): ?>
                                        <p class="text-muted">
                                            Inactive
                                        </p>
                                    <?php else: ?>
                                        <p class="text-muted">
                                            Active
                                        </p>
                                    <?php endif; ?>

                                    <strong><i class="fa fa-user-circle-o margin-r-5"></i>
                                        <?php echo app('translator')->get('business.created_by'); ?></strong>
                                    <?php if(!empty($created_by)): ?>
                                        <p class="text-muted">
                                            <?php echo e($created_by->surname, false); ?> <?php echo e($created_by->first_name, false); ?>

                                            <?php echo e($created_by->last_name, false); ?>

                                        </p>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div class="well well-sm">
                                    <strong><i class="fa fa-user-circle-o margin-r-5"></i>
                                        <?php echo app('translator')->get('business.owner'); ?></strong>
                                    <?php if(!empty($business->owner)): ?>
                                        <p class="text-muted">
                                            <?php echo e($business->owner->surname, false); ?> <?php echo e($business->owner->first_name, false); ?>

                                            <?php echo e($business->owner->last_name, false); ?>

                                        </p>
                                    <?php endif; ?>

                                    <strong><i class="fa fa-envelope margin-r-5"></i>
                                        <?php echo app('translator')->get('business.email'); ?></strong>
                                    <p class="text-muted">
                                        <?php echo e($business->owner->email, false); ?>

                                    </p>

                                    <strong><i class="fa fa-address-book-o margin-r-5"></i>
                                        <?php echo app('translator')->get('business.mobile'); ?></strong>
                                    <p class="text-muted">
                                        <?php echo e($business->owner->contact_no, false); ?>

                                    </p>

                                    <strong><i class="fa fa-map-marker margin-r-5"></i>
                                        <?php echo app('translator')->get('business.address'); ?></strong>
                                    <p class="text-muted">
                                        <?php echo e($business->owner->address, false); ?>

                                    </p>
                                </div>
                            </div>

                            <div class="col-sm-3">
                                <div>
                                    <?php if(!empty($business->logo)): ?>
                                        <img class="img-responsive"
                                            src="<?php echo e(url('uploads/business_logos/' . $business->logo), false); ?>"
                                            alt="Business Logo">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div
            class="tw-mt-5 tw-transition-all  lg:tw-col-span-1 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md  tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-gap-2.5">
                    <strong><i class="fa fa-map-marker margin-r-5"></i>
                        <?php echo app('translator')->get('superadmin::lang.business_location'); ?></strong>
                </div>
                <div class="tw-flow-root tw-mt-5 tw-border-b tw-border-gray-200">
                    <div class="tw-mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('lang_v1.name'); ?></th>
                                        <th><?php echo app('translator')->get('lang_v1.location_id'); ?></th> 
                                        <th><?php echo app('translator')->get('business.landmark'); ?></th>
                                        <th><?php echo app('translator')->get('business.city'); ?></th>
                                        <th><?php echo app('translator')->get('business.zip_code'); ?></th>
                                        <th><?php echo app('translator')->get('business.state'); ?></th>
                                        <th><?php echo app('translator')->get('business.country'); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php $__currentLoopData = $business->locations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($location->name, false); ?></td>
                                            <td><?php echo e($location->location_id, false); ?></td>
                                            <td><?php echo e($location->landmark, false); ?></td>
                                            <td><?php echo e($location->city, false); ?></td>
                                            <td><?php echo e($location->zip_code, false); ?></td>
                                            <td><?php echo e($location->state, false); ?></td>
                                            <td><?php echo e($location->country, false); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div
            class="tw-mt-5 tw-transition-all  lg:tw-col-span-1 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md  tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-gap-2.5">
                    <strong><i class="fa fa-refresh margin-r-5"></i>
                        <?php echo app('translator')->get('superadmin::lang.package_subscription'); ?></strong>
                </div>
                <div class="tw-flow-root tw-mt-5 tw-border-b tw-border-gray-200">
                    <div class="tw-mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <!-- location table-->
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('superadmin::lang.package_name'); ?></th>
                                        <th><?php echo app('translator')->get('superadmin::lang.start_date'); ?></th>
                                        <th><?php echo app('translator')->get('superadmin::lang.trial_end_date'); ?></th>
                                        <th><?php echo app('translator')->get('superadmin::lang.end_date'); ?></th>
                                        <th><?php echo app('translator')->get('superadmin::lang.paid_via'); ?></th>
                                        <th><?php echo app('translator')->get('superadmin::lang.payment_transaction_id'); ?></th>
                                        <th><?php echo app('translator')->get('lang_v1.created_at'); ?></th>
                                        <th><?php echo app('translator')->get('business.created_by'); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php $__currentLoopData = $business->subscriptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($subscription->package_details['name'], false); ?></td>
                                            <td>
                                                <?php if(!empty($subscription->start_date)): ?>
                                                    <?php echo e(\Carbon::createFromTimestamp(strtotime($subscription->start_date))->format(session('business.date_format')), false); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(!empty($subscription->trial_end_date)): ?>
                                                    <?php echo e(\Carbon::createFromTimestamp(strtotime($subscription->trial_end_date))->format(session('business.date_format')), false); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if(!empty($subscription->end_date)): ?>
                                                    <?php echo e(\Carbon::createFromTimestamp(strtotime($subscription->end_date))->format(session('business.date_format')), false); ?>

                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($subscription->paid_via, false); ?></td>
                                            <td><?php echo e($subscription->payment_transaction_id, false); ?></td>
                                            <td><?php echo e($subscription->created_at, false); ?></td>
                                            <td>
                                                <?php if(!empty($subscription->created_user)): ?>
                                                    <?php echo e($subscription->created_user->user_full_name, false); ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div
            class="tw-mt-5 tw-transition-all  lg:tw-col-span-1 tw-duration-200 tw-bg-white tw-shadow-sm tw-rounded-xl tw-ring-1 hover:tw-shadow-md  tw-ring-gray-200">
            <div class="tw-p-4 sm:tw-p-5">
                <div class="tw-flex tw-gap-2.5">
                    <strong><?php echo e(__('user.all_users'), false); ?></strong>
                </div>
                <div class="tw-flow-root tw-mt-5 tw-border-b tw-border-gray-200">
                    <div class="tw-mx-4 tw--my-2 tw-overflow-x-auto sm:tw--mx-5">
                        <div class="tw-inline-block tw-min-w-full tw-py-2 tw-align-middle sm:tw-px-5">
                            <!-- location table-->
                            <table class="table table-bordered table-striped" id="users_table">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('business.username'); ?></th>
                                        <th><?php echo app('translator')->get('user.name'); ?></th>
                                        <th><?php echo app('translator')->get('user.role'); ?></th>
                                        <th><?php echo app('translator')->get('business.email'); ?></th>
                                        <th><?php echo app('translator')->get('messages.action'); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('superadmin::business.update_password_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script type="text/javascript">
        //Roles table
        $(document).ready(function() {
            var users_table = $('#users_table').DataTable({
                processing: true,
                serverSide: true,
                fixedHeader:false,
                ajax: '/superadmin/users/' + "<?php echo e($business->id, false); ?>",
                columnDefs: [{
                    "targets": [4],
                    "orderable": false,
                    "searchable": false
                }],
                "columns": [{
                        "data": "username"
                    },
                    {
                        "data": "full_name"
                    },
                    {
                        "data": "role"
                    },
                    {
                        "data": "email"
                    },
                    {
                        "data": "action"
                    }
                ]
            });

        });

        $(document).on('click', '.update_user_password', function(e) {
            e.preventDefault();
            $('form#password_update_form, #user_id').val($(this).data('user_id'));
            $('span#user_name').text($(this).data('user_name'));
            $('#update_password_modal').modal('show');
        });

        password_update_form_validator = $('form#password_update_form').validate();

        $('#update_password_modal').on('hidden.bs.modal', function() {
            password_update_form_validator.resetForm();
            $('form#password_update_form')[0].reset();
        });

        $(document).on('submit', 'form#password_update_form', function(e) {
            e.preventDefault();
            $(this)
                .find('button[type="submit"]')
                .attr('disabled', true);
            var data = $(this).serialize();
            $.ajax({
                method: 'post',
                url: $(this).attr('action'),
                dataType: 'json',
                data: data,
                success: function(result) {
                    if (result.success == true) {
                        $('#update_password_modal').modal('hide');
                        toastr.success(result.msg);
                    } else {
                        toastr.error(result.msg);
                    }
                    $('form#password_update_form')
                        .find('button[type="submit"]')
                        .attr('disabled', false);
                },
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/gyannewsoftware/public_html/pos11_UltimatePOS65/Modules/Superadmin/Providers/../Resources/views/business/show.blade.php ENDPATH**/ ?>